/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class GearRPMSpeedRatio
extends Converter {
    protected float gear1Ratio;
    protected float gear2Ratio;
    protected float gear3Ratio;
    protected float gear4Ratio;
    protected float gear5Ratio;

    public GearRPMSpeedRatio(DataObject dataObject) {
        super(dataObject.getNodeKey(), 2);
    }

    protected GearRPMSpeedRatio(GearRPMSpeedRatio gearRPMSpeedRatio) {
        super(gearRPMSpeedRatio);
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        float f3 = f2 == 0.0f ? this.gear1Ratio * 1.5f : (2.0f * f / f2 < this.gear4Ratio + this.gear5Ratio ? this.gear5Ratio : (2.0f * f / f2 < this.gear3Ratio + this.gear4Ratio ? this.gear4Ratio : (2.0f * f / f2 < this.gear2Ratio + this.gear3Ratio ? this.gear3Ratio : (2.0f * f / f2 < this.gear1Ratio + this.gear2Ratio ? this.gear2Ratio : (2.0f * f / f2 < this.gear1Ratio * 2.3f ? this.gear1Ratio : f / f2)))));
        return f3;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.gear1Ratio = ConverterPrefs.getGear1Ratio(dataPreferences);
        this.gear2Ratio = ConverterPrefs.getGear2Ratio(dataPreferences);
        this.gear3Ratio = ConverterPrefs.getGear3Ratio(dataPreferences);
        this.gear4Ratio = ConverterPrefs.getGear4Ratio(dataPreferences);
        this.gear5Ratio = ConverterPrefs.getGear5Ratio(dataPreferences);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addGearRatioEditPrefs(arrayList, dataPreferences);
        EditPrefsSection editPrefsSection = new EditPrefsSection("Drivetrain", arrayList);
        if (!list.contains(editPrefsSection)) {
            list.add(editPrefsSection);
        }
    }

    @Override
    public Converter createCopy() {
        return new GearRPMSpeedRatio(this);
    }
}

