/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.device.data.prefsedit.TextEditPref;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

public class LinearBoost
extends Converter {
    float minVolts;
    float minPSIA;
    float maxVolts;
    float maxPSIA;
    static final String PREFS_KEY_MIN_VOLTS = "linboostminvolts";
    static final float DEFAULT_MIN_VOLTS = 0.0f;
    static final String PREFS_KEY_MIN_PSIA = "linboostminpsia";
    static final float DEFAULT_MIN_PSIA = 0.0f;
    static final String PREFS_KEY_MAX_VOLTS = "linboostmaxvolts";
    static final float DEFAULT_MAX_VOLTS = 5.0f;
    static final String PREFS_KEY_MAX_PSIA = "linboostmaxpsia";
    static final float DEFAULT_MAX_PSIA = 43.5f;
    static final String OLD_PREFS_KEY_MIN_VOLTS = "minVolts";
    static final String OLD_PREFS_KEY_MIN_PSIA = "minPSIA";
    static final String OLD_PREFS_KEY_MAX_VOLTS = "maxVolts";
    static final String OLD_PREFS_KEY_MAX_PSIA = "maxPSIA";
    float m;
    float b;

    public LinearBoost(DataObject dataObject) {
        super(dataObject.getNodeKey(), 1);
    }

    protected LinearBoost(LinearBoost linearBoost) {
        super(linearBoost);
        this.minVolts = linearBoost.minVolts;
        this.minPSIA = linearBoost.minPSIA;
        this.maxVolts = linearBoost.maxVolts;
        this.maxPSIA = linearBoost.maxPSIA;
    }

    @Override
    protected float convert(double d) {
        return this.m * this.inputBin[0] + this.b;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        dataPreferences.renameKey(OLD_PREFS_KEY_MIN_VOLTS, PREFS_KEY_MIN_VOLTS);
        dataPreferences.renameKey(OLD_PREFS_KEY_MAX_VOLTS, PREFS_KEY_MAX_VOLTS);
        dataPreferences.renameKey(OLD_PREFS_KEY_MIN_PSIA, PREFS_KEY_MIN_PSIA);
        dataPreferences.renameKey(OLD_PREFS_KEY_MAX_PSIA, PREFS_KEY_MAX_PSIA);
        this.minVolts = dataPreferences.getFloat(PREFS_KEY_MIN_VOLTS, 0.0f);
        this.minPSIA = dataPreferences.getFloat(PREFS_KEY_MIN_PSIA, 0.0f);
        this.maxVolts = dataPreferences.getFloat(PREFS_KEY_MAX_VOLTS, 5.0f);
        this.maxPSIA = dataPreferences.getFloat(PREFS_KEY_MAX_PSIA, 43.5f);
        if (this.maxVolts - this.minVolts == 0.0f) {
            this.b = this.m = 1.0E8f;
        } else {
            this.m = (this.maxPSIA - this.minPSIA) / (this.maxVolts - this.minVolts);
            this.b = this.minPSIA - this.m * this.minVolts;
        }
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList<TextEditPref> arrayList = new ArrayList<TextEditPref>();
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MIN_VOLTS, 0.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Min volts", "Lower voltage point for linear boost estimation", "v");
        textEditPref.installFinalClipFilter(-5.0f, 10.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MIN_PSIA, 0.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Min boost", "Lower boost value corresponding to lower voltage point", "psia");
        textEditPref.installFinalClipFilter(-1450.0f, 1450.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MAX_VOLTS, 5.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Max volts", "Higher voltage point for linear boost estimation", "v");
        textEditPref.installFinalClipFilter(-5.0f, 10.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MAX_PSIA, 43.5f);
        arrayList.add(textEditPref);
        textEditPref.set("Max boost", "Higher boost value corresponding to higher voltage point", "psia");
        textEditPref.installFinalClipFilter(-1450.0f, 1450.0f, 2);
        list.add(new EditPrefsSection("Linear boost", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new LinearBoost(this);
    }
}

