/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.device.data.prefsedit.TextEditPref;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

public class LinearFuelPress
extends Converter {
    float minVolts;
    float minPSIG;
    float maxVolts;
    float maxPSIG;
    static final String PREFS_KEY_MIN_VOLTS = "linfpminvolts";
    static final float DEFAULT_MIN_VOLTS = 0.0f;
    static final String PREFS_KEY_MIN_PSIG = "linfpminpsig";
    static final float DEFAULT_MIN_PSIG = -12.5f;
    static final String PREFS_KEY_MAX_VOLTS = "linfpmaxvolts";
    static final float DEFAULT_MAX_VOLTS = 5.0f;
    static final String PREFS_KEY_MAX_PSIG = "linfpmaxpsig";
    static final float DEFAULT_MAX_PSIG = 137.5f;
    float m;
    float b;

    public LinearFuelPress(DataObject dataObject) {
        super(dataObject.getNodeKey(), 1);
    }

    protected LinearFuelPress(LinearFuelPress linearFuelPress) {
        super(linearFuelPress);
        this.minVolts = linearFuelPress.minVolts;
        this.minPSIG = linearFuelPress.minPSIG;
        this.maxVolts = linearFuelPress.maxVolts;
        this.maxPSIG = linearFuelPress.maxPSIG;
    }

    @Override
    protected float convert(double d) {
        return this.m * this.inputBin[0] + this.b;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.minVolts = dataPreferences.getFloat(PREFS_KEY_MIN_VOLTS, 0.0f);
        this.minPSIG = dataPreferences.getFloat(PREFS_KEY_MIN_PSIG, -12.5f);
        this.maxVolts = dataPreferences.getFloat(PREFS_KEY_MAX_VOLTS, 5.0f);
        this.maxPSIG = dataPreferences.getFloat(PREFS_KEY_MAX_PSIG, 137.5f);
        if (this.maxVolts - this.minVolts == 0.0f) {
            this.b = this.m = 1.0E8f;
        } else {
            this.m = (this.maxPSIG - this.minPSIG) / (this.maxVolts - this.minVolts);
            this.b = this.minPSIG - this.m * this.minVolts;
        }
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList<TextEditPref> arrayList = new ArrayList<TextEditPref>();
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MIN_VOLTS, 0.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Min volts", "Lower voltage point for linear fuel pressure estimation", "v");
        textEditPref.installFinalClipFilter(-5.0f, 10.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MIN_PSIG, -12.5f);
        arrayList.add(textEditPref);
        textEditPref.set("Min fuel press", "Lower fuel pressure value corresponding to lower voltage point", "psi");
        textEditPref.installFinalClipFilter(-1000.0f, 1000.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MAX_VOLTS, 5.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Max volts", "Higher voltage point for fuel pressure estimation", "v");
        textEditPref.installFinalClipFilter(-5.0f, 10.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MAX_PSIG, 137.5f);
        arrayList.add(textEditPref);
        textEditPref.set("Max fuel press", "Higher fuel pressure value corresponding to higher voltage point", "psi");
        textEditPref.installFinalClipFilter(-1000.0f, 1000.0f, 2);
        list.add(new EditPrefsSection("Linear fuel pressure", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new LinearFuelPress(this);
    }
}

