/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.device.data.prefsedit.TextEditPref;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

public class LinearWideband
extends Converter {
    float minVolts;
    float minLambda;
    float maxVolts;
    float maxLambda;
    static final String PREFS_KEY_MIN_VOLTS = "linwbminvolts";
    static final float DEFAULT_MIN_VOLTS = 0.0f;
    static final String PREFS_KEY_MIN_LAMBDA = "linwbminlambda";
    static final float DEFAULT_MIN_LAMBDA = 0.6122449f;
    static final String PREFS_KEY_MAX_VOLTS = "linwbmaxvolts";
    static final float DEFAULT_MAX_VOLTS = 5.0f;
    static final String PREFS_KEY_MAX_LAMBDA = "linwbmaxlambda";
    static final float DEFAULT_MAX_LAMBDA = 1.2925171f;
    static final String OLD_PREFS_KEY_MIN_VOLTS = "minVolts";
    static final String OLD_PREFS_KEY_MIN_LAMBDA = "minLambda";
    static final String OLD_PREFS_KEY_MAX_VOLTS = "maxVolts";
    static final String OLD_PREFS_KEY_MAX_LAMBDA = "maxLambda";
    float m;
    float b;

    public LinearWideband(DataObject dataObject) {
        super(dataObject.getNodeKey(), 1);
    }

    protected LinearWideband(LinearWideband linearWideband) {
        super(linearWideband);
        this.minVolts = linearWideband.minVolts;
        this.minLambda = linearWideband.minLambda;
        this.maxVolts = linearWideband.maxVolts;
        this.maxLambda = linearWideband.maxLambda;
    }

    @Override
    protected float convert(double d) {
        return this.m * this.inputBin[0] + this.b;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        dataPreferences.renameKey(OLD_PREFS_KEY_MIN_VOLTS, PREFS_KEY_MIN_VOLTS);
        dataPreferences.renameKey(OLD_PREFS_KEY_MAX_VOLTS, PREFS_KEY_MAX_VOLTS);
        dataPreferences.renameKey(OLD_PREFS_KEY_MIN_LAMBDA, PREFS_KEY_MIN_LAMBDA);
        dataPreferences.renameKey(OLD_PREFS_KEY_MAX_LAMBDA, PREFS_KEY_MAX_LAMBDA);
        this.minVolts = dataPreferences.getFloat(PREFS_KEY_MIN_VOLTS, 0.0f);
        this.minLambda = dataPreferences.getFloat(PREFS_KEY_MIN_LAMBDA, 0.6122449f);
        this.maxVolts = dataPreferences.getFloat(PREFS_KEY_MAX_VOLTS, 5.0f);
        this.maxLambda = dataPreferences.getFloat(PREFS_KEY_MAX_LAMBDA, 1.2925171f);
        if (this.maxVolts - this.minVolts == 0.0f) {
            this.b = this.m = 1.0E8f;
        } else {
            this.m = (this.maxLambda - this.minLambda) / (this.maxVolts - this.minVolts);
            this.b = this.minLambda - this.m * this.minVolts;
        }
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList<TextEditPref> arrayList = new ArrayList<TextEditPref>();
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MIN_VOLTS, 0.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Min volts", "Lower voltage point for linear wideband estimation", "v");
        textEditPref.installFinalClipFilter(-5.0f, 10.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MIN_LAMBDA, 0.6122449f);
        arrayList.add(textEditPref);
        textEditPref.set("Min lambda", "Lower wideband lambda value corresponding to lower voltage point", "\u03bb");
        textEditPref.installFinalClipFilter(0.0f, 2.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MAX_VOLTS, 5.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Max volts", "Higher voltage point for linear wideband estimation", "v");
        textEditPref.installFinalClipFilter(-5.0f, 10.0f, 2);
        textEditPref = new TextEditPref((Preferences)dataPreferences, PREFS_KEY_MAX_LAMBDA, 1.2925171f);
        arrayList.add(textEditPref);
        textEditPref.set("Max lambda", "Higher wideband lambda value corresponding to higher voltage point", "\u03bb");
        textEditPref.installFinalClipFilter(0.0f, 2.0f, 2);
        list.add(new EditPrefsSection("Linear wideband", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new LinearWideband(this);
    }
}

