/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MilesPerGallon
extends Converter {
    protected int inputSmoothing;
    float[] prevMiles;
    float[] prevGallons;
    float sumMiles;
    float sumGal;
    int index;
    boolean firstTime;

    public MilesPerGallon(DataObject dataObject) {
        super(dataObject.getNodeKey(), 2);
    }

    protected MilesPerGallon(MilesPerGallon milesPerGallon) {
        super(milesPerGallon);
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        float f3 = (float)((double)f * d / 1000000.0 / 60.0) * 2.6417206E-4f;
        float f4 = (float)((double)f2 * d / 1000000.0 / 3600.0);
        if (this.firstTime) {
            Arrays.fill(this.prevGallons, f3);
            Arrays.fill(this.prevMiles, f4);
            this.sumMiles = (float)this.inputSmoothing * f4;
            this.sumGal = (float)this.inputSmoothing * f3;
            this.index = 0;
            this.firstTime = false;
        } else {
            this.sumMiles += f4 - this.prevMiles[this.index];
            this.sumGal += f3 - this.prevGallons[this.index];
            this.prevMiles[this.index] = f4;
            this.prevGallons[this.index++] = f3;
            if (this.index >= this.inputSmoothing) {
                this.index = 0;
            }
        }
        if (this.sumGal <= 0.0f) {
            if (this.sumMiles <= 0.0f) {
                return 0.0f;
            }
            return 1000.0f;
        }
        return this.sumMiles / this.sumGal;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.inputSmoothing = (int)ConverterPrefs.getMileageInputSmoothing(dataPreferences);
        this.prevMiles = new float[this.inputSmoothing];
        this.prevGallons = new float[this.inputSmoothing];
        this.firstTime = true;
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addMileageInputSmoothingEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Mileage", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new MilesPerGallon(this);
    }
}

