/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Base;
import com.ecmtuning.ecmlink.device.data.converter.Converter;

public class RolloverCounter
extends Base {
    private static final String PROP_NAME_ROLLOVER = "converter.rollover";
    float count = 0.0f;
    float previous = 0.0f;
    float rollover = 0.0f;
    boolean firstTime = true;

    public RolloverCounter(DataObject dataObject) {
        super(dataObject);
        this.rollover = dataObject.getFloat(PROP_NAME_ROLLOVER, new Float(0.0f)).floatValue();
    }

    protected RolloverCounter(RolloverCounter rolloverCounter) {
        super(rolloverCounter);
        this.count = rolloverCounter.count;
        this.previous = rolloverCounter.previous;
        this.rollover = rolloverCounter.rollover;
        this.firstTime = rolloverCounter.firstTime;
    }

    @Override
    protected float _convert(double d, float f) {
        if (this.firstTime) {
            this.count = 0.0f;
            this.firstTime = false;
        } else {
            this.count += f - this.previous;
            if (f < this.previous) {
                this.count += this.rollover;
            }
        }
        this.previous = f;
        return this.count;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.firstTime = true;
    }

    @Override
    public Converter createCopy() {
        return new RolloverCounter(this);
    }
}

