/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Averager;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class SDAirflowGmPR
extends Converter {
    protected final Averager avg = new Averager();
    float displacementl = 2.0f;

    public SDAirflowGmPR(DataObject dataObject) {
        super(dataObject.getNodeKey(), 3);
    }

    protected SDAirflowGmPR(SDAirflowGmPR sDAirflowGmPR) {
        super(sDAirflowGmPR);
        this.displacementl = sDAirflowGmPR.displacementl;
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        float f3 = this.inputBin[2];
        float f4 = f * 6.8947573f;
        float f5 = this.displacementl / 2.0f;
        return this.avg.next(0.011684185f * f2 * f5 * f4 * f3);
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.displacementl = ConverterPrefs.getDisplacementLiters(dataPreferences);
        this.avg.reset(0.2f);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addDisplacementEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Engine", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new SDAirflowGmPR(this);
    }
}

