/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Base;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class Speed
extends Base {
    float correction = 1.0f;

    public Speed(DataObject dataObject) {
        super(dataObject);
    }

    protected Speed(Speed speed) {
        super(speed);
        this.correction = speed.correction;
    }

    @Override
    protected float _convert(double d, float f) {
        return f * this.correction;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.correction = ConverterPrefs.getSpeedCorrection(dataPreferences);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addSpeedCorrectionEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Speed", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new Speed(this);
    }
}

