/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Averager;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Torque
extends Converter {
    protected final Averager avg = new Averager();
    protected float outputSmoothing;
    protected int inputSmoothing;
    protected float gear1Ratio;
    protected float gear2Ratio;
    protected float gear3Ratio;
    protected float gear4Ratio;
    protected float gear5Ratio;
    protected float drivetrainLoss;
    protected float vehicleMassKg;
    boolean firstTime = true;
    float previousAccelmps2;
    float previousRpmPermps;
    float[] prevVelocitymps;
    float[] prevCrankTimeSec;
    int index;

    public Torque(DataObject dataObject) {
        super(dataObject.getNodeKey(), 3);
    }

    protected Torque(Torque torque) {
        super(torque);
    }

    @Override
    protected float convert(double d) {
        float f;
        float f2 = this.inputBin[0];
        float f3 = this.inputBin[1] / 1000.0f;
        float f4 = this.inputBin[2];
        float f5 = f4 == 0.0f ? this.gear1Ratio * 1.5f : (2.0f * f2 / f4 < this.gear4Ratio + this.gear5Ratio ? this.gear5Ratio : (2.0f * f2 / f4 < this.gear3Ratio + this.gear4Ratio ? this.gear4Ratio : (2.0f * f2 / f4 < this.gear2Ratio + this.gear3Ratio ? this.gear3Ratio : (2.0f * f2 / f4 < this.gear1Ratio + this.gear2Ratio ? this.gear2Ratio : (2.0f * f2 / f4 < this.gear1Ratio * 2.3f ? this.gear1Ratio : f2 / f4)))));
        float f6 = f5 / 1.609344f;
        float f7 = 3.6f * f6;
        float f8 = 60.0f / f7;
        float f9 = f2 / f7;
        if (this.firstTime) {
            f = 0.0f;
            this.firstTime = false;
        } else {
            float f10 = f3 - this.prevCrankTimeSec[this.index];
            f = f10 <= 0.0f ? this.previousAccelmps2 : (f9 - this.prevVelocitymps[this.index]) / f10;
            this.prevVelocitymps[this.index] = f9;
            this.prevCrankTimeSec[this.index++] = f3;
            if (this.index >= this.inputSmoothing) {
                this.index = 0;
            }
        }
        if (f <= 0.0f || this.previousRpmPermps != f7) {
            f = 0.0f;
            Arrays.fill(this.prevVelocitymps, f9);
            Arrays.fill(this.prevCrankTimeSec, f3);
            this.index = 0;
        }
        this.previousAccelmps2 = f;
        this.previousRpmPermps = f7;
        float f11 = 0.2146f * f9 * f9 * 1.24f;
        float f12 = 0.14709975f * this.vehicleMassKg;
        float f13 = this.vehicleMassKg * f + f11 + f12;
        float f14 = f13 * f8 / 61.616997f / (this.drivetrainLoss != 1.0f ? 1.0f - this.drivetrainLoss : 1.0f);
        return this.avg.next(f14 * 7.2330136f);
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.firstTime = true;
        this.gear1Ratio = ConverterPrefs.getGear1Ratio(dataPreferences);
        this.gear2Ratio = ConverterPrefs.getGear2Ratio(dataPreferences);
        this.gear3Ratio = ConverterPrefs.getGear3Ratio(dataPreferences);
        this.gear4Ratio = ConverterPrefs.getGear4Ratio(dataPreferences);
        this.gear5Ratio = ConverterPrefs.getGear5Ratio(dataPreferences);
        this.drivetrainLoss = ConverterPrefs.getDrivetrainLoss(dataPreferences);
        this.vehicleMassKg = ConverterPrefs.getVehicleMass(dataPreferences) * 0.45359236f;
        this.inputSmoothing = (int)ConverterPrefs.getTorqueInputSmoothing(dataPreferences);
        this.prevVelocitymps = new float[this.inputSmoothing];
        this.prevCrankTimeSec = new float[this.inputSmoothing];
        this.outputSmoothing = ConverterPrefs.getTorqueOutputSmoothing(dataPreferences);
        this.avg.reset(this.outputSmoothing);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addGearRatioEditPrefs(arrayList, dataPreferences);
        ConverterPrefs.addDrivetrainLossEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Drivetrain", arrayList));
        arrayList = new ArrayList();
        ConverterPrefs.addVehicleMassEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Vehicle mass", arrayList));
        arrayList = new ArrayList();
        ConverterPrefs.addTorqueInputSmoothingEditPrefs(arrayList, dataPreferences);
        ConverterPrefs.addTorqueOutputSmoothingEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("HP/Torque", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new Torque(this);
    }
}

