/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Averager;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import java.util.ArrayList;
import java.util.List;

public class TorqueFromG
extends Converter {
    protected final Averager avg = new Averager();
    protected float outputSmoothing;
    protected float drivetrainLoss;
    protected float vehicleMassKg;

    public TorqueFromG(DataObject dataObject) {
        super(dataObject.getNodeKey(), 3);
    }

    protected TorqueFromG(TorqueFromG torqueFromG) {
        super(torqueFromG);
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        float f3 = this.inputBin[2];
        float f4 = f3 / 1.609344f;
        float f5 = 3.6f * f4;
        float f6 = 60.0f / f5;
        float f7 = f / f5;
        float f8 = f2 > 0.0f ? f2 * 9.80665f : 0.0f;
        float f9 = 0.2146f * f7 * f7 * 1.24f;
        float f10 = 0.14709975f * this.vehicleMassKg;
        float f11 = this.vehicleMassKg * f8 + f9 + f10;
        float f12 = f11 * f6 / 61.616997f / (this.drivetrainLoss != 1.0f ? 1.0f - this.drivetrainLoss : 1.0f);
        return this.avg.next(f12 * 7.2330136f);
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.drivetrainLoss = ConverterPrefs.getDrivetrainLoss(dataPreferences);
        this.vehicleMassKg = ConverterPrefs.getVehicleMass(dataPreferences) * 0.45359236f;
        this.outputSmoothing = ConverterPrefs.getTorqueOutputSmoothing(dataPreferences);
        this.avg.reset(this.outputSmoothing);
    }

    @Override
    public void addEditPrefsSections(List list, DataPreferences dataPreferences) {
        ArrayList arrayList = new ArrayList();
        ConverterPrefs.addDrivetrainLossEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Drag", arrayList));
        arrayList = new ArrayList();
        ConverterPrefs.addVehicleMassEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("Vehicle mass", arrayList));
        arrayList = new ArrayList();
        ConverterPrefs.addTorqueOutputSmoothingEditPrefs(arrayList, dataPreferences);
        list.add(new EditPrefsSection("HP/Torque", arrayList));
    }

    @Override
    public Converter createCopy() {
        return new TorqueFromG(this);
    }
}

