/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.converter.Converter;

public class TotalMPG
extends Converter {
    float miles = 0.0f;
    float gallons = 0.0f;
    double lastTimeMicros = 0.0;

    public TotalMPG(DataObject dataObject) {
        super(dataObject.getNodeKey(), 2);
    }

    protected TotalMPG(TotalMPG totalMPG) {
        super(totalMPG);
        this.miles = totalMPG.miles;
        this.gallons = totalMPG.gallons;
        this.lastTimeMicros = totalMPG.lastTimeMicros;
    }

    @Override
    protected float convert(double d) {
        float f = this.inputBin[0];
        float f2 = this.inputBin[1];
        if (d <= 0.0) {
            this.lastTimeMicros = d;
            if (f <= 0.0f) {
                if (f2 <= 0.0f) {
                    return 0.0f;
                }
                return 100.0f;
            }
            return f2 / (f / 63.09f);
        }
        this.miles = (float)((double)this.miles + (double)f2 * (d - this.lastTimeMicros) / 3.6E9);
        this.gallons = (float)((double)this.gallons + (double)f / 63.09 * (d - this.lastTimeMicros) / 3.6E9);
        this.lastTimeMicros = d;
        if (this.gallons <= 0.0f) {
            if (this.miles <= 0.0f) {
                return 0.0f;
            }
            return 100.0f;
        }
        return this.miles / this.gallons;
    }

    @Override
    public void loopReset(DataPreferences dataPreferences) {
        this.miles = 0.0f;
        this.gallons = 0.0f;
    }

    @Override
    public Converter createCopy() {
        return new TotalMPG(this);
    }
}

