/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.converter;

import com.ecmtuning.ecmlink.device.data.DataObject;
import com.ecmtuning.ecmlink.device.data.converter.Base;
import com.ecmtuning.ecmlink.device.data.converter.Converter;
import com.ecmtuning.ecmlink.util.BasicStrings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class XYMap
extends Base {
    private static final String PROP_NAME_MAP = "converter.map";
    private final float[] xVals;
    private final float[] yVals;
    private final float minXVal;
    private final float minYVal;
    private final float maxXVal;
    private final float maxYVal;

    public XYMap(DataObject dataObject) {
        super(dataObject);
        Object object;
        int n;
        String string = dataObject.getString(PROP_NAME_MAP);
        if (string == null) {
            throw new IllegalArgumentException("Must define map property");
        }
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Map property is invalid");
        }
        ArrayList<XYEntry> arrayList = new ArrayList<XYEntry>();
        for (n = 0; n < stringArray.length; ++n) {
            object = BasicStrings.trimAll(stringArray[n].split("="));
            if (((String[])object).length != 2) {
                throw new IllegalArgumentException("Invalid map entry '" + stringArray[n] + "'");
            }
            XYEntry xYEntry = new XYEntry();
            xYEntry.x = DataObject.decodeFloat(object[0]).floatValue();
            xYEntry.y = DataObject.decodeFloat(object[1]).floatValue();
            arrayList.add(xYEntry);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                XYEntry xYEntry = (XYEntry)object;
                XYEntry xYEntry2 = (XYEntry)object2;
                if (xYEntry.x < xYEntry2.x) {
                    return -1;
                }
                if (xYEntry.x == xYEntry2.x) {
                    return 0;
                }
                return 1;
            }
        });
        this.xVals = new float[arrayList.size()];
        this.yVals = new float[arrayList.size()];
        for (n = 0; n < this.xVals.length; ++n) {
            object = (XYEntry)arrayList.get(n);
            this.xVals[n] = object.x;
            this.yVals[n] = object.y;
            if (n <= 0 || this.xVals[n] != this.xVals[n - 1]) continue;
            throw new IllegalArgumentException("Found equal X values.  This is not allowed.");
        }
        this.minXVal = this.xVals[0];
        this.minYVal = this.yVals[0];
        this.maxXVal = this.xVals[this.xVals.length - 1];
        this.maxYVal = this.yVals[this.yVals.length - 1];
    }

    protected XYMap(XYMap xYMap) {
        super(xYMap);
        this.xVals = xYMap.xVals;
        this.yVals = xYMap.yVals;
        this.minXVal = xYMap.minXVal;
        this.minYVal = xYMap.minYVal;
        this.maxXVal = xYMap.maxXVal;
        this.maxYVal = xYMap.maxYVal;
    }

    @Override
    protected float _convert(double d, float f) {
        if (f <= this.minXVal) {
            return this.minYVal;
        }
        if (f >= this.maxXVal) {
            return this.maxYVal;
        }
        int n = Arrays.binarySearch(this.xVals, f);
        if (n >= 0) {
            return this.yVals[n];
        }
        n = -(n + 1);
        float f2 = this.xVals[n - 1];
        float f3 = this.xVals[n];
        float f4 = this.yVals[n - 1];
        float f5 = this.yVals[n];
        return f4 + (f - f2) * (f5 - f4) / (f3 - f2);
    }

    @Override
    public Converter createCopy() {
        return new XYMap(this);
    }

    private static class XYEntry {
        float x;
        float y;

        private XYEntry() {
        }
    }
}

