/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.data.prefsedit;

import com.ecmtuning.ecmlink.device.data.prefsedit.DataPreferencesAdapter;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.action.ActionReader;
import com.jgoodies.uif.component.UIFButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public abstract class EditPref {
    protected final Object defaultValue;
    protected final String key;
    protected final BufferedValueModel bufferedModel;
    protected String labelText;
    protected String unitText;
    protected JComponent labelComponent;
    protected JComponent unitComponent;
    protected JComponent valueComponent;
    protected String toolTipText;
    protected UIFButton defBtn;
    protected static final Trigger DUMMY_TRIGGER = new Trigger();

    public EditPref(Preferences preferences, String string, Object object) {
        this.key = string;
        this.defaultValue = object instanceof Class ? null : object;
        DataPreferencesAdapter dataPreferencesAdapter = new DataPreferencesAdapter(preferences, string, object);
        this.bufferedModel = new BufferedValueModel((ValueModel)dataPreferencesAdapter, (ValueModel)DUMMY_TRIGGER);
    }

    public EditPref() {
        this.key = null;
        this.defaultValue = null;
        this.bufferedModel = null;
    }

    public BufferedValueModel getBufferedValueModel() {
        return this.bufferedModel;
    }

    public void installComponents(PanelBuilder panelBuilder, ValueModel valueModel) {
        if (this.bufferedModel != null) {
            this.bufferedModel.setTriggerChannel(valueModel);
        }
        panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
        this.addLabel(panelBuilder);
        panelBuilder.nextColumn(2);
        this.addValue(panelBuilder);
        panelBuilder.nextColumn(2);
        this.addUnits(panelBuilder);
        panelBuilder.nextLine(2);
    }

    protected void addLabel(PanelBuilder panelBuilder) {
        if (this.labelComponent != null) {
            panelBuilder.add((Component)this.labelComponent);
        } else if (this.labelText != null) {
            panelBuilder.addLabel(this.labelText);
        }
    }

    protected void addValue(PanelBuilder panelBuilder) {
        if (this.valueComponent != null) {
            panelBuilder.add((Component)this.valueComponent);
            if (this.toolTipText != null) {
                this.valueComponent.setToolTipText(this.toolTipText);
            }
        }
    }

    protected void addUnits(PanelBuilder panelBuilder) {
        if (this.unitComponent != null) {
            panelBuilder.add((Component)this.unitComponent);
        } else if (this.unitText != null) {
            panelBuilder.addLabel(this.unitText);
        }
    }

    protected void installDefaultSelectAction(AbstractButton abstractButton) {
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPref.this.bufferedModel.setValue(EditPref.this.defaultValue);
            }
        });
    }

    public static PanelBuilder createPanelBuilder() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.DEFAULT_PREF_GROW_ROWSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        return panelBuilder;
    }

    public static void addPrefsSection(String string, List list, PanelBuilder panelBuilder, ValueModel valueModel) {
        EditPref.addPrefsSection(new EditPrefsSection(string, list), panelBuilder, valueModel);
    }

    public static void addPrefsSection(EditPrefsSection editPrefsSection, PanelBuilder panelBuilder, ValueModel valueModel) {
        String string = editPrefsSection.getHeadingText();
        List list = editPrefsSection.getEditPrefs();
        if (string != null) {
            panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
            panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
            panelBuilder.addSeparator(string);
            panelBuilder.nextLine(2);
        }
        for (EditPref editPref : list) {
            editPref.installComponents(panelBuilder, valueModel);
        }
    }

    public void set(String string, String string2, String string3) {
        this.setLabelText(string);
        this.setToolTipText(string2);
        this.setUnitText(string3);
    }

    public void configureLabelAndTooltip(ResourceBundle resourceBundle, String string) {
        String string2 = ActionReader.getString((ResourceBundle)resourceBundle, (String)(string + ".label"), (String)string);
        String string3 = ActionReader.getString((ResourceBundle)resourceBundle, (String)(string + ".tooltip"), null);
        this.setLabelText(string2);
        if (string3 != null) {
            this.setToolTipText(string3);
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String string) {
        this.labelText = string;
    }

    public JComponent getLabelComponent() {
        return this.labelComponent;
    }

    public void setLabelComponent(JComponent jComponent) {
        this.labelComponent = jComponent;
    }

    public JComponent getUnitComponent() {
        return this.unitComponent;
    }

    public void setUnitComponent(JComponent jComponent) {
        this.unitComponent = jComponent;
    }

    public String getUnitText() {
        return this.unitText;
    }

    public void setUnitText(String string) {
        this.unitText = string;
    }

    public void installDefaultBtn(String string) {
        this.defBtn = new UIFButton("X");
        String string2 = "Resest to default";
        if (string != null) {
            string2 = string2 + " value of '" + string + "'";
        }
        this.defBtn.setToolTipText(string2);
        this.defBtn.setNarrow(true);
        this.installDefaultSelectAction((AbstractButton)this.defBtn);
        this.setUnitComponent((JComponent)this.defBtn);
    }

    public JComponent getValueComponent() {
        return this.valueComponent;
    }

    public void setValueComponent(JComponent jComponent) {
        this.valueComponent = jComponent;
    }
}

