/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceCommand;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECMLinkCommand
extends DeviceCommand {
    public static final int COMMBUFF_MAX_LENGTH = 104;
    public static final int READBYTES_BLOCK_SIZE = 96;
    public static final int SETBYTES_BLOCK_SIZE = 92;
    public static final int MAX_V3_ADDR_CNT = 48;
    public static final int CMDID_NULL = 0;
    public static final int CMDID_SETLOC = 1;
    public static final int CMDID_GETLOC = 2;
    public static final int CMDID_SETTABLE = 3;
    public static final int CMDID_GETTABLE = 4;
    public static final int CMDID_GETBASE = 5;
    public static final int CMDID_STREAMON = 6;
    public static final int CMDID_STREAMOFF = 7;
    public static final int CMDID_SETUP = 8;
    public static final int CMDID_GETERRORS = 9;
    public static final int CMDID_FLASHMODE = 10;
    public static final int CMDID_SAVECONFIG = 11;
    public static final int CMDID_READBYTES = 12;
    public static final int CMDID_STREAM = 143;
    public static final int CMDID_RESP_BIT = 128;
    public static final int CMDID_RESP_BIT_CLR_MASK = 127;
    public static final int XCMDID_CHKSUM = 32;
    public static final int XCMDID_ERASESEG = 33;
    public static final int XCMDID_COPYBLK = 34;
    public static final int XCMDID_FLASHBLK = 35;
    public static final int XCMDID_REBOOT = 36;
    public static final int XCMDID_CMPSEC = 37;
    public static final int XCMDID_READBLK = 38;
    private int[] rawBytes;
    private int rawBytesCnt;
    private boolean framed;
    private int cmdId;
    private static Logger parseLogger = Logger.getLogger(ECMLinkCommand.class.getName());
    private static final boolean loggingFinest = parseLogger.isLoggable(Level.FINEST);
    private static final boolean loggingFiner = parseLogger.isLoggable(Level.FINER);
    private static final boolean loggingFine = parseLogger.isLoggable(Level.FINE);
    public static final int MAX_PARSE_BUFFER_LENGTH = 16384;
    private static int[] parseBuffer = new int[16384];
    private static int parseBufferCurrIndx = 0;
    private static int parseBufferLen = 0;
    private static int parseBufferExpectedEndIndx;
    private static int syncByteIndx;
    private static long lastSyncByteRcvMillis;
    static boolean retryingCmd;
    static final int STATE_PARSE_FAILURE = -1;
    static final int STATE_NEED_SYNC_BYTE = 0;
    static final int STATE_NEED_LEN_BYTE = 1;
    static final int STATE_NEED_CMD_BYTE = 2;
    static final int STATE_WAIT_LEN_BYTES = 3;
    static final int STATE_COMMAND_DONE = 4;
    private static int currentState;

    protected ECMLinkCommand(int n) {
        this.rawBytes = new int[512];
        this.rawBytes[0] = 90;
        this.rawBytes[1] = 0;
        this.rawBytes[2] = n;
        this.rawBytesCnt = 3;
        this.cmdId = n;
    }

    private ECMLinkCommand(int[] nArray, int n, int n2) {
        this.rawBytes = new int[n2];
        System.arraycopy(nArray, n, this.rawBytes, 0, n2);
        this.cmdId = this.rawBytes[2];
        this.framed = true;
        this.rawBytesCnt = n2;
    }

    public int getCmdId() {
        return this.cmdId;
    }

    public boolean isResponseCmd() {
        return (this.getCmdId() & 0x80) == 128;
    }

    public boolean isEngineStopRequired() {
        return this.cmdId == 32 || this.cmdId == 33 || this.cmdId == 34 || this.cmdId == 35 || this.cmdId == 36 || this.cmdId == 37 || this.cmdId == 38;
    }

    public int getPayload8Bits(int n) {
        if (n + 4 >= this.rawBytes.length) {
            return -1;
        }
        return this.rawBytes[n + 3];
    }

    public int getPayload16Bits(int n) {
        if (n + 5 >= this.rawBytes.length) {
            return -1;
        }
        return this.rawBytes[n + 3] * 256 + this.rawBytes[n + 4];
    }

    public int getPayloadLength() {
        if (this.rawBytes.length < 4) {
            return -1;
        }
        return this.rawBytes.length - 4;
    }

    public int[] getRawBytes() {
        this.frameIfNeeded();
        int[] nArray = new int[this.rawBytesCnt];
        System.arraycopy(this.rawBytes, 0, nArray, 0, this.rawBytesCnt);
        return nArray;
    }

    public int[] getPayloadBytes() {
        this.frameIfNeeded();
        if (this.rawBytesCnt < 4) {
            throw new IllegalStateException("Invalid payload size in command");
        }
        int[] nArray = new int[this.rawBytesCnt - 4];
        System.arraycopy(this.rawBytes, 3, nArray, 0, this.rawBytesCnt - 4);
        return nArray;
    }

    public int copyPayloadBytes(int[] nArray) {
        this.frameIfNeeded();
        if (this.rawBytesCnt < 4) {
            throw new IllegalStateException("Invalid payload size in command");
        }
        System.arraycopy(this.rawBytes, 3, nArray, 0, this.rawBytesCnt - 4);
        return this.rawBytesCnt - 4;
    }

    public int getChecksum() {
        this.frameIfNeeded();
        return this.rawBytes[this.rawBytesCnt - 1];
    }

    public void addAddrBits(int n, int n2) {
        if (ECMLinkDeviceMap.isV3Device(n)) {
            this.add16Bits(n2);
        } else if (n2 < 240) {
            this.add8Bits(n2);
        } else {
            this.add16Bits(n2);
        }
    }

    public void add8Bits(int n) {
        this.unframeIfNeeded();
        if (n < -128) {
            n = -128;
        } else if (n > 255) {
            n = 255;
        }
        this.rawBytes[this.rawBytesCnt++] = n;
    }

    public void add16Bits(int n) {
        this.unframeIfNeeded();
        if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        } else if (n > 65535) {
            n = 65535;
        }
        this.rawBytes[this.rawBytesCnt++] = (n & 0xFF00) >> 8;
        this.rawBytes[this.rawBytesCnt++] = n & 0xFF;
    }

    public void addBytes(int[] nArray) {
        this.unframeIfNeeded();
        for (int i = 0; i < nArray.length; ++i) {
            this.rawBytes[this.rawBytesCnt++] = nArray[i] & 0xFF;
        }
    }

    private int calcChecksum() {
        this.unframeIfNeeded();
        int n = 0;
        for (int i = 0; i < this.rawBytesCnt; ++i) {
            n += this.rawBytes[i];
            n &= 0xFF;
        }
        return n;
    }

    protected void frameIfNeeded() {
        if (this.framed) {
            return;
        }
        int n = this.rawBytesCnt - 1;
        if (n > 127 && n < 256) {
            n = 2;
        } else if (n > 383) {
            n = 2;
        } else if (n >= 256) {
            n &= 0x7F;
            n |= 0x80;
        }
        this.rawBytes[1] = n;
        this.rawBytes[this.rawBytesCnt] = this.calcChecksum();
        ++this.rawBytesCnt;
        this.framed = true;
    }

    private void unframeIfNeeded() {
        if (this.framed) {
            --this.rawBytesCnt;
        }
        this.framed = false;
    }

    protected static synchronized void resetParseBuffer() {
        if (loggingFinest) {
            parseLogger.finest("Parse buffer reset");
        }
        parseBufferCurrIndx = 0;
        parseBufferLen = 0;
        currentState = 0;
    }

    static long getLastSyncByteRcvMillis() {
        return lastSyncByteRcvMillis;
    }

    protected static synchronized ECMLinkCommand parseIncomingData(int[] nArray, int n) {
        if (currentState == 0) {
            if (parseBufferCurrIndx >= parseBufferLen) {
                ECMLinkCommand.resetParseBuffer();
            } else if (parseBufferCurrIndx > 0) {
                int n2 = parseBufferLen - parseBufferCurrIndx;
                System.arraycopy(parseBuffer, parseBufferCurrIndx, parseBuffer, 0, n2);
                parseBufferCurrIndx = 0;
                parseBufferLen = n2;
            }
        }
        if (parseBufferLen + n < parseBuffer.length) {
            System.arraycopy(nArray, 0, parseBuffer, parseBufferLen, n);
            parseBufferLen += n;
        }
        return ECMLinkCommand.parseExistingData();
    }

    protected static ECMLinkCommand parseExistingData() {
        ECMLinkCommand.doState();
        if (currentState == 4) {
            currentState = 0;
            if (loggingFiner) {
                parseLogger.finer("Command parsed successfully!");
                if (loggingFinest) {
                    parseLogger.finest("syncByteIndx: " + syncByteIndx + ", currIndx: " + parseBufferCurrIndx);
                }
            }
            return new ECMLinkCommand(parseBuffer, syncByteIndx, parseBufferCurrIndx - syncByteIndx);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized void doState() {
        while (parseBufferCurrIndx < parseBufferLen) {
            block27: {
                int n;
                int n2;
                if (loggingFinest) {
                    parseLogger.finest("Before state=" + currentState + ", index=" + parseBufferCurrIndx + ", data=0x" + XFormatter.toHex2(parseBuffer[parseBufferCurrIndx]) + " (" + parseBuffer[parseBufferCurrIndx] + ")");
                }
                switch (currentState) {
                    case 0: {
                        if (parseBuffer[parseBufferCurrIndx] == 90) {
                            syncByteIndx = parseBufferCurrIndx;
                            currentState = 1;
                            lastSyncByteRcvMillis = System.currentTimeMillis();
                        }
                        break block27;
                    }
                    case 1: {
                        if (parseBuffer[parseBufferCurrIndx] == 90) {
                            syncByteIndx = parseBufferCurrIndx;
                            break block27;
                        } else {
                            if (parseBufferCurrIndx == syncByteIndx + 1) {
                                n2 = parseBuffer[parseBufferCurrIndx];
                                if (n2 < 2) {
                                    parseLogger.info("Invalid length of " + n2 + " received!");
                                    currentState = -1;
                                    break;
                                }
                                if ((n2 & 0x80) == 128) {
                                    n2 &= 0x7F;
                                    n2 |= 0x100;
                                }
                                parseBufferExpectedEndIndx = syncByteIndx + n2 + 1;
                                if (loggingFinest) {
                                    parseLogger.finest("Expecting to read " + n2);
                                }
                                currentState = 2;
                                break;
                            }
                            parseLogger.info("Internal parse failure, STATE_NEED_LEN_BYTE");
                            currentState = -1;
                            break;
                        }
                    }
                    case 2: {
                        if (parseBufferCurrIndx == syncByteIndx + 2) {
                            n2 = parseBuffer[parseBufferCurrIndx];
                            n = parseBufferExpectedEndIndx - syncByteIndx;
                            if (ECMLinkCommand.validCommandLength(n2, n)) {
                                currentState = 3;
                                break;
                            }
                            parseLogger.info("Invalid length received, cmdId=" + n2 + ", len=" + n);
                            if (n > 256 && !retryingCmd) {
                                parseLogger.info("Trying again.");
                                parseBufferExpectedEndIndx = --syncByteIndx + 90 + 1;
                                --parseBufferCurrIndx;
                                --parseBufferCurrIndx;
                                retryingCmd = true;
                                break block27;
                            } else {
                                currentState = -1;
                                break;
                            }
                        }
                        currentState = -1;
                        break;
                    }
                    case 3: {
                        if (parseBufferCurrIndx < parseBufferExpectedEndIndx) break;
                        currentState = 4;
                        break;
                    }
                    default: {
                        parseLogger.info("Invalid parse state: " + currentState);
                        currentState = -1;
                    }
                }
                if (loggingFinest) {
                    parseLogger.finest("After state=" + currentState + ", index=" + parseBufferCurrIndx + ", data=" + parseBuffer[parseBufferCurrIndx]);
                }
                if (currentState == 4) {
                    retryingCmd = false;
                    n2 = 0;
                    for (n = syncByteIndx; n < parseBufferCurrIndx; n2 &= 0xFF, ++n) {
                        n2 += parseBuffer[n];
                    }
                    if (n2 == parseBuffer[parseBufferCurrIndx]) {
                        if ((parseBuffer[syncByteIndx + 2] & 0x80) == 128) {
                            ++parseBufferCurrIndx;
                            return;
                        }
                        currentState = 0;
                    } else {
                        parseLogger.info("Checksum match failed!  Restarting parser.");
                        currentState = -1;
                    }
                }
                if (currentState == -1) {
                    currentState = 0;
                    parseBufferCurrIndx = syncByteIndx;
                    if (retryingCmd) {
                        ++parseBufferCurrIndx;
                        retryingCmd = false;
                    }
                }
            }
            ++parseBufferCurrIndx;
        }
    }

    private static boolean validCommandLength(int n, int n2) {
        ++n2;
        if ((n & 0x80) == 128) {
            return ECMLinkCommand.validRespCommandLength(n & 0x7F, n2);
        }
        return ECMLinkCommand.validReqCommandLength(n, n2);
    }

    private static boolean validReqCommandLength(int n, int n2) {
        if (n2 > 104 && n != 35) {
            return false;
        }
        boolean bl = false;
        switch (n) {
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                bl = n2 == 4;
                break;
            }
            case 6: {
                bl = n2 == 4 | n2 == 6;
                break;
            }
            case 9: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                bl = n2 == 5;
                break;
            }
            case 38: {
                bl = n2 == 6;
                break;
            }
            case 1: {
                bl = n2 >= 6;
                break;
            }
            case 2: {
                bl = n2 == 6 || n2 == 7 || n2 == 8;
                break;
            }
            case 12: 
            case 34: {
                bl = n2 == 7;
                break;
            }
            case 35: {
                bl = n2 == 265;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static boolean validRespCommandLength(int n, int n2) {
        if (n2 > 104 && n != 38) {
            return false;
        }
        boolean bl = false;
        switch (n) {
            case 3: 
            case 7: 
            case 11: 
            case 36: {
                bl = n2 == 4;
                break;
            }
            case 6: {
                bl = n2 == 4 | n2 == 5;
                break;
            }
            case 1: {
                bl = n2 == 4 | n2 == 5;
                break;
            }
            case 12: {
                bl = n2 > 4 && n2 <= 104;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                bl = n2 == 5;
                break;
            }
            case 10: {
                bl = n2 == 6;
                break;
            }
            case 2: {
                bl = n2 >= 5;
                break;
            }
            case 32: {
                bl = n2 == 36;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 15: {
                bl = true;
                break;
            }
            case 38: {
                bl = n2 == 263 || n2 == 5;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private String getDescriptiveCommandId() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getCmdId() & 0x7F;
        switch (n) {
            case 0: {
                stringBuffer.append("NULL");
                break;
            }
            case 1: {
                stringBuffer.append("SET_LOC");
                break;
            }
            case 2: {
                stringBuffer.append("GET_LOC");
                break;
            }
            case 3: {
                stringBuffer.append("SET_TABLE");
                break;
            }
            case 15: {
                stringBuffer.append("STREAM");
                break;
            }
            case 9: {
                stringBuffer.append("GET_ERRORS");
                break;
            }
            case 10: {
                stringBuffer.append("FLASHMODE");
                break;
            }
            case 4: {
                stringBuffer.append("GET_TABLE");
                break;
            }
            case 5: {
                stringBuffer.append("GET_BASE");
                break;
            }
            case 6: {
                stringBuffer.append("STREAM_ON");
                break;
            }
            case 7: {
                stringBuffer.append("STREAM_OFF");
                break;
            }
            case 8: {
                stringBuffer.append("SETUP");
                break;
            }
            case 32: {
                stringBuffer.append("CHKSUM");
                break;
            }
            case 33: {
                stringBuffer.append("ERASESEG");
                break;
            }
            case 37: {
                stringBuffer.append("CMPSEC");
                break;
            }
            case 38: {
                stringBuffer.append("READBLK");
                break;
            }
            case 34: {
                stringBuffer.append("COPYBLK");
                break;
            }
            case 35: {
                stringBuffer.append("FLASHBLK");
                break;
            }
            case 36: {
                stringBuffer.append("REBOOT");
                break;
            }
            case 11: {
                stringBuffer.append("SAVECONFIG");
                break;
            }
            case 12: {
                stringBuffer.append("READBYTES");
                break;
            }
            default: {
                stringBuffer.append("UNKNOWN-" + n);
            }
        }
        if (this.getCmdId() != 143 && (this.getCmdId() & 0x80) == 128) {
            stringBuffer.append(" response");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        return "ECMLinkCommand{" + this.getDescriptiveCommandId() + "}";
    }

    static {
        lastSyncByteRcvMillis = 0L;
        retryingCmd = false;
        currentState = 0;
    }
}

