/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.OBDReadyFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class ECMLinkDTC {
    private static final int OBD_CATALYST_READINESS_MASK = 1;
    private static final int OBD_O2_READINESS_MASK = 32;
    private static final int OBD_O2HTR_READINESS_MASK = 64;
    private static final int OBD_EGR_READINESS_MASK = 128;
    public static final List obdReadyFlags2GDSM = Arrays.asList(new OBDReadyFlag("Catalyst", 1), new OBDReadyFlag("Oxygen sensor", 32), new OBDReadyFlag("Oxygen sensor heater", 64), new OBDReadyFlag("EGR System", 128));
    public static final String NOT_FOUND_DESC = "DTC not found in lookup table";
    static Hashtable descs2g = new Hashtable();
    static Hashtable descs1g = new Hashtable();
    static Hashtable descse3 = descs1g;

    public static String get2GDTCDesc(Integer n) {
        String string = (String)descs2g.get(n);
        return string == null ? NOT_FOUND_DESC : string;
    }

    public static String get1GDTCDesc(Integer n) {
        String string = (String)descs1g.get(n);
        return string == null ? NOT_FOUND_DESC : string;
    }

    public static String getE3DTCDesc(Integer n) {
        String string = (String)descse3.get(n);
        return string == null ? NOT_FOUND_DESC : string;
    }

    public static Object[] getAllDTCDescs() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(descs1g.values());
        arrayList.addAll(descs2g.values());
        return arrayList.toArray();
    }

    static {
        descs2g.put(new Integer(256), "Volume air flow circuit malfunction");
        descs2g.put(new Integer(261), "Barometric pressure circuit malfunction");
        descs2g.put(new Integer(272), "Intake air temperature circuit malfunction");
        descs2g.put(new Integer(277), "Engine coolant temperature circuit malfunction");
        descs2g.put(new Integer(288), "Throttle position circuit malfunction");
        descs2g.put(new Integer(293), "Excessive time to enter closed loop fuel control");
        descs2g.put(new Integer(304), "02 sensor circuit malfunction (front)");
        descs2g.put(new Integer(309), "02 sensor heater circuit malfunction (front)");
        descs2g.put(new Integer(310), "02 sensor circuit malfunction (rear)");
        descs2g.put(new Integer(321), "02 sensor heater circuit malfunction (rear)");
        descs2g.put(new Integer(368), "Fuel trim malfunction");
        descs2g.put(new Integer(513), "Injector circuit malfunction - Cylinder 1");
        descs2g.put(new Integer(514), "Injector circuit malfunction - Cylinder 2");
        descs2g.put(new Integer(515), "Injector circuit malfunction - Cylinder 3");
        descs2g.put(new Integer(516), "Injector circuit malfunction - Cylinder 4");
        descs2g.put(new Integer(768), "Random misfire detected");
        descs2g.put(new Integer(769), "Cylinder 1 misfire detected");
        descs2g.put(new Integer(770), "Cylinder 2 misfire detected");
        descs2g.put(new Integer(771), "Cylinder 3 misfire detected");
        descs2g.put(new Integer(772), "Cylinder 4 misfire detected");
        descs2g.put(new Integer(805), "Knock sensor 1 circuit malfunction");
        descs2g.put(new Integer(821), "Crankshaft position sensor circuit malfunction");
        descs2g.put(new Integer(832), "Camshaft position sensor circuit malfunction");
        descs2g.put(new Integer(1024), "Exhaust gas recirculation flow malfunction");
        descs2g.put(new Integer(1056), "Catalyst efficiency below threshold");
        descs2g.put(new Integer(1088), "Evaporative emission control system malfunction");
        descs2g.put(new Integer(1091), "Evaporative purge control valve malfunction");
        descs2g.put(new Integer(1280), "Vehicle speed sensor malfunction");
        descs2g.put(new Integer(1285), "Idle control system malfunction");
        descs2g.put(new Integer(1792), "Transmission");
        descs2g.put(new Integer(4864), "Ignition timing adjustment circuit malfunction");
        descs2g.put(new Integer(5120), "Manifold Differential Pressure sensor malfunction");
        descs2g.put(new Integer(5376), "Generator FR terminal circuit malfunction");
        descs1g.put(new Integer(17), "02 sensor circuit malfunction (front)");
        descs1g.put(new Integer(18), "Volume air flow circuit malfunction");
        descs1g.put(new Integer(19), "Intake air temperature circuit malfunction");
        descs1g.put(new Integer(20), "Throttle position circuit malfunction");
        descs1g.put(new Integer(33), "Engine coolant temperature circuit malfunction");
        descs1g.put(new Integer(34), "Crankshaft position sensor circuit malfunction");
        descs1g.put(new Integer(35), "Camshaft position sensor circuit malfunction");
        descs1g.put(new Integer(36), "Vehicle speed sensor malfunction");
        descs1g.put(new Integer(37), "Barometric pressure circuit malfunction");
        descs1g.put(new Integer(49), "Knock sensor 1 circuit malfunction");
        descs1g.put(new Integer(54), "Ignition advance adjust signal malfunction");
        descs1g.put(new Integer(65), "Injector circuit malfunction");
        descs1g.put(new Integer(66), "Fuel pump circuit malfunction");
        descs1g.put(new Integer(67), "EGR circuit malfunction");
        descs1g.put(new Integer(68), "Ignition circuit malfunction");
    }
}

