/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.data.DataAdapter;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ECMLinkDataAdapter
extends DataAdapter {
    public static final String LOC_ByteAirVolPerRev = "ByteAirVolPerRev";
    public static final String LOC_OBDCoolantTemp = "OBDCoolantTemp";
    public static final String LOC_RawBatVolts = "RawBatVolts";
    public static final String LOC_OBDFrontO2 = "OBDFrontO2";
    public static final String LOC_OBDRearO2 = "OBDRearO2";
    public static final String LOC_SelectedLTFTVal = "SelectedLTFTVal";
    public static final String LOC_RawKnock = "RawKnock";
    public static final String LOC_RawThrotPos = "RawThrotPos";
    public static final String LOC_OBDTimingAdv = "OBDTimingAdv";
    public static final String LOC_IdleSetting = "IdleSetting";
    public static final String LOC_OBDReadiness = "OBDReadiness";
    public static final String LOC_LTFT1 = "LTFuelTrim1";
    public static final String LOC_LTFT2 = "LTFuelTrim2";
    public static final String LOC_LTFT3 = "LTFuelTrim3";
    public static final String LOC_RawBaroPressInput = "RawBaroPressInput";
    public static final String LOC_RawEGRTemp = "RawEGRTemp";
    public static final String LOC_RawEGRTempInput = "RawEGRTempInput";
    public static final String LOC_RawIntakeTempInput = "RawIntakeTempInput";
    public static final String LOC_RawMDPSensor = "RawMDPSensor";
    public static final String LOC_RawMDPSensorInput = "RawMDPSensorInput";
    public static final String LOC_RawFrO2Volts = "RawFrO2Volts";
    public static final String LOC_RawFrO2VoltsInput = "RawFrO2VoltsInput";
    public static final String LOC_RawRrO2Volts = "RawRrO2Volts";
    public static final String LOC_RawRrO2VoltsInput = "RawRrO2VoltsInput";
    public static final String LOC_RawCoolantTempInput = "RawCoolantTempInput";
    public static final String LOC_RawMPR = "RawMPR";
    public static final String LOC_InjOnTime = "InjOnTime";
    public static final String LOC_InjOnTimeReal = "InjOnTimeReal";
    public static final String LOC_InjOnTime640 = "InjOnTime640";
    public static final String LOC_LatestSpeed = "LatestSpeed";
    public static final String LOC_RawAirLoad = "RawAirLoad";
    public static final String LOC_AdjToolIgnDelay = "AdjToolIgnDelay";
    public static final String LOC_RawCoolantTemp = "RawCoolantTemp";
    public static final String LOC_RawIntakeTemp = "RawIntakeTemp";
    public static final String LOC_AvgAirVolPerRev = "AvgAirVolPerRev";
    public static final String LOC_TBMASFreqCorrection = "TBMASFreqCorrection";
    public static final String LOC_LogBits = "LogBits";
    public static final String LOC_LogLoad = "LogLoad";
    public static final String DARECID_BaseGlobalInjScale = "inj-global-scale-e3-tbl";
    public static final String DARECID_BaseGlobalInjScale1GLite = "inj-global-scale-1glite-tbl";
    public static final String DARECID_OldInjScale = "inj-scale-e3-tbl";
    public static final String DARECID_InjBatteryAdjE3 = "inj-battery-adj-e3-lst";
    public static final String DARECID_InjBatteryAdj = "inj-battery-adj-lst";
    public static final String DARECID_InjBatteryAdjUsecs = "inj-battery-adj-usecs-lst";
    public static final String DARECID_AirVolConv = "air-vol-conv-e3-tbl";
    public static final String DARECID_AirVolCorr = "air-vol-corr-e3-tbl";
    public static final String DARECID_AirVolOffset = "air-vol-offset-e3-tbl";
    public static final String DARECID_AirVolFactor = "air-vol-factor-e3-tbl";
    public static final String DARECID_AirDensComp = "air-dens-comp-e3-tbl";
    public static final String DARECID_LoadScale = "load-scale-tbl";
    public static final String DARECID_LoadScaleShifted = "load-scale-shifted-tbl";
    public static final String DARECID_TimingMinOctLite = "timing-min-octane-e3-lite-tbl";
    public static final String DARECID_TimingMaxOctLite = "timing-max-octane-e3-lite-tbl";
    public static final String DARECID_OpenLoopMinOctLite = "openloop-min-octane-fuel-e3-lite-tbl";
    public static final String DARECID_OpenLoopMaxOctLite = "openloop-max-octane-fuel-e3-lite-tbl";
    public static final String DARECID_TimingMinOct = "timing-min-octane-tbl";
    public static final String DARECID_TimingMaxOct = "timing-max-octane-tbl";
    public static final String DARECID_OpenLoopMinOct = "openloop-min-octane-fuel-dsm-tbl";
    public static final String DARECID_OpenLoopMaxOct = "openloop-max-octane-fuel-dsm-tbl";
    public static final String CONV_MAFRaw = "conv.ecmx.mafraw";
    public static final String CONV_ClosedLoop = "conv.ecmx.closedloop";
    public static final String CONV_TPSVolts = "conv.ecmx.tpsvolts";
    public static final String[] ALWAYS_PRESENT_E3_V3_LOCNAMES = new String[]{"RawMPR", "InjOnTime", "InjOnTimeReal", "InjOnTime640", "LatestSpeed", "RawAirLoad", "AdjToolIgnDelay", "RawKnock", "RawFrO2Volts", "RawIntakeTemp", "RawCoolantTemp", "RawThrotPos", "AvgAirVolPerRev", "TBMASFreqCorrection", "LogBits", "LogLoad"};
    public static final String[] ALWAYS_PRESENT_V3_LOCNAMES = new String[]{"RawMPR", "InjOnTime", "InjOnTimeReal", "InjOnTime640", "LatestSpeed", "RawAirLoad", "AdjToolIgnDelay", "RawKnock", "RawFrO2Volts", "RawIntakeTemp", "RawCoolantTemp", "RawThrotPos", "AvgAirVolPerRev", "TBMASFreqCorrection", "LogBits", "LogLoad"};
    public static final String DISPLAY_NAME_EGR_TEMP = "EGR Temp";
    public static final String DISPLAY_NAME_EXH_TEMP = "Exh Temp";
    public static final String DISPLAY_NAME_FRONT_O2 = "Front O2";
    public static final String DISPLAY_NAME_INTAKE_TEMP = "Intake temp";
    public static final String DISPLAY_NAME_BARO = "Baro";
    public static final String DISPLAY_NAME_REAR_O2 = "Rear O2";
    public static final String DISPLAY_NAME_MDP = "MDP";
    public static final String DISPLAY_NAME_COOLANT_TEMP = "Coolant temp";
    private final ECMLinkDeviceManager deviceManager;
    static final Map deviceIdFileSpecMap = new HashMap();
    private static final String[] DSMLINK_95_V1_ALIAS_CANDIDATES;
    private static final String[] DSMLINK_95_V2_ALIAS_CANDIDATES;
    private static final String[] DSMLINK_95_V3_ALIAS_CANDIDATES;
    private static final String[] DSMLINK_93_V2_ALIAS_CANDIDATES;
    private static final String[] DSMLINK_93_V3_ALIAS_CANDIDATES;
    private static final String[] DSMLINK_E3_ALIAS_CANDIDATES;

    ECMLinkDataAdapter(ECMLinkDeviceManager eCMLinkDeviceManager) {
        this.deviceManager = eCMLinkDeviceManager;
    }

    public boolean isAlwaysPresent(int n, Location location) {
        if (ECMLinkDeviceMap.isV3Device(n)) {
            String[] stringArray = ECMLinkDeviceMap.isEVO3Device(n) ? ALWAYS_PRESENT_E3_V3_LOCNAMES : ALWAYS_PRESENT_V3_LOCNAMES;
            return ListUtil.isInListNoCase(location.getAssignedName(), stringArray);
        }
        return true;
    }

    @Override
    protected void newAliasAssignments(int n, int n2, List list) {
        this.deviceManager.updateTOCWithNewAliasAssignments(n, n2, list);
    }

    @Override
    public String getConverterPackageName() {
        return this.getClass().getPackage().getName() + ".converter";
    }

    @Override
    public String getDeviceAreaName() {
        return "ecmx";
    }

    @Override
    public String getDeviceFullName() {
        return "ECMLink";
    }

    @Override
    public boolean supportsDeviceId(int n) {
        return this.deviceManager.supportsDeviceId(n);
    }

    @Override
    public String adjustFileSpec(String string) {
        return BasicStrings.replaceAll(string, deviceIdFileSpecMap);
    }

    @Override
    protected synchronized void installAliasCandidates(Map map) {
        ECMLinkDataAdapter.installAliasCandidates(1, map, DSMLINK_95_V1_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(2, map, DSMLINK_95_V2_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(3, map, DSMLINK_95_V3_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(8, map, DSMLINK_95_V3_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(16, map, DSMLINK_93_V2_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(17, map, DSMLINK_93_V3_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(24, map, DSMLINK_93_V3_ALIAS_CANDIDATES);
        ECMLinkDataAdapter.installAliasCandidates(32, map, DSMLINK_E3_ALIAS_CANDIDATES);
    }

    static {
        deviceIdFileSpecMap.put("95v1", Integer.toString(1));
        deviceIdFileSpecMap.put("95v2", Integer.toString(2));
        deviceIdFileSpecMap.put("95v3", Integer.toString(3));
        deviceIdFileSpecMap.put("95v3lite", Integer.toString(8));
        deviceIdFileSpecMap.put("93v2", Integer.toString(16));
        deviceIdFileSpecMap.put("93v3", Integer.toString(17));
        deviceIdFileSpecMap.put("93v3lite", Integer.toString(24));
        deviceIdFileSpecMap.put("evo3", Integer.toString(32));
        DSMLINK_95_V1_ALIAS_CANDIDATES = new String[]{LOC_RawMDPSensor, DISPLAY_NAME_MDP, LOC_RawRrO2Volts, DISPLAY_NAME_REAR_O2};
        DSMLINK_95_V2_ALIAS_CANDIDATES = new String[]{LOC_RawMDPSensor, DISPLAY_NAME_MDP, LOC_RawRrO2Volts, DISPLAY_NAME_REAR_O2, LOC_RawBaroPressInput, DISPLAY_NAME_BARO, LOC_RawIntakeTempInput, DISPLAY_NAME_INTAKE_TEMP};
        DSMLINK_95_V3_ALIAS_CANDIDATES = new String[]{LOC_RawMDPSensorInput, DISPLAY_NAME_MDP, LOC_RawFrO2VoltsInput, DISPLAY_NAME_FRONT_O2, LOC_RawRrO2VoltsInput, DISPLAY_NAME_REAR_O2, LOC_RawBaroPressInput, DISPLAY_NAME_BARO, LOC_RawIntakeTempInput, DISPLAY_NAME_INTAKE_TEMP, LOC_RawCoolantTempInput, DISPLAY_NAME_COOLANT_TEMP};
        DSMLINK_93_V2_ALIAS_CANDIDATES = new String[]{LOC_RawEGRTemp, DISPLAY_NAME_EGR_TEMP, LOC_RawFrO2Volts, DISPLAY_NAME_FRONT_O2, LOC_RawBaroPressInput, DISPLAY_NAME_BARO, LOC_RawIntakeTempInput, DISPLAY_NAME_INTAKE_TEMP};
        DSMLINK_93_V3_ALIAS_CANDIDATES = new String[]{LOC_RawEGRTempInput, DISPLAY_NAME_EGR_TEMP, LOC_RawFrO2VoltsInput, DISPLAY_NAME_FRONT_O2, LOC_RawBaroPressInput, DISPLAY_NAME_BARO, LOC_RawIntakeTempInput, DISPLAY_NAME_INTAKE_TEMP, LOC_RawCoolantTempInput, DISPLAY_NAME_COOLANT_TEMP};
        DSMLINK_E3_ALIAS_CANDIDATES = new String[]{LOC_RawEGRTempInput, DISPLAY_NAME_EXH_TEMP, LOC_RawFrO2VoltsInput, DISPLAY_NAME_FRONT_O2, LOC_RawBaroPressInput, DISPLAY_NAME_BARO, LOC_RawIntakeTempInput, DISPLAY_NAME_INTAKE_TEMP, LOC_RawCoolantTempInput, DISPLAY_NAME_COOLANT_TEMP};
    }
}

