/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceCacheData;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;

public class ECMLinkDeviceCacheData
extends DeviceCacheData {
    final ECMLinkConfigRecordSet configRecordSet;
    final ByteRecordSet byteRecordSet;
    final LocationTOC locationTOC;

    ECMLinkDeviceCacheData() {
        this(0, 0, 0);
    }

    ECMLinkDeviceCacheData(int n, int n2, int n3) {
        super(n);
        this.configRecordSet = new ECMLinkConfigRecordSet(n, n2);
        this.byteRecordSet = new ByteRecordSet(n, n3);
        this.locationTOC = new LocationTOC(n);
    }

    boolean isAnyEmpty() {
        int n = this.getDeviceId();
        if (n == 0) {
            return true;
        }
        boolean bl = !ECMLinkDeviceMap.isV1V2Device(n);
        return this.configRecordSet.isEmpty() || bl && this.byteRecordSet.isEmpty() || this.locationTOC.isEmpty();
    }

    String getEmptyWarningString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getDeviceId();
        if (n == 0) {
            return "No deviceID in cache";
        }
        if (this.configRecordSet.isEmpty()) {
            stringBuffer.append("Missing ECU Config data.  ");
        }
        boolean bl2 = bl = !ECMLinkDeviceMap.isV1V2Device(n);
        if (bl && this.byteRecordSet.isEmpty()) {
            stringBuffer.append("Missing DirectAccess data.  ");
        }
        if (this.locationTOC.isEmpty()) {
            stringBuffer.append("Missing captured values list.  ");
        }
        return stringBuffer.toString();
    }
}

