/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ECMLinkDeviceConfigData
extends DeviceConfigData {
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 2136650713108542764L;
    private final ByteRecordSet byteRecordSet;
    private final ECMLinkConfigRecordSet configRecordSet;

    ECMLinkDeviceConfigData(int n, ByteRecordSet byteRecordSet, ECMLinkConfigRecordSet eCMLinkConfigRecordSet) {
        super(n);
        this.byteRecordSet = byteRecordSet;
        this.configRecordSet = eCMLinkConfigRecordSet;
    }

    public ByteRecordSet getByteRecordSet() {
        return this.byteRecordSet;
    }

    public ECMLinkConfigRecordSet getConfigRecordSet() {
        return this.configRecordSet;
    }

    @Override
    public int getDeviceSerialNumber() {
        return this.configRecordSet.getSerialNum();
    }

    static ECMLinkDeviceConfigData read(int n, DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "ECMLinkConfig", 2136650713108542764L, 1);
        ByteRecordSet byteRecordSet = (ByteRecordSet)ByteRecordSet.read(dataInputStream);
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = (ECMLinkConfigRecordSet)ECMLinkConfigRecordSet.read(dataInputStream);
        return new ECMLinkDeviceConfigData(n, byteRecordSet, eCMLinkConfigRecordSet);
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        FileUtils.writeMarkerAndVersion(dataOutputStream, 2136650713108542764L, 1);
        if (this.byteRecordSet == null) {
            ByteRecordSet.writeNull(dataOutputStream);
        } else {
            this.byteRecordSet.write(dataOutputStream);
        }
        this.configRecordSet.write(dataOutputStream);
    }
}

