/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.AbstractDeviceDatastream;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import java.io.DataInputStream;
import java.io.IOException;

public final class ECMLinkDeviceDatastream
extends AbstractDeviceDatastream {
    private final ECMLinkDeviceManager manager;

    ECMLinkDeviceDatastream(ECMLinkDeviceManager eCMLinkDeviceManager) {
        this.manager = eCMLinkDeviceManager;
    }

    @Override
    public boolean isConnected() {
        return this.manager.isConnected();
    }

    @Override
    public DeviceConfigData getStaticConfigData() throws DeviceException, IOException {
        int n = this.manager.getConnectedDeviceId();
        ByteRecordSet byteRecordSet = null;
        if (ECMLinkDeviceMap.isV3Device(n)) {
            byteRecordSet = new ByteRecordSet(this.manager.getByteRecordSet());
        }
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = new ECMLinkConfigRecordSet(this.manager.getConfigRecordSet());
        return new ECMLinkDeviceConfigData(n, byteRecordSet, eCMLinkConfigRecordSet);
    }

    @Override
    public LocationTOC getLiveTOC(boolean bl) throws DeviceException, IOException {
        return this.manager.getConnectedLocationTOC();
    }

    @Override
    public void setLiveTOC(LocationTOC locationTOC) throws DeviceException, IOException {
        this.manager.storeTOCDataToDevice(locationTOC);
    }

    @Override
    public DeviceConfigData readConfigData(int n, DataInputStream dataInputStream) throws IOException {
        return ECMLinkDeviceConfigData.read(n, dataInputStream);
    }

    @Override
    public void setStreaming(boolean bl) throws DeviceException, IOException {
        this.manager.setStreaming(bl);
    }
}

