/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceCacheData;
import com.ecmtuning.ecmlink.device.DeviceCommand;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DevicePort;
import com.ecmtuning.ecmlink.device.DevicePortFailedException;
import com.ecmtuning.ecmlink.device.data.AliasAssignment;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.DeviceDatastreamInterface;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkCommand;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDataAdapter;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceCacheData;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceDatastream;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkFlashOps;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkStreamThread;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC1GDSMRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC2GDSMRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.ecmlink.records.ExtendedSetupV2Record;
import com.ecmtuning.ecmlink.device.exception.DeviceInternalException;
import com.ecmtuning.ecmlink.device.exception.DeviceInterruptedException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidDataException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.ecmtuning.ecmlink.device.exception.DeviceTimeoutException;
import com.ecmtuning.ecmlink.device.exception.DeviceUnsupportedOperationException;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptorBase;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.MainModelBridge;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ECMLinkDeviceManager
extends DeviceManager {
    public static final String PROPERTYNAME_BYTE_DELAY_MILLIS = "byteDelayMillis";
    public static final String PROPERTYNAME_CMD_TIMEOUT_MILLIS = "cmdTimeoutMillis";
    public static final String PROPERTYNAME_CONFIGURED_DEVICE_LIST_ID = "configuredDeviceListId";
    public static final String PROPERTYNAME_HIGHBAUD_OVERRRIDE = "highbaud";
    public static final String PROPERTYNAME_TEST_MODE = "testmode";
    public static final String PROPERTYNAME_FAST_UPGRADE = "fastupgrade";
    private static final long DEFAULT_BYTE_DELAY_MILLIS = 0L;
    private static final long DEFAULT_RETRY_DELAY_MILLIS = 250L;
    private static final long DEFAULT_CMD_TIMEOUT_MILLIS = 500L;
    private static final int DEFAULT_CONNECTION_DEVICE_LIST_ID = 4;
    private static final long DEFAULT_CONFIG_TIMEOUT_MILLIS = 30000L;
    private static final long MINIMUM_POLL_INTERVAL_MILLIS = 1000L;
    private static final long RECENT_STREAM_RECEIVE_INTERVAL_MILLIS = 500L;
    private static final long RECENT_STERAM_PAUSE_INTERVAL_MILLIS = 1000L;
    static final int OPT_LOC_START_ECU_95 = 224;
    static final int OPT_LOC_START_ECU_93 = 150;
    static final int OPT_LOC_START_ECU_EVO3 = 150;
    static final Logger logger = Logger.getLogger(ECMLinkDeviceManager.class.getName());
    private static final boolean loggingFinest = logger.isLoggable(Level.FINEST);
    private static final boolean loggingFiner = logger.isLoggable(Level.FINER);
    private static final boolean loggingFine = logger.isLoggable(Level.FINE);
    private ECMLinkCommand incomingCommand = null;
    private final Object incomingMutex = new Object();
    private long lastResponseCommandMillis = 0L;
    private long byteDelayMillis;
    private long cmdTimeoutMillis;
    private boolean highbaudOverride = false;
    private boolean testmode = false;
    private boolean fastUpgrade = false;
    private int lastWarnedMismatchSerialNum = -1;
    private int configuredDeviceListId;
    private int connectedDeviceId;
    private int connectedSerialNum;
    private int connectedFirmwareId;
    private int connectedDefinitionId;
    private int connectedBank;
    private int connectedBootId;
    private boolean connectedUseOffsetLoc;
    private boolean connectedUseCacheKeys;
    private int connectedConfigKey;
    private int connectedDirectAccessKey;
    private boolean keepCacheAcrossConnection = false;
    private ECMLinkFlashOps flashOps;
    private final Map stagingRecordCache = new HashMap();
    ECMLinkStreamThread streamThread = null;
    long lastStreamRcvdMillis = 0L;
    long lastStreamPauseMillis = 0L;
    ECMLinkDeviceCacheData cacheData = null;
    private static int READBYTES_NOERR = 0;
    private static int READBYTES_ERR_ADDR = 1;
    private static int READBYTES_ERR_LEN = 2;
    private ECMLinkDataAdapter dataAdapter;
    private boolean installed = false;
    Preferences cachePrefsNode;
    private static final String PREFSNAME_DIRECTACCESSKEY = "directaccesskey";
    private static final String PREFSNAME_ECUCONFIGKEY = "ecuconfigkey";

    public ECMLinkDeviceManager() {
        this.setDeviceCacheData(new ECMLinkDeviceCacheData());
    }

    @Override
    protected void setDeviceCacheData(DeviceCacheData deviceCacheData) {
        this.cacheData = (ECMLinkDeviceCacheData)deviceCacheData;
        super.setDeviceCacheData(deviceCacheData);
    }

    @Override
    public int getConnectedFirmwareId() throws IOException, DeviceException {
        this.setConnected(true);
        if (ECMLinkDeviceMap.isV3Device(this.getConnectedDeviceId())) {
            return this.connectedFirmwareId;
        }
        return -1;
    }

    @Override
    public String constructSerialNumDisplayStr(int n) {
        return ECMLinkDeviceManager._constructSerialNumDisplayStr(n);
    }

    public static String _constructSerialNumDisplayStr(int n) {
        try {
            int n2 = (n & 0xF) >> 0;
            int n3 = (n & 0xF0) >> 4;
            int n4 = (n & 0xF00) >> 8;
            int n5 = (n & 0xF000) >> 12;
            if (0 <= n2 && n2 <= 9 && 0 <= n3 && n3 <= 9 && 0 <= n4 && n4 <= 9 && 10 <= n5) {
                return "1" + XFormatter.toHex4(n - 40960);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return XFormatter.toHex4(n);
    }

    public int getConnectedDefinitionId() throws IOException, DeviceException {
        this.setConnected(true);
        if (ECMLinkDeviceMap.isV3Device(this.getConnectedDeviceId())) {
            return this.connectedDefinitionId;
        }
        return -1;
    }

    public int getConnectedBank() throws IOException, DeviceException {
        this.setConnected(true);
        if (ECMLinkDeviceMap.isV3Device(this.getConnectedDeviceId())) {
            return this.connectedBank;
        }
        return -1;
    }

    public int getConnectedBootId() throws IOException, DeviceException {
        this.setConnected(true);
        if (ECMLinkDeviceMap.isV3Device(this.getConnectedDeviceId())) {
            if (this.connectedBootId == -1 || this.connectedBootId == 65535) {
                return -1;
            }
            return this.connectedBootId;
        }
        return -1;
    }

    public void setConnected(boolean bl) throws IOException, DeviceException {
        if (this.isInTxThread()) {
            return;
        }
        if (!bl && this.isConnected()) {
            try {
                DatasetManager.getInstance().setStreaming(false);
            }
            finally {
                this.device_closeConnection();
            }
        } else if (bl && (!this.isConnected() || this.cacheData.isAnyEmpty())) {
            ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(0);
            this.local_sendCommand(eCMLinkCommand);
            if (this.cacheData.isAnyEmpty()) {
                logger.warning("INTERNAL ERROR: " + this.cacheData.getEmptyWarningString());
            }
        }
    }

    public LocationTOC getConnectedLocationTOC() throws IOException, DeviceException {
        this.setConnected(true);
        return this.cacheData.locationTOC;
    }

    public void setStreaming(boolean bl) throws IOException, DeviceException {
        this.setConnected(true);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(bl ? 6 : 7);
        if (bl) {
            if (this.connectedUseCacheKeys) {
                eCMLinkCommand.add16Bits(this.connectedConfigKey);
            }
            ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
            if (this.connectedUseCacheKeys) {
                if (eCMLinkCommand2.getPayloadLength() != 1) {
                    throw new DeviceInternalException("ECU responded with unknown data on STREAMON");
                }
                int n = eCMLinkCommand2.getPayload8Bits(0);
                if (n == 1) {
                    this.setConnected(false);
                    throw new DeviceInternalException("ECU data is out of sync with laptop!  Reconnect and resave is required.");
                }
                if (n != 0) {
                    this.setConnected(false);
                    throw new DeviceInternalException("Unknown error code " + n + " on SET_LOC.  Reconnect and resave is required.");
                }
            }
        } else {
            try {
                this.local_sendCommand(eCMLinkCommand);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.setConnected(true);
            if (this.streamThread == null) {
                this.streamThread = new ECMLinkStreamThread(this.getConnectedLocationTOC(), (ECMLinkDeviceDatastream)this.getDatastreamInterface(), this.highbaudOverride);
                this.streamThread.start();
                this.sendNewStatusText("Stream data started");
            } else {
                this.tearDownStream();
            }
        } else if (this.streamThread != null) {
            this.tearDownStream();
        }
    }

    private void tearDownStream() {
        ECMLinkStreamThread eCMLinkStreamThread = this.streamThread;
        this.streamThread = null;
        if (eCMLinkStreamThread != null) {
            eCMLinkStreamThread.requestStop();
            this.sendNewStatusText("Stream data stopped");
        }
    }

    public boolean hasSeenRecentStreamData() {
        return this.hasSeenRecentStreamData(500L);
    }

    public boolean hasSeenRecentStreamData(long l) {
        return System.currentTimeMillis() - this.lastStreamRcvdMillis < l;
    }

    public boolean hasRecentlyPausedStreem() {
        return System.currentTimeMillis() - this.lastStreamPauseMillis < 1000L;
    }

    public ECMLinkConfigRecordSet getConfigRecordSet() throws IOException, DeviceException {
        this.setConnected(true);
        return this.cacheData.configRecordSet;
    }

    public void sendUpdatedConfigRecords(Map map) throws IOException, DeviceException {
        this.setConnected(true);
        ArrayList<ConfigRecord> arrayList = new ArrayList<ConfigRecord>();
        for (ConfigRecord configRecord : map.values()) {
            StagingRecord stagingRecord = (StagingRecord)this.stagingRecordCache.get(configRecord.getRecordID());
            if (stagingRecord == null) {
                logger.info("FAILED: tried to store unsupported record '" + configRecord.getDescription() + "'");
                throw new DeviceInvalidDataException("'" + configRecord.getDescription() + "' unsupported by ECU");
            }
            if (stagingRecord.isEmpty()) {
                logger.info("FAILED: stagingRecordCache should have contained '" + configRecord.getDescription() + "', but it did not");
                throw new DeviceInternalException("Internal cache is out of sync");
            }
            if (stagingRecord.getCachedObj().equals(configRecord)) continue;
            logger.finer("Will try to update '" + configRecord.getDescription() + "'");
            arrayList.add(configRecord);
        }
        if (arrayList.size() == 0) {
            logger.fine("Nothing to update");
            return;
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.sendConfigRecordUpdate((ConfigRecord)iterator.next());
        }
    }

    public ByteRecordSet getByteRecordSet() throws IOException, DeviceException {
        this.setConnected(true);
        this.checkByteRecordAccess();
        return this.cacheData.byteRecordSet;
    }

    private void checkByteRecordAccess() throws IOException, DeviceException {
        if (!ECMLinkDeviceMap.isV3Device(this.getConnectedDeviceId())) {
            throw new DeviceUnsupportedOperationException("This ECU does not support direct, byte-level access.");
        }
    }

    public List gatherUpdatedBytes(Map map) throws IOException, DeviceException {
        this.setConnected(true);
        this.checkByteRecordAccess();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (ByteRecord byteRecord : map.values()) {
            ByteRecord byteRecord2 = (ByteRecord)this.cacheData.byteRecordSet.getPersistedRecord(byteRecord.getRecordID());
            if (byteRecord2 == null) {
                logger.info("FAILED: tried to store unsupported record '" + byteRecord.getDescription() + "'");
                throw new DeviceInvalidDataException("'" + byteRecord.getDescription() + "' unsupported by ECU");
            }
            int[] nArray = byteRecord.getRawBytesCopy();
            int[] nArray2 = byteRecord2.getRawBytesCopy();
            int[] nArray3 = byteRecord2.getByteAddrs();
            int n = nArray3.length;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                arrayList.add(new Integer(nArray3[i]));
                arrayList.add(new Integer(nArray[i]));
            }
        }
        if (arrayList.size() == 0) {
            logger.fine("Nothing to update");
        }
        return arrayList;
    }

    public void applyUpdatedBytes(List list) {
        for (ByteRecord byteRecord : this.cacheData.byteRecordSet.getPersistentRecordMap().values()) {
            int[] nArray = byteRecord.getByteAddrs();
            int[] nArray2 = byteRecord.getRawBytesCopy();
            boolean bl = false;
            Iterator iterator = list.iterator();
            block1: while (iterator.hasNext()) {
                int n = ((Number)iterator.next()).intValue();
                int n2 = ((Number)iterator.next()).intValue();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    nArray2[i] = n2;
                    bl = true;
                    continue block1;
                }
            }
            if (!bl) continue;
            byteRecord.setFromBytes(nArray2, 0);
            if (this.connectedUseCacheKeys) {
                String string = ECMLinkDeviceManager.getDirectAccessCacheKey(byteRecord.getRecordID().toString());
                Preferences preferences = this.getDirectAccessNode();
                preferences.putByteArray(string, XFormatter.toByteArray(nArray2));
            }
            StagingRecord stagingRecord = (StagingRecord)this.stagingRecordCache.get(byteRecord.getRecordID());
            stagingRecord.getCachedBaseRecord().copyRawDataFrom(byteRecord);
        }
    }

    public void updateDTCRecord() throws IOException, DeviceException {
        this.setConnected(true);
        int n = ECMLinkDeviceManager.createDTCRecordId(this.connectedDeviceId);
        StagingRecord stagingRecord = (StagingRecord)this.stagingRecordCache.get(new Integer(n));
        if (stagingRecord == null) {
            throw new DeviceInvalidStateException("Internal error, failed to find DTC cache record");
        }
        this.populateConfigRecordFromDevice(stagingRecord);
    }

    private static int createDTCRecordId(int n) {
        if (ECMLinkDeviceMap.is1GDSMDevice(n)) {
            return -1;
        }
        if (ECMLinkDeviceMap.isEVO3Device(n)) {
            return -3;
        }
        return -2;
    }

    public void clearDTCs() throws IOException, DeviceException {
        this.setConnected(true);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(9);
        eCMLinkCommand.add8Bits(255);
        this.manager_sendCommand(eCMLinkCommand);
        this.updateDTCRecord();
    }

    public ECMLinkFlashOps getFlashOps() {
        if (this.flashOps == null) {
            this.flashOps = new ECMLinkFlashOps(this);
        }
        return this.flashOps;
    }

    public int readLoc8(int n) throws IOException, DeviceException {
        this.setConnected(true);
        int[] nArray = this.getLocBytes(this.getConnectedDeviceId(), n, 0, 1);
        return nArray[0];
    }

    public int readLoc16(int n) throws IOException, DeviceException {
        this.setConnected(true);
        int[] nArray = this.getLocBytes(this.getConnectedDeviceId(), n, 0, 2);
        return nArray[0] * 256 + nArray[1];
    }

    public void setLoc(int n, int[] nArray) throws IOException, DeviceException {
        this.setConnected(true);
        this.setLocBytes(this.getConnectedDeviceId(), n, 0, nArray, false);
    }

    public void setLoc8(int n, int n2) throws IOException, DeviceException {
        this.setLoc(n, new int[]{n2});
    }

    public void setLoc8ByName(String string, int n) throws IOException, DeviceException, DeviceInvalidDataException {
        int n2 = this.getConnectedDeviceId();
        Location location = DataManager.getLocationByName(n2, string);
        if (location == null) {
            throw new DeviceInvalidDataException("Failed to find '" + string + "' for deviceID " + n2);
        }
        this.setLoc8(location.getAddress(), n);
    }

    private int[] readBytes(int n, int n2) throws IOException, DeviceException {
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(12);
        eCMLinkCommand.add16Bits(n);
        eCMLinkCommand.add8Bits(n2);
        ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        int n3 = eCMLinkCommand2.getPayload8Bits(0);
        if (n3 == READBYTES_NOERR) {
            int n4 = eCMLinkCommand2.getPayloadLength() - 1;
            if (n4 != n2) {
                throw new DeviceInternalException("ECU returned inappropriate data length: " + n2 + " != " + n4);
            }
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = eCMLinkCommand2.getPayload8Bits(i + 1);
            }
            return nArray;
        }
        if (n3 == READBYTES_ERR_ADDR) {
            throw new DeviceInternalException("Attempted to read from invalid address 0x" + XFormatter.toHex4(n) + ", length " + n2 + " bytes");
        }
        if (n3 == READBYTES_ERR_LEN) {
            throw new DeviceInternalException("Attempted to read with invalid length of " + n2 + " bytes");
        }
        throw new DeviceInternalException("Unknown Error returned while attempting to read data from ECU, errCode=" + n3);
    }

    public int[] readDataBlock(int n, int n2) throws IOException, DeviceException {
        this.setConnected(true);
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n2 > 0) {
            int[] nArray2 = this.readBytes(n, n2 <= 96 ? n2 : 96);
            System.arraycopy(nArray2, 0, nArray, n3, nArray2.length);
            n3 += nArray2.length;
            n += nArray2.length;
            n2 -= nArray2.length;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Collection device_openConnection(DevicePort devicePort) throws IOException, DeviceException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (loggingFine) {
            logger.fine("Called for port " + devicePort);
        }
        boolean bl = false;
        if (System.currentTimeMillis() - this.lastResponseCommandMillis < 30000L) {
            boolean bl2 = bl = this.stagingRecordCache.size() > 0;
        }
        if (!devicePort.supportsRTS()) {
            throw new IOException("'" + devicePort.getPortId() + "' does not support required RTS signaling");
        }
        boolean bl3 = ECMLinkDeviceMap.isV3List(this.getConfiguredDeviceListId());
        boolean bl4 = ECMLinkDeviceMap.is1GDSMList(this.getConfiguredDeviceListId());
        boolean bl5 = this.highbaudOverride | bl3;
        if (loggingFine) {
            logger.fine("Connecting with isV3 = " + bl3 + ", is1G = " + bl4);
        }
        try {
            void exception;
            if (bl4) {
                int n6 = bl5 ? 15625 : 1952;
            } else {
                int exception2;
                int n6 = exception2 = bl5 ? 15625 : 9600;
            }
            if (loggingFine) {
                logger.fine("Setting bitrate to " + (int)exception);
            }
            if (exception != 9600 && !devicePort.supportsVariableBitrates()) {
                throw new IOException("'" + devicePort.getPortId() + "' does not support variable bitrates");
            }
            devicePort.setBitRate((int)exception);
        }
        catch (Exception eCMLinkCommand) {
            throw new DevicePortFailedException("Port refused to accept required bitrate");
        }
        if (bl3) {
            if (loggingFine) {
                logger.fine("Attempting V3 activation sequence, isHighBaud = " + bl5);
            }
            boolean bl6 = false;
            int n7 = bl5 ? 6 : 4;
            long l = Math.round(700.0f / (float)n7);
            for (n5 = 0; n5 < n7; ++n5) {
                boolean bl7;
                bl7 = !bl7;
                devicePort.setRTS(bl7);
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ECMLinkCommand.resetParseBuffer();
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(8);
        ECMLinkCommand eCMLinkCommand2 = (ECMLinkCommand)this._device_sendCommand(eCMLinkCommand, devicePort);
        logger.fine("CONNECTED!");
        try {
            DatasetManager.getInstance().setStreaming(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n8 = eCMLinkCommand2.getPayload8Bits(0);
        int n9 = eCMLinkCommand2.getPayload16Bits(1);
        n5 = ECMLinkDeviceMap.isV3Device(n8) ? 1 : 0;
        int n10 = 3;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        this.connectedUseCacheKeys = false;
        if (n5 != 0) {
            n11 = eCMLinkCommand2.getPayload16Bits(3);
            n12 = eCMLinkCommand2.getPayload8Bits(5);
            n10 += 3;
            n4 = eCMLinkCommand2.getPayload8Bits(6);
            if (n4) {
                n13 = eCMLinkCommand2.getPayload8Bits(7);
                logger.fine("Connected to bank " + n13);
                n10 += 2;
            }
            int n14 = ECMLinkDeviceManager.getOptLocStart(n8);
            n3 = eCMLinkCommand2.getPayloadLength();
            n2 = n10;
            while (!this.connectedUseCacheKeys && n2 < n3) {
                n = eCMLinkCommand2.getPayload8Bits(n2);
                if (n == 51) {
                    this.connectedUseCacheKeys = true;
                }
                ++n2;
                ++n14;
            }
        }
        if (n11 != -1) {
            MainModelBridge mainModelBridge = MainModelBridge.getInstance();
            if (n9 != this.lastWarnedMismatchSerialNum && n11 > mainModelBridge.getAppVersionNum()) {
                this.lastWarnedMismatchSerialNum = n9;
                mainModelBridge.showErrorMessage("WARNING: Application version is older than ECU version.\nSome functionality may not work properly!  Please\nupgrade your laptop application as soon as possible.\n\nhttp://www.ecmtuning.com/downloads\n\nApplication version: " + mainModelBridge.getFullAppVersionStr() + ", ECU version: " + ECMLinkDeviceMap.getDeviceVersionString(n8, n11), "Version mismatch");
            }
        }
        n4 = n8 != this.connectedDeviceId ? 1 : 0;
        n4 |= n9 != this.connectedSerialNum ? 1 : 0;
        n4 |= n11 != this.connectedFirmwareId ? 1 : 0;
        this.connectedBank = n13;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.connectedUseCacheKeys || !bl || (n4 |= n12 != this.connectedDefinitionId ? 1 : 0)) {
            Object object;
            Object object2;
            logger.fine("Dropping cached settings, recentReconnectAndCacheOK=" + bl + ", differentDevice=" + (n4 != 0));
            if (n4) {
                this.tearDownStream();
                logger.fine("Dropping cached settings, differentDevice=" + (n4 != 0));
                this.setDeviceCacheData(new ECMLinkDeviceCacheData(n8, n9, n12));
                if (this.connectedDeviceId != 0) {
                    this.clearLocalCacheKeys();
                }
            }
            this.connectedDeviceId = n8;
            this.connectedSerialNum = n9;
            this.connectedFirmwareId = n11;
            this.connectedUseOffsetLoc = this.connectedFirmwareId >= 4714;
            this.connectedDefinitionId = n12;
            this.connectedBootId = -1;
            this.stagingRecordCache.clear();
            n3 = ECMLinkDeviceManager.getOptLocStart(this.connectedDeviceId);
            n2 = eCMLinkCommand2.getPayloadLength();
            n = n10;
            while (n < n2) {
                int n15 = eCMLinkCommand2.getPayload8Bits(n);
                object2 = new StagingRecord(this.connectedDeviceId, n15, n3);
                this.stagingRecordCache.put(((StagingRecord)object2).cachedObjId, object2);
                if (n15 == 34 || n15 == 51) {
                    object = this.createAndReadSetupRecord((StagingRecord)object2, this.connectedDeviceId, n15, devicePort);
                    ((StagingRecord)object2).setCachedObj(object);
                    this.updateRecordSetIfNotEmpty(this.cacheData.configRecordSet, (BaseRecord)object);
                    this.connectedBootId = ((BaseRecord)object).getField("EXT_SU_BOOTFWID").intValue();
                    if (n15 == 51) {
                        this.connectedConfigKey = ((ConfigRecord)object).getIntField("EXT_SU_CONFIG_KEY");
                        this.connectedDirectAccessKey = ((ConfigRecord)object).getIntField("EXT_SU_DIRECTACCESS_KEY");
                        logger.fine("ECU cache keys 0x" + XFormatter.toHex4(this.connectedConfigKey) + " and 0x" + XFormatter.toHex4(this.connectedDirectAccessKey));
                        logger.fine("Local cache keys 0x" + XFormatter.toHex4(this.getLocalConfigKey()) + " and 0x" + XFormatter.toHex4(this.getLocalDirectAccessKey()));
                        if (this.getLocalConfigKey() != this.connectedConfigKey || this.getLocalDirectAccessKey() != this.connectedDirectAccessKey) {
                            try {
                                this.getConfigNode().removeNode();
                                this.getDirectAccessNode().removeNode();
                            }
                            catch (BackingStoreException backingStoreException) {
                                logger.warning("Failed to delete internal config cache, " + backingStoreException.toString());
                            }
                        }
                    }
                } else {
                    arrayList.add(object2);
                }
                ++n;
                ++n3;
            }
            if (ECMLinkDeviceMap.isV3Device(this.connectedDeviceId) && (this.connectedBootId == 65535 || this.connectedBootId == -1)) {
                this.connectedBootId = 4486;
            }
            n = ECMLinkDeviceManager.createDTCRecordId(this.connectedDeviceId);
            StagingRecord stagingRecord = new StagingRecord(this.connectedDeviceId, n, 0);
            this.stagingRecordCache.put(stagingRecord.cachedObjId, stagingRecord);
            arrayList.add(stagingRecord);
            if (ECMLinkDeviceMap.isV3Device(this.connectedDeviceId)) {
                object2 = ByteRecordDescriptor.getDescriptorsForDevice(this.connectedDeviceId, this.connectedDefinitionId);
                object2.remove(0);
                object = object2.iterator();
                while (object.hasNext()) {
                    ByteRecordDescriptorBase byteRecordDescriptorBase = (ByteRecordDescriptorBase)object.next();
                    StagingRecord stagingRecord2 = new StagingRecord(byteRecordDescriptorBase);
                    this.stagingRecordCache.put(stagingRecord2.cachedObjId, stagingRecord2);
                    arrayList.add(stagingRecord2);
                    if (!this.testmode) continue;
                    break;
                }
            }
            object2 = new StagingRecord(3, "TOC data");
            this.stagingRecordCache.put(((StagingRecord)object2).cachedObjId, object2);
            arrayList.add(object2);
        } else {
            for (StagingRecord stagingRecord : this.stagingRecordCache.values()) {
                if (!stagingRecord.isEmpty()) continue;
                arrayList.add(stagingRecord);
            }
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        } else {
            arrayList.add(new StagingRecord());
        }
        return arrayList;
    }

    @Override
    protected void device_doOpenTask(Object object) throws IOException, DeviceException {
        StagingRecord stagingRecord = (StagingRecord)object;
        if (!stagingRecord.isTypeNone()) {
            if (stagingRecord.isTypeByteRecord() || stagingRecord.isTypeConfigRecord()) {
                this.populateRecordDataFromDevice(stagingRecord);
                if (loggingFiner) {
                    Object object2 = stagingRecord.getCachedObj();
                    logger.finer("Read postOpen record: " + object2 == null ? "null" : object2.toString());
                }
            } else if (stagingRecord.isTypeTOC()) {
                this.populateTOCDataFromDevice(stagingRecord);
                if (loggingFiner) {
                    logger.finer("Read location TOC data");
                }
            }
            return;
        }
        if (loggingFiner) {
            logger.finer("All post open tasks completed");
        }
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = this.cacheData.configRecordSet;
        ByteRecordSet byteRecordSet = this.cacheData.byteRecordSet;
        boolean bl = !ECMLinkDeviceMap.isV1V2Device(this.connectedDeviceId);
        LocationTOC locationTOC = this.cacheData.locationTOC;
        if (eCMLinkConfigRecordSet.isEmpty()) {
            if (bl && !byteRecordSet.isEmpty() || !locationTOC.isEmpty()) {
                throw new DeviceInternalException("Inconsistent internal state, id 1");
            }
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            Iterator iterator = this.stagingRecordCache.values().iterator();
            while (iterator.hasNext()) {
                StagingRecord stagingRecord2 = (StagingRecord)iterator.next();
                if (stagingRecord2.isEmpty()) {
                    logger.warning("Unexpected empty cache record entry, removing from cache.");
                    iterator.remove();
                    continue;
                }
                if (stagingRecord2.isTypeConfigRecord()) {
                    hashMap.put(stagingRecord2.cachedObjId, stagingRecord2.getCachedBaseRecord().clone());
                    continue;
                }
                if (bl && stagingRecord2.isTypeByteRecord()) {
                    hashMap2.put(stagingRecord2.cachedObjId, stagingRecord2.getCachedBaseRecord().clone());
                    continue;
                }
                if (!stagingRecord2.isTypeTOC()) continue;
                locationTOC.setTOCEntries(stagingRecord2.getCachedTOCList());
            }
            if (loggingFiner) {
                logger.finer("Initializing shared RecordSet");
            }
            eCMLinkConfigRecordSet.setPersistedMap(hashMap);
            if (bl) {
                byteRecordSet.setPersistedMap(hashMap2);
            }
        } else if (locationTOC.isEmpty() || bl && byteRecordSet.isEmpty()) {
            throw new DeviceInternalException("Inconsistent internal state, id 2");
        }
        if (this.connectedUseCacheKeys) {
            if (this.connectedConfigKey == 0 || this.connectedDirectAccessKey == 0) {
                logger.info("Setting ECU's cache keys");
                this.setLocalConfigKey(ECMLinkDeviceManager.createNewCacheKey());
                this.setLocalDirectAccessKey(ECMLinkDeviceManager.createNewCacheKey());
                this.sendCacheKeyUpdate();
            } else if (this.connectedConfigKey != this.getLocalConfigKey() || this.connectedDirectAccessKey != this.getLocalDirectAccessKey()) {
                logger.info("Using ECU's cache keys");
                this.setLocalConfigKey(this.connectedConfigKey);
                this.setLocalDirectAccessKey(this.connectedDirectAccessKey);
            }
        }
    }

    void clearLocalCacheKeys() {
        this.setLocalConfigKey(-1);
        this.setLocalDirectAccessKey(-1);
    }

    private void sendCacheKeyUpdate() throws DeviceInternalException, IOException, DeviceException {
        this.setConnected(true);
        StagingRecord stagingRecord = (StagingRecord)this.stagingRecordCache.get(ConfigRecord.constructRecordId(51));
        if (stagingRecord == null) {
            throw new DeviceInternalException("Inconsistent internal state, id 3");
        }
        int n = stagingRecord.getConfigRecordLocation();
        ExtendedSetupV2Record extendedSetupV2Record = new ExtendedSetupV2Record(this.connectedDeviceId);
        int[] nArray = this.getLocBytes(this.connectedDeviceId, n, 0, extendedSetupV2Record.getByteLength());
        extendedSetupV2Record.setFromBytes(nArray, 0);
        int n2 = extendedSetupV2Record.getIntField("EXT_SU_CONFIG_KEY");
        if (this.connectedConfigKey != n2) {
            logger.warning("Got unexpected (but ignored) cache key mismatch.  Our value of 0x" + XFormatter.toHex4(this.connectedConfigKey) + " != ECU's value of 0x" + XFormatter.toHex4(n2));
        }
        this.connectedConfigKey = n2;
        extendedSetupV2Record.getField("EXT_SU_CONFIG_KEY").setValue(this.getLocalConfigKey());
        extendedSetupV2Record.getField("EXT_SU_DIRECTACCESS_KEY").setValue(this.getLocalDirectAccessKey());
        this.sendConfigRecordUpdate(extendedSetupV2Record);
        this.connectedConfigKey = this.getLocalConfigKey();
        this.connectedDirectAccessKey = this.getLocalDirectAccessKey();
    }

    public void saveConfig() throws IOException, DeviceException {
        if (this.connectedUseCacheKeys) {
            this.setLocalDirectAccessKey(ECMLinkDeviceManager.createNewCacheKey());
            this.sendCacheKeyUpdate();
        }
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(11);
        this.local_sendCommand(eCMLinkCommand);
    }

    @Override
    protected boolean device_isConnected() {
        return this.getCurrentPort() != null;
    }

    @Override
    protected void device_closeConnection() {
        if (loggingFiner) {
            logger.finer("Called");
        }
        ECMLinkCommand.resetParseBuffer();
        this.setCurrentPort(null);
        this.tearDownStream();
        if (!this.keepCacheAcrossConnection) {
            this.lastResponseCommandMillis = 0L;
            this.stagingRecordCache.clear();
            this.clearLocalCacheKeys();
        }
    }

    @Override
    protected boolean device_supportsDeviceId(int n) {
        return ECMLinkDeviceManager.isSupportedDeviceId(n);
    }

    public static boolean isSupportedDeviceId(int n) {
        return ListUtil.isInList(n, ECMLinkDeviceMap.ALL_ECMLINK_DEVICE_IDS_LIST);
    }

    @Override
    protected Object device_sendCommand(DeviceCommand deviceCommand) throws IOException, DeviceException {
        ECMLinkCommand eCMLinkCommand = (ECMLinkCommand)deviceCommand;
        if (eCMLinkCommand.getCmdId() == 0) {
            return eCMLinkCommand;
        }
        DevicePort devicePort = this.getCurrentPort();
        return this._device_sendCommand(deviceCommand, devicePort);
    }

    private Object _device_sendCommand(DeviceCommand deviceCommand, DevicePort devicePort) throws IOException, DeviceException {
        if (devicePort == null || !devicePort.isOpen()) {
            throw new IOException("Port closed before sendCommand");
        }
        boolean bl = false;
        this.deviceListeners.fire("commandSendStart");
        try {
            Object object = this.__device_sendCommand(deviceCommand, devicePort);
            bl = true;
            this.deviceListeners.fire("commandSendEnd");
            Object object2 = object;
            return object2;
        }
        catch (DeviceException deviceException) {
            if (loggingFinest) {
                logger.finest("Got exception: " + deviceException);
                logger.finest("CLOSING PORT");
            }
            throw deviceException;
        }
        catch (IOException iOException) {
            if (loggingFinest) {
                logger.finest("Got exception: " + iOException);
                logger.finest("CLOSING PORT");
            }
            throw iOException;
        }
        finally {
            if (!bl) {
                this.deviceListeners.fire("commandSendEndError");
                this.setCurrentPort(null);
            }
        }
    }

    private Object __device_sendCommand(DeviceCommand deviceCommand, DevicePort devicePort) throws IOException, DeviceException {
        boolean bl;
        ECMLinkCommand eCMLinkCommand = (ECMLinkCommand)deviceCommand;
        if (loggingFiner) {
            logger.finer("Sending " + eCMLinkCommand.toString());
        }
        int n = eCMLinkCommand.getCmdId() | 0x80;
        long l = this.byteDelayMillis;
        boolean bl2 = ECMLinkDeviceMap.isV3List(this.getConfiguredDeviceListId());
        boolean bl3 = bl = !bl2 && ((eCMLinkCommand.getChecksum() & 1) == 1 || eCMLinkCommand.getCmdId() == 8);
        if (!this.testmode && l < 2L && !eCMLinkCommand.isEngineStopRequired()) {
            l = 2L;
        } else if (this.testmode || eCMLinkCommand.isEngineStopRequired()) {
            l = 0L;
        }
        if (bl2 && (this.hasSeenRecentStreamData() || this.hasRecentlyPausedStreem())) {
            logger.info("Attempting to pause stream");
            devicePort.setRTS(true);
            bl = true;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lastStreamPauseMillis = System.currentTimeMillis();
        }
        if (!bl) {
            devicePort.setRTS(false);
        }
        int n2 = 90;
        if (!bl2 && ECMLinkDeviceMap.is2GDSMList(this.getConfiguredDeviceListId())) {
            n2 = 0;
        }
        ECMLinkCommand eCMLinkCommand2 = null;
        int[] nArray = eCMLinkCommand.getRawBytes();
        try {
            for (int i = eCMLinkCommand.getTryCount(); i > 0; --i) {
                for (int j = -4; j < nArray.length; ++j) {
                    int n3 = j >= 0 ? nArray[j] & 0xFF : n2;
                    try {
                        if (l > 0L) {
                            Thread.sleep(l);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (bl) {
                        devicePort.setRTS(true);
                    }
                    if (l > 0L || j < 0) {
                        if (loggingFinest) {
                            this.logOutput(n3);
                        }
                        devicePort.putBytes(new int[]{n3}, 0, 1);
                    } else {
                        if (loggingFinest) {
                            for (int k = 0; k < nArray.length; ++k) {
                                this.logOutput(nArray[k]);
                            }
                        }
                        devicePort.putBytes(nArray, 0, nArray.length);
                        j += nArray.length;
                    }
                    if (!bl) continue;
                    devicePort.setRTS(true);
                }
                if (bl) {
                    devicePort.setRTS(true);
                }
                if ((eCMLinkCommand2 = this.waitForIncomingCommand(n, eCMLinkCommand.getTimeoutMillis(), eCMLinkCommand2)) != null) {
                    break;
                }
                try {
                    if (i > 1) {
                        logger.fine("Issuing retry of timed out command");
                        Thread.sleep(250L);
                        continue;
                    }
                    logger.fine("Command timed out, no more retries allowed");
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DeviceInterruptedException("Interrupted while waiting for reply");
        }
        finally {
            if (bl) {
                devicePort.setRTS(false);
            }
        }
        if (eCMLinkCommand2 == null) {
            throw new DeviceTimeoutException("No response received!");
        }
        return eCMLinkCommand2;
    }

    protected void logOutput(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Output: 0x");
        stringBuffer.append(XFormatter.toHex2(n));
        stringBuffer.append(" (");
        stringBuffer.append(Integer.toString(n));
        stringBuffer.append(")");
        logger.finest(stringBuffer.toString());
    }

    @Override
    protected void device_poll() {
        block8: {
            if (loggingFinest) {
                logger.finest("Called");
            }
            if (System.currentTimeMillis() - this.lastResponseCommandMillis < 1000L) {
                return;
            }
            if (!this.device_isConnected()) {
                return;
            }
            if (DatasetManager.getInstance().isStreaming()) {
                return;
            }
            try {
                this.getLocBytes(this.connectedDeviceId, ECMLinkDeviceManager.getOptLocStart(this.connectedDeviceId), 0, 1);
                if (loggingFinest) {
                    logger.finest("Poll completed OK");
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                if (!loggingFinest) break block8;
                logger.finest("Got exception: " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void device_parseAndDispatchRxData(int[] nArray, int n) {
        ECMLinkCommand eCMLinkCommand = ECMLinkCommand.parseIncomingData(nArray, n);
        while (eCMLinkCommand != null) {
            Object object;
            if (loggingFine) {
                logger.finer("Successfully parsed " + eCMLinkCommand.toString());
            }
            if (eCMLinkCommand.getCmdId() == 143) {
                this.lastResponseCommandMillis = this.lastStreamRcvdMillis = ECMLinkCommand.getLastSyncByteRcvMillis();
                object = this.streamThread;
                if (object != null) {
                    ((ECMLinkStreamThread)object).queueCmdData(eCMLinkCommand, this.lastStreamRcvdMillis);
                }
            } else {
                object = this.incomingMutex;
                synchronized (object) {
                    if (eCMLinkCommand.isResponseCmd()) {
                        this.lastResponseCommandMillis = ECMLinkCommand.getLastSyncByteRcvMillis();
                    }
                    this.incomingCommand = eCMLinkCommand;
                    this.incomingMutex.notifyAll();
                }
            }
            eCMLinkCommand = ECMLinkCommand.parseExistingData();
        }
    }

    @Override
    public synchronized void manager_install() {
        if (!this.installed) {
            ConfigRecord.addKnownRecordAdapter(new ECMLinkRecordAdapter());
            this.dataAdapter = new ECMLinkDataAdapter(this);
            DataManager.addKnownDataAdapter(this.dataAdapter);
            this.installed = true;
        }
    }

    @Override
    public String device_getDeviceDisplayName(int n) {
        return ECMLinkDeviceMap.getDeviceDisplayName(n);
    }

    @Override
    protected String device_getPreferencesId() {
        return "ECMLinkDevice";
    }

    @Override
    protected int device_getConnectedDeviceId() throws IOException, DeviceException {
        this.setConnected(true);
        return this.connectedDeviceId;
    }

    @Override
    protected int device_getConnectedSerialNum() throws IOException, DeviceException {
        this.setConnected(true);
        return this.connectedSerialNum;
    }

    @Override
    protected int device_getConnectedFirmwareId() throws IOException, DeviceException {
        this.setConnected(true);
        return this.connectedFirmwareId;
    }

    @Override
    protected DeviceDatastreamInterface device_createDatastreamInterface() {
        return new ECMLinkDeviceDatastream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ECMLinkCommand waitForIncomingCommand(int n, long l, ECMLinkCommand eCMLinkCommand) throws InterruptedException {
        if (l == -1L) {
            l = this.cmdTimeoutMillis;
        }
        long l2 = System.currentTimeMillis();
        Object object = this.incomingMutex;
        synchronized (object) {
            long l3;
            while ((l3 = l - (System.currentTimeMillis() - l2)) > 50L) {
                this.incomingMutex.wait(l3);
                if (this.incomingCommand == null || this.incomingCommand.getCmdId() != n) continue;
                eCMLinkCommand = this.incomingCommand;
                this.incomingCommand = null;
                break;
            }
        }
        return eCMLinkCommand;
    }

    private void populateRecordDataFromDevice(StagingRecord stagingRecord) throws IOException, DeviceException {
        if (loggingFine) {
            logger.fine("Reading and caching data from ECU for recordID " + stagingRecord.cachedObjId);
        }
        if (stagingRecord.isTypeConfigRecord()) {
            this.populateConfigRecordFromDevice(stagingRecord);
        } else if (stagingRecord.isTypeByteRecord()) {
            this.populateByteRecordFromDevice(stagingRecord);
        }
        if (loggingFine) {
            logger.fine("Cached data read OK");
        }
    }

    private void populateByteRecordFromDevice(StagingRecord stagingRecord) throws DeviceInvalidDataException, IOException, DeviceException {
        Object object;
        ByteRecordDescriptor byteRecordDescriptor = stagingRecord.getInitDataDescriptor();
        int[] nArray = null;
        int[] nArray2 = byteRecordDescriptor.getByteAddrs();
        String string = ECMLinkDeviceManager.getDirectAccessCacheKey(byteRecordDescriptor.getRecordId());
        Preferences preferences = this.getDirectAccessNode();
        if (this.connectedUseCacheKeys && this.getLocalDirectAccessKey() == this.connectedDirectAccessKey && (object = preferences.getByteArray(string, null)) != null && ((byte[])object).length == byteRecordDescriptor.getByteSize()) {
            nArray = XFormatter.toIntArray(object);
            logger.finest("Used cache data for ByteRecord ID '" + byteRecordDescriptor.getRecordId() + "' for deviceId 0x" + XFormatter.toHex4(this.getConnectedDeviceId() * 256 + this.getConnectedDefinitionId()) + ", length=" + nArray.length);
        }
        if (nArray == null) {
            nArray = new int[byteRecordDescriptor.getByteSize()];
            int n = 0;
            int n2 = nArray2[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (n2 + 1 == nArray2[i]) {
                    ++n2;
                    continue;
                }
                int[] nArray3 = this.readDataBlock(nArray2[n], i - n);
                System.arraycopy(nArray3, 0, nArray, n, i - n);
                n = i;
                n2 = nArray2[i];
            }
            if (n < nArray.length) {
                int[] nArray4 = this.readDataBlock(nArray2[n], nArray.length - n);
                System.arraycopy(nArray4, 0, nArray, n, nArray.length - n);
            }
            if (this.connectedUseCacheKeys) {
                preferences.putByteArray(string, XFormatter.toByteArray(nArray));
            }
            logger.finest("Read ByteRecord ID '" + byteRecordDescriptor.getRecordId() + "' for deviceId 0x" + XFormatter.toHex4(this.getConnectedDeviceId() * 256 + this.getConnectedDefinitionId()) + ", length=" + nArray.length);
        }
        object = new ByteRecord(this.getConnectedDeviceId(), this.getConnectedDefinitionId(), byteRecordDescriptor, nArray);
        stagingRecord.setCachedObj(object);
        this.updateRecordSetIfNotEmpty(this.cacheData.byteRecordSet, (BaseRecord)object);
    }

    private void populateConfigRecordFromDevice(StagingRecord stagingRecord) throws DeviceInvalidDataException, IOException, DeviceException {
        int n = this.getConnectedDeviceId();
        int n2 = stagingRecord.getConfigRecordId();
        ConfigRecord configRecord = null;
        configRecord = n2 == -1 || n2 == -2 || n2 == -3 ? this.createAndReadDTCRecord(n, n2) : this.createAndReadRecord(stagingRecord, n, n2);
        if (configRecord == null) {
            logger.warning("Failed to create record id " + n2 + ", ignoring record data.");
            return;
        }
        stagingRecord.setCachedObj(configRecord);
        this.updateRecordSetIfNotEmpty(this.cacheData.configRecordSet, configRecord);
    }

    private ConfigRecord createAndReadDTCRecord(int n, int n2) throws DeviceInvalidDataException, IOException, DeviceException {
        ConfigRecord configRecord = ECMLinkRecordAdapter._createRecord(n, n2);
        if (configRecord == null) {
            return null;
        }
        if (!(configRecord instanceof DTC1GDSMRecord) && !(configRecord instanceof DTC2GDSMRecord)) {
            throw new DeviceInvalidStateException("Internal error, non-DTC record created in DTC method");
        }
        DTC1GDSMRecord dTC1GDSMRecord = (DTC1GDSMRecord)configRecord;
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(9);
        eCMLinkCommand.add8Bits(0);
        ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        int n3 = eCMLinkCommand2.getPayloadLength() / 2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n3; ++i) {
            arrayList.add(new Integer(eCMLinkCommand2.getPayload16Bits(i * 2)));
        }
        dTC1GDSMRecord.setDTCS(arrayList);
        if (dTC1GDSMRecord instanceof DTC2GDSMRecord) {
            DTC2GDSMRecord dTC2GDSMRecord = (DTC2GDSMRecord)dTC1GDSMRecord;
            Location location = DataManager.getLocationByName(n, "OBDReadiness");
            if (location == null) {
                throw new DeviceInvalidStateException("Internal error, can't find OBD2 readiness location for connected device");
            }
            int n4 = this.readLoc8(location.getAddress());
            dTC2GDSMRecord.setReadinessValue(n4);
        }
        return configRecord;
    }

    private ConfigRecord createAndReadRecord(StagingRecord stagingRecord, int n, int n2) throws DeviceInvalidDataException, IOException, DeviceException {
        byte[] byArray;
        ConfigRecord configRecord = ECMLinkRecordAdapter._createRecord(n, n2);
        if (configRecord == null) {
            return null;
        }
        int n3 = stagingRecord.getConfigRecordLocation();
        int n4 = configRecord.getByteLength();
        int[] nArray = null;
        String string = ECMLinkDeviceManager.getConfigCacheKey(n2);
        Preferences preferences = this.getConfigNode();
        if (this.connectedUseCacheKeys && this.getLocalConfigKey() == this.connectedConfigKey && configRecord.localCacheOK() && (byArray = preferences.getByteArray(string, null)) != null && byArray.length == n4) {
            nArray = XFormatter.toIntArray(byArray);
            logger.finest("Used cache data for ConfigRecord ID '" + n2 + "' for deviceId 0x" + XFormatter.toHex4(this.getConnectedDeviceId() * 256 + this.getConnectedDefinitionId()) + ", length=" + nArray.length);
        }
        if (nArray == null) {
            int[] nArray2;
            int n5;
            nArray = new int[n5];
            int n6 = 0;
            for (n5 = n4; n5 > 0; n5 -= nArray2.length) {
                nArray2 = this.getLocBytes(n, n3, n6, n5 <= 96 ? n5 : 96);
                System.arraycopy(nArray2, 0, nArray, n6, nArray2.length);
                n6 += nArray2.length;
            }
            if (this.connectedUseCacheKeys) {
                preferences.putByteArray(string, XFormatter.toByteArray(nArray));
            }
            logger.finest("Read data for ConfigRecord ID '" + n2 + "' for deviceId 0x" + XFormatter.toHex4(this.getConnectedDeviceId() * 256 + this.getConnectedDefinitionId()) + ", length=" + nArray.length);
        }
        configRecord.setFromBytes(nArray, 0);
        return configRecord;
    }

    private int[] getLocBytes(int n, int n2, int n3, int n4) throws IOException, DeviceException {
        if ((n3 & 1) == 1) {
            throw new DeviceInvalidDataException("Received invalid offset for read command");
        }
        if (n3 > 0 && !this.connectedUseOffsetLoc) {
            throw new DeviceInvalidDataException("Received offset read request for ECU without offset functionality");
        }
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(2);
        eCMLinkCommand.addAddrBits(n, n2);
        if (this.connectedUseOffsetLoc) {
            eCMLinkCommand.add8Bits(n3 / 2);
        }
        eCMLinkCommand.add8Bits(n4);
        ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        int[] nArray = eCMLinkCommand2.getPayloadBytes();
        if (nArray.length != n4) {
            throw new DeviceInvalidDataException("Received invalid length response from read command");
        }
        return nArray;
    }

    private ConfigRecord createAndReadSetupRecord(StagingRecord stagingRecord, int n, int n2, DevicePort devicePort) throws DeviceInvalidDataException, IOException, DeviceException {
        ConfigRecord configRecord = ECMLinkRecordAdapter._createRecord(n, n2);
        if (configRecord == null) {
            return null;
        }
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(2);
        eCMLinkCommand.addAddrBits(n, stagingRecord.getConfigRecordLocation());
        if (this.connectedUseOffsetLoc) {
            eCMLinkCommand.add8Bits(0);
        }
        eCMLinkCommand.add8Bits(configRecord.getByteLength());
        ECMLinkCommand eCMLinkCommand2 = (ECMLinkCommand)this._device_sendCommand(eCMLinkCommand, devicePort);
        configRecord.setFromBytes(eCMLinkCommand2.getPayloadBytes(), 0);
        return configRecord;
    }

    private void populateTOCDataFromDevice(StagingRecord stagingRecord) throws IOException, DeviceException {
        logger.fine("Attempting to read TOC data from ECU");
        int n = this.getConnectedDeviceId();
        List list = null;
        if (ECMLinkDeviceMap.isV3Device(n)) {
            list = this.readV3TOCEnries();
        } else if (ECMLinkDeviceMap.isV1V2Device(n)) {
            list = this.readV1V2TOCEntries();
        }
        if (list == null) {
            throw new DeviceInternalException("No supported TOC for deviceId " + n);
        }
        stagingRecord.setCachedObj(list);
        if (!this.cacheData.locationTOC.isEmpty()) {
            this.cacheData.locationTOC.setTOCEntries(list);
        }
    }

    private List readV1V2TOCEntries() throws IOException, DeviceException {
        int n;
        int n2;
        int n3 = this.getConnectedDeviceId();
        int n4 = this.getConnectedSerialNum();
        List list = DataManager.getAliasAssignments(n3, n4);
        ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(5);
        ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        int n5 = eCMLinkCommand2.getPayloadLength();
        for (n2 = 0; n2 < n5; ++n2) {
            n = eCMLinkCommand2.getPayload8Bits(n2);
            if (n >= 240) {
                n = n * 256 + eCMLinkCommand2.getPayload8Bits(++n2);
            }
            arrayList.add(this.createTOCEntry(list, n, true, true));
        }
        eCMLinkCommand = new ECMLinkCommand(4);
        eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        n5 = eCMLinkCommand2.getPayloadLength();
        for (n2 = 0; n2 < n5; ++n2) {
            n = eCMLinkCommand2.getPayload8Bits(n2);
            if (n >= 240) {
                n = n * 256 + eCMLinkCommand2.getPayload8Bits(++n2);
            }
            arrayList.add(this.createTOCEntry(list, n, true, false));
        }
        return arrayList;
    }

    private List readV3TOCEnries() throws IOException, DeviceException {
        int n = this.getConnectedDeviceId();
        int n2 = this.getConnectedSerialNum();
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(4);
        ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        int n3 = eCMLinkCommand2.getPayloadLength();
        if (n3 % 2 != 0) {
            throw new DeviceInternalException("Received an illegal payload size for TOC command");
        }
        List list = DataManager.getAliasAssignments(n, n2);
        ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
        for (int i = 0; i < n3; i += 2) {
            int n4 = eCMLinkCommand2.getPayload16Bits(i);
            arrayList.add(this.createTOCEntry(list, n4, false, false));
        }
        return arrayList;
    }

    private LocationTOCEntry createTOCEntry(List list, int n, boolean bl, boolean bl2) throws IOException, DeviceException {
        AliasAssignment aliasAssignment;
        int n2 = this.getConnectedDeviceId();
        Location location = DataManager.getLocationByAddress(n2, n, this.getConnectedFirmwareId());
        Location location2 = null;
        if (loggingFine) {
            logger.fine("Real TOC location: 0x" + XFormatter.toHex4(n) + " - " + (location == null ? "null" : location.getDisplayName()));
        }
        if (location == null) {
            logger.warning("Unknown location returned from device: deviceId = " + n2 + ", address = 0x" + XFormatter.toHex4(n));
            int n3 = 8;
            if (ECMLinkDeviceMap.isV3Device(n2)) {
                n3 = (n & 0x8000) == 32768 ? 16 : 8;
            }
            location = new Location(n2, n, n3);
        }
        if ((aliasAssignment = DataManager.findAssignmentOfLocation(list, location)) != null) {
            location2 = new Location(location, aliasAssignment.getFinalAlias());
            if (loggingFine) {
                logger.fine("    aliased as: " + location2.getDisplayName() + ", type " + location2.getDataType());
            }
        }
        boolean bl3 = bl2;
        if (!bl) {
            bl3 = this.dataAdapter.isAlwaysPresent(n2, location);
        }
        if (loggingFine) {
            logger.fine("    alwaysPresent: " + bl3);
        }
        return new LocationTOCEntry(location, location2, bl3);
    }

    void storeTOCDataToDevice(LocationTOC locationTOC) throws IOException, DeviceException {
        logger.fine("Attempting to store new TOC data to the ECU");
        int n = this.getConnectedDeviceId();
        LocationTOC locationTOC2 = this.getConnectedLocationTOC();
        ArrayList arrayList = new ArrayList(locationTOC2.getTOCEntries());
        if (locationTOC.getTOCEntries().equals(arrayList)) {
            logger.fine("No changes to TOC.  Ignoring update.");
            return;
        }
        List list = null;
        if (ECMLinkDeviceMap.isV3Device(n)) {
            list = this.setV3TOCEntries(locationTOC.getTOCEntries());
        } else if (ECMLinkDeviceMap.isV1V2Device(n)) {
            list = this.setV1V2TOCEntries(locationTOC.getTOCEntries());
        } else {
            throw new DeviceInternalException("No supported TOC for deviceId " + n);
        }
        if (list == null) {
            return;
        }
        StagingRecord stagingRecord = (StagingRecord)this.stagingRecordCache.get("LocationTOCData");
        stagingRecord.setCachedObj(list);
        locationTOC2.setTOCEntries(list);
    }

    private List setV1V2TOCEntries(List list) throws IOException, DeviceException {
        if (this.getByteSize(list) > 32) {
            throw new DeviceInvalidStateException("The number of items to log exceeds device capacity.");
        }
        List list2 = this.getAlwaysPresent(list, false);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(3);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Location location = ((LocationTOCEntry)iterator.next()).getRealLocation();
            if (location.getAddress() < 240) {
                eCMLinkCommand.add8Bits(location.getAddress());
                continue;
            }
            eCMLinkCommand.add16Bits(location.getAddress());
        }
        this.local_sendCommand(eCMLinkCommand);
        return this.readV1V2TOCEntries();
    }

    private List setV3TOCEntries(List list) throws IOException, DeviceException {
        if (list.size() > 48) {
            throw new DeviceInvalidStateException("The number of items to log exceeds device capacity.");
        }
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Location location = ((LocationTOCEntry)iterator.next()).getRealLocation();
            eCMLinkCommand.add16Bits(location.getAddress());
        }
        this.local_sendCommand(eCMLinkCommand);
        return this.readV3TOCEnries();
    }

    private int getByteSize(List list) {
        int n = 0;
        for (LocationTOCEntry locationTOCEntry : list) {
            n += locationTOCEntry.getLocation().getSize() / 8;
        }
        return n;
    }

    private List getAlwaysPresent(List list, boolean bl) {
        ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
        for (LocationTOCEntry locationTOCEntry : list) {
            if (bl != locationTOCEntry.isAlwaysPresent()) continue;
            arrayList.add(locationTOCEntry);
        }
        return arrayList;
    }

    void updateTOCWithNewAliasAssignments(int n, int n2, List list) {
        if (loggingFine) {
            logger.fine("Attempting to process new alias assignments for deviceId " + n + ", serialNum 0x" + n2);
            logger.fine("Currently connected = " + this.isConnected() + ", connectedDeviceId = " + this.connectedDeviceId + ", connectedSerialNum = " + this.connectedSerialNum);
        }
        if (!this.isConnected()) {
            return;
        }
        try {
            Object object2;
            int n3 = this.getConnectedDeviceId();
            int n4 = this.getConnectedSerialNum();
            LocationTOC locationTOC = this.getConnectedLocationTOC();
            if (n3 != n || n4 != n2 || locationTOC.isEmpty()) {
                return;
            }
            boolean bl = ECMLinkDeviceMap.isV1V2Device(n3);
            ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
            ArrayList arrayList2 = new ArrayList(locationTOC.getTOCEntries());
            for (Object object2 : arrayList2) {
                Location location = ((LocationTOCEntry)object2).getRealLocation();
                boolean bl2 = false;
                if (bl) {
                    bl2 = true;
                }
                LocationTOCEntry locationTOCEntry = this.createTOCEntry(list, location.getAddress(), bl2, ((LocationTOCEntry)object2).isAlwaysPresent());
                arrayList.add(locationTOCEntry);
            }
            object2 = (StagingRecord)this.stagingRecordCache.get("LocationTOCData");
            ((StagingRecord)object2).setCachedObj(arrayList);
            locationTOC.setTOCEntries(arrayList);
            this.cacheData.configRecordSet.setAliasAssignments(list);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Got unexpected exception", exception);
        }
    }

    private void updateRecordSetIfNotEmpty(RecordSet recordSet, BaseRecord baseRecord) {
        if (!recordSet.isEmpty()) {
            recordSet.updatePersistedRecord(baseRecord);
            if (ECMLinkRecordAdapter.DTC_TABLE_1GDSM_OBJECT_RECORD_ID.equals(baseRecord.getRecordID()) || ECMLinkRecordAdapter.DTC_TABLE_2GDSM_OBJECT_RECORD_ID.equals(baseRecord.getRecordID())) {
                recordSet.updateVolatileRecord(baseRecord);
            }
        }
    }

    private void sendConfigRecordUpdate(ConfigRecord configRecord) throws IOException, DeviceException {
        List<Integer> list;
        StagingRecord stagingRecord;
        int n = this.getConnectedDeviceId();
        if (loggingFine) {
            logger.fine("Writing update to device for '" + configRecord.getDescription() + "'");
        }
        if ((stagingRecord = (StagingRecord)this.stagingRecordCache.get(configRecord.getRecordID())) == null) {
            logger.info("FAILED: tried to store unsupported record '" + configRecord.getDescription() + "'");
            throw new DeviceInvalidDataException("'" + configRecord.getDescription() + "' unsupported by ECU");
        }
        boolean bl = true;
        if (((Number)configRecord.getRecordID()).intValue() == 51) {
            bl = false;
            logger.info("Sending setup record...we'll not allocate a new cache key");
        }
        int n2 = stagingRecord.getConfigRecordLocation();
        int n3 = configRecord.getByteLength();
        int[] nArray = new int[n3];
        configRecord.putToBytes(nArray, 0);
        ConfigRecord configRecord2 = (ConfigRecord)stagingRecord.getCachedObj();
        int n4 = configRecord2.getByteLength();
        int[] nArray2 = new int[n4];
        configRecord2.putToBytes(nArray2, 0);
        List list2 = list = this.connectedUseOffsetLoc ? this.findBlockDiffs(nArray, nArray2) : new ArrayList();
        if (list.size() == 0) {
            list.add(new Integer(0));
            list.add(new Integer(n3));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n5 = ((Number)iterator.next()).intValue();
            int n6 = ((Number)iterator.next()).intValue();
            if ((n5 & 1) == 1) {
                --n5;
                ++n6;
            }
            while (n6 > 0) {
                int n7 = n6 <= 92 ? n6 : 92;
                int[] nArray3 = new int[n7];
                System.arraycopy(nArray, n5, nArray3, 0, n7);
                this.setLocBytes(n, n2, n5, nArray3, bl);
                System.arraycopy(nArray, n5, nArray2, n5, n7);
                configRecord2.setFromBytes(nArray2, 0);
                this.cacheData.configRecordSet.updatePersistedRecord(configRecord2);
                if (this.connectedUseCacheKeys) {
                    Preferences preferences = this.getConfigNode();
                    String string = ECMLinkDeviceManager.getConfigCacheKey(((Number)configRecord2.getRecordID()).intValue());
                    preferences.putByteArray(string, XFormatter.toByteArray(nArray2));
                }
                n5 += n7;
                n6 -= n7;
            }
        }
        String string = "Successfully stored '" + configRecord.getDescription() + "' to device";
        logger.fine(string);
        this.sendNewStatusText(string);
    }

    private List findBlockDiffs(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        Iterator iterator;
        int n4;
        int n5 = nArray.length;
        List<Integer> list = new ArrayList<Integer>();
        if (loggingFinest) {
            logger.finest("Checking for differences in " + n5 + " bytes.");
        }
        int n6 = this.findDiffBlocksBelow510(nArray, nArray2, n5, list);
        if (n5 > 510) {
            int n7;
            n4 = 0;
            for (n7 = 510; n4 == 0 && n7 < n5; ++n7) {
                n4 = nArray2[n7] != nArray[n7] ? 1 : 0;
            }
            if (n4 != 0) {
                n7 = n5 - 510;
                list.add(new Integer(510));
                list.add(new Integer(n7));
                if (loggingFinest) {
                    logger.finest("Found difference starting at index 510 of " + n7 + " bytes");
                    n6 += n7;
                }
            }
        }
        n4 = list.size() / 2;
        if (loggingFinest) {
            logger.finest("Found a total of " + n4 + " diff blocks with " + n6 + " diff bytes");
        }
        float f = (float)n6 / (float)n5;
        if (loggingFinest) {
            logger.finest("Total change density: " + XFormatter.format(f, 2));
        }
        if (loggingFinest) {
            logger.finest("Going into merge function with the following:");
            iterator = list.iterator();
            n3 = 1;
            while (iterator.hasNext()) {
                n2 = ((Number)iterator.next()).intValue();
                n = ((Number)iterator.next()).intValue();
                logger.finest("Block " + n3 + ", start=" + n2 + ", len=" + n);
            }
        }
        list = this.mergeBlockDiffs(list);
        if (loggingFinest) {
            logger.finest("Returned from merge function with the following:");
            iterator = list.iterator();
            n3 = 1;
            while (iterator.hasNext()) {
                n2 = ((Number)iterator.next()).intValue();
                n = ((Number)iterator.next()).intValue();
                logger.finest("Block " + n3 + ", start=" + n2 + ", len=" + n);
            }
        }
        n4 = list.size() / 2;
        if (f > 0.45f && n4 > 2) {
            if (loggingFinest) {
                logger.finest("Change density too high...saving all");
            }
            list.clear();
            list.add(new Integer(0));
            list.add(new Integer(n5));
            return list;
        }
        return list;
    }

    private int findDiffBlocksBelow510(int[] nArray, int[] nArray2, int n, List list) {
        int n2;
        int n3 = n > 510 ? 510 : n;
        int n4 = 0;
        int n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray2[n2] == nArray[n2]) {
                if (n5 == -1) continue;
                int n6 = n2 - n5;
                list.add(new Integer(n5));
                list.add(new Integer(n6));
                if (loggingFinest) {
                    logger.finest("Found difference starting at index " + n5 + " of " + n6 + " bytes");
                }
                n5 = -1;
                continue;
            }
            ++n4;
            if (n5 != -1) continue;
            n5 = n2;
        }
        if (n5 != -1) {
            n2 = n3 - n5;
            list.add(new Integer(n5));
            list.add(new Integer(n2));
            if (loggingFinest) {
                logger.finest("Found difference starting at index " + n5 + " of " + n2 + " bytes");
            }
            n5 = -1;
        }
        return n4;
    }

    private List mergeBlockDiffs(List list) {
        int n;
        int n2 = list.size() / 2;
        if (loggingFinest) {
            logger.finest("Trying to merge " + n2 + " blocks of differences");
        }
        if (n2 < 2) {
            logger.finest("Not enough diffs to even consider merge.");
            return list;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = ((Number)list.get(0)).intValue();
        int n4 = n = ((Number)list.get(1)).intValue();
        for (int i = 2; i < list.size(); i += 2) {
            int n5 = ((Number)list.get(i)).intValue();
            int n6 = ((Number)list.get(i + 1)).intValue();
            int n7 = n4 + n6;
            int n8 = n5 + n6 - n3;
            float f = (float)n7 / (float)n8;
            if (loggingFinest) {
                logger.finest("Merge loop, i=" + i + ", mergedStart = " + n3 + ", mergedDiffCount = " + n4 + ", mergedLen = " + n + ", b2Start = " + n5 + ", b2Len = " + n6 + ", changeDensity = " + XFormatter.format(f, 2));
            }
            if (f > 0.6f) {
                if (loggingFinest) {
                    logger.finest("Merging current block into previous merged blocks");
                }
                n4 = n7;
                n = n8;
                continue;
            }
            if (loggingFinest) {
                logger.finest("Starting new merged block candidate");
            }
            arrayList.add(new Integer(n3));
            arrayList.add(new Integer(n));
            n3 = n5;
            n = n4 = n6;
        }
        arrayList.add(new Integer(n3));
        arrayList.add(new Integer(n));
        return arrayList;
    }

    private void setLocBytes(int n, int n2, int n3, int[] nArray, boolean bl) throws IOException, DeviceException {
        if ((n3 & 1) == 1) {
            throw new DeviceInvalidDataException("Received invalid offset for store command");
        }
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(1);
        eCMLinkCommand.addAddrBits(n, n2);
        if (this.connectedUseOffsetLoc) {
            eCMLinkCommand.add8Bits(n3 / 2);
            if (this.connectedUseCacheKeys) {
                if (bl) {
                    this.setLocalConfigKey(ECMLinkDeviceManager.createNewCacheKey());
                }
                eCMLinkCommand.add16Bits(this.connectedConfigKey);
                eCMLinkCommand.add16Bits(this.getLocalConfigKey());
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            eCMLinkCommand.add8Bits(nArray[i]);
        }
        ECMLinkCommand eCMLinkCommand2 = this.local_sendCommand(eCMLinkCommand);
        if (this.connectedUseCacheKeys) {
            if (eCMLinkCommand2.getPayloadLength() == 0) {
                throw new DeviceInternalException("ECU did not like address passed in SET_LOC");
            }
            if (eCMLinkCommand2.getPayloadLength() != 1) {
                throw new DeviceInternalException("ECU responded with unknown data on SET_LOC");
            }
            int n4 = eCMLinkCommand2.getPayload8Bits(0);
            if (n4 == 1) {
                this.setConnected(false);
                throw new DeviceInternalException("ECU data is out of sync with laptop!  Reconnect and resave is required.");
            }
            if (n4 != 0) {
                this.setConnected(false);
                throw new DeviceInternalException("Unknown error code " + n4 + " on SET_LOC.  Reconnect and resave is required.");
            }
            this.connectedConfigKey = this.getLocalConfigKey();
        }
    }

    ECMLinkCommand local_sendCommand(DeviceCommand deviceCommand) throws IOException, DeviceException {
        Object object = this.isInTxThread() ? this.device_sendCommand(deviceCommand) : this.manager_sendCommand(deviceCommand);
        return (ECMLinkCommand)object;
    }

    public ECMLinkDataAdapter getDataAdapter() {
        return this.dataAdapter;
    }

    public long getByteDelayMillis() {
        return this.byteDelayMillis;
    }

    public void setByteDelayMillis(long l) {
        long l2 = this.byteDelayMillis;
        this.byteDelayMillis = l;
        this.firePropertyChange(PROPERTYNAME_BYTE_DELAY_MILLIS, l2, l);
    }

    public long getCmdTimeoutMillis() {
        return this.cmdTimeoutMillis;
    }

    public void setCmdTimeoutMillis(long l) {
        long l2 = this.cmdTimeoutMillis;
        this.cmdTimeoutMillis = l;
        this.firePropertyChange(PROPERTYNAME_CMD_TIMEOUT_MILLIS, l2, l);
    }

    public int getConfiguredDeviceListId() {
        return this.configuredDeviceListId;
    }

    public void setConfiguredDeviceListId(int n) {
        int n2 = this.configuredDeviceListId;
        this.configuredDeviceListId = n;
        this.firePropertyChange(PROPERTYNAME_CONFIGURED_DEVICE_LIST_ID, n2, n);
    }

    public void setKeepCacheAcrossConnection(boolean bl) {
        this.keepCacheAcrossConnection = bl;
    }

    public static int getOptLocStart(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return 224;
            }
            case 16: 
            case 17: 
            case 24: {
                return 150;
            }
            case 32: {
                return 150;
            }
        }
        throw new RuntimeException("getOptLocStart-invalid deviceId");
    }

    public boolean doFastUpgrade() {
        return this.fastUpgrade;
    }

    public boolean isTestMode() {
        return this.testmode;
    }

    private final Preferences getConfigNode() {
        return this.cachePrefsNode.node("ecuconfig");
    }

    private final Preferences getDirectAccessNode() {
        return this.cachePrefsNode.node("directaccess");
    }

    private static final String getConfigCacheKey(int n) {
        return "recordid" + XFormatter.toHex4(n).toLowerCase();
    }

    private static final String getDirectAccessCacheKey(String string) {
        return string;
    }

    private static final int createNewCacheKey() {
        int n = 0;
        while (n == 0) {
            n = (int)Math.round(Math.random() * 65535.0) & 0xFFFF;
        }
        return n;
    }

    private final int getLocalConfigKey() {
        return this.cachePrefsNode.getInt(PREFSNAME_ECUCONFIGKEY, -1);
    }

    private final int getLocalDirectAccessKey() {
        return this.cachePrefsNode.getInt(PREFSNAME_DIRECTACCESSKEY, -1);
    }

    private final void setLocalConfigKey(int n) {
        this.cachePrefsNode.putInt(PREFSNAME_ECUCONFIGKEY, n);
    }

    private final void setLocalDirectAccessKey(int n) {
        this.cachePrefsNode.putInt(PREFSNAME_DIRECTACCESSKEY, n);
    }

    @Override
    protected void device_restoreFrom(Preferences preferences) {
        this.setByteDelayMillis(preferences.getInt(PROPERTYNAME_BYTE_DELAY_MILLIS, 0));
        this.setCmdTimeoutMillis(preferences.getInt(PROPERTYNAME_CMD_TIMEOUT_MILLIS, 500));
        this.setConfiguredDeviceListId(preferences.getInt(PROPERTYNAME_CONFIGURED_DEVICE_LIST_ID, 4));
        this.highbaudOverride = preferences.getBoolean(PROPERTYNAME_HIGHBAUD_OVERRRIDE, false);
        this.testmode = preferences.getBoolean(PROPERTYNAME_TEST_MODE, false);
        this.fastUpgrade = preferences.getBoolean(PROPERTYNAME_FAST_UPGRADE, false);
        this.cachePrefsNode = preferences.node("cachedata");
    }

    @Override
    protected void device_storeIn(Preferences preferences) {
        preferences.putInt(PROPERTYNAME_BYTE_DELAY_MILLIS, (int)this.getByteDelayMillis());
        preferences.putInt(PROPERTYNAME_CMD_TIMEOUT_MILLIS, (int)this.getCmdTimeoutMillis());
        preferences.putInt(PROPERTYNAME_CONFIGURED_DEVICE_LIST_ID, this.configuredDeviceListId);
    }

    static class StagingRecord {
        static final int TYPE_NONE = 0;
        static final int TYPE_CONFIG_RECORD = 1;
        static final int TYPE_BYTE_RECORD = 2;
        static final int TYPE_TOC = 3;
        static final String CACHED_OBJ_ID_TYPE_LOC = "LocationTOCData";
        final int recordType;
        final Object cachedObjId;
        final Object cachedObjInitData;
        Object cachedObj;
        final String description;

        StagingRecord() {
            this.recordType = 0;
            this.cachedObjId = null;
            this.cachedObjInitData = null;
            this.description = "";
        }

        StagingRecord(int n, int n2, int n3) {
            this.recordType = 1;
            this.cachedObjId = new Integer(n2);
            this.cachedObjInitData = new Integer(n3);
            this.description = ConfigRecord.getRecordDescription(n, n2);
        }

        StagingRecord(ByteRecordDescriptorBase byteRecordDescriptorBase) {
            this.recordType = 2;
            this.cachedObjId = byteRecordDescriptorBase.getRecordId();
            this.cachedObjInitData = byteRecordDescriptorBase;
            this.description = byteRecordDescriptorBase.getListBoxName();
        }

        StagingRecord(int n, String string) {
            this.recordType = n;
            this.cachedObjId = CACHED_OBJ_ID_TYPE_LOC;
            this.cachedObjInitData = null;
            this.description = string;
        }

        boolean isTypeConfigRecord() {
            return this.recordType == 1;
        }

        boolean isTypeByteRecord() {
            return this.recordType == 2;
        }

        boolean isTypeTOC() {
            return this.recordType == 3;
        }

        boolean isTypeNone() {
            return this.recordType == 0;
        }

        int getConfigRecordLocation() {
            if (!this.isTypeConfigRecord()) {
                throw new IllegalStateException("Called for non-config record entry");
            }
            return (Integer)this.cachedObjInitData;
        }

        int getConfigRecordId() {
            if (!this.isTypeConfigRecord()) {
                throw new IllegalStateException("Called for non-config record entry");
            }
            return (Integer)this.cachedObjId;
        }

        ByteRecordDescriptor getInitDataDescriptor() {
            if (!this.isTypeByteRecord()) {
                throw new IllegalStateException("Called for non-byte record entry");
            }
            return (ByteRecordDescriptor)this.cachedObjInitData;
        }

        void setCachedObj(Object object) {
            this.cachedObj = object;
        }

        Object getCachedObj() {
            return this.cachedObj;
        }

        BaseRecord getCachedBaseRecord() {
            return (BaseRecord)this.cachedObj;
        }

        List getCachedTOCList() {
            return (List)this.cachedObj;
        }

        boolean isEmpty() {
            return this.cachedObj == null;
        }

        public String toString() {
            return this.description;
        }
    }
}

