/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.util.ListUtil;
import java.util.logging.Logger;

public class ECMLinkDeviceMap {
    static final int[] ALL_ECMLINK_1GDSM_DEVICE_IDS_LIST = new int[]{16, 17, 24};
    static final int[] ALL_ECMLINK_1GDSM_V3_DEFINITION_IDS = new int[]{1, 2, 3, 4, 5};
    static final int[] ALL_ECMLINK_1GDSM_V3LITE_DEFINITION_IDS = new int[]{1, 2, 3};
    static final int[] ALL_ECMLINK_2GDSM_DEVICE_IDS_LIST = new int[]{1, 2, 3, 8};
    static final int[] ALL_ECMLINK_2GDSM_V3_DEFINITION_IDS = new int[]{1, 2, 3, 4, 5};
    static final int[] ALL_ECMLINK_2GDSM_V3LITE_DEFINITION_IDS = new int[]{1, 2, 3};
    static final int[] ALL_ECMLINK_E3_DEVICE_IDS_LIST = new int[]{32};
    static final int[] ALL_ECMLINK_E3_V3LITE_DEFINITION_IDS = new int[]{2, 3, 4, 5, 6};
    static final int[] ALL_ECMLINK_DEVICE_IDS_LIST = new int[]{1, 2, 16, 3, 8, 17, 24, 32};
    static final int[] ALL_V1_DEVICE_IDS_LIST = new int[]{1};
    static final int[] ALL_V2_DEVICE_IDS_LIST = new int[]{2, 16};
    static final int[] ALL_V3_DEVICE_IDS_LIST = new int[]{3, 8, 17, 24, 32};
    static final int[] ALL_V3_LITE_DEVICE_IDS_LIST = new int[]{8, 24, 32};
    private static final String DSMLINK_95DSM_V1_NAME = "DSMLink 2G v1";
    private static final String DSMLINK_95DSM_V2_NAME = "DSMLink 2G v2";
    private static final String DSMLINK_93DSM_V1_NAME = "DSMLink 1G v2";
    private static final String ECMLINK_93DSM_V3_NAME = "ECMLink 1G DSM v3";
    private static final String ECMLINK_93DSM_V3LITE_NAME = "ECMLink 1G DSM v3lite";
    private static final String ECMLINK_95DSM_V3_NAME = "ECMLink 2G DSM v3";
    private static final String ECMLINK_95DSM_V3LITE_NAME = "ECMLink 2G DSM v3lite";
    private static final String ECMLINK_EVO3_NAME = "ECMLink EVO1-3 v3lite";
    public static final int NULL_DEFINITION_ID = -1;
    private static final Logger logger = Logger.getLogger(ECMLinkDeviceMap.class.getName());
    public static final int ECMLINK_1GDSM_V1V2_LIST_ID = 1;
    public static final int ECMLINK_2GDSM_V1V2_LIST_ID = 2;
    public static final int ECMLINK_1GDSM_V3_LIST_ID = 3;
    public static final int ECMLINK_2GDSM_V3_LIST_ID = 4;
    public static final int ECMLINK_EVO3_V3_LIST_ID = 5;
    private static final String ECMLINK_1G_V1V2_LIST_NAME = "DSMLink v2 - 1G DSM";
    private static final String ECMLINK_2G_V1V2_LIST_NAME = "DSMLink v1/v2 - 2G DSM";
    private static final String ECMLINK_1G_V3_LIST_NAME = "ECMLink v3 - 1G DSM";
    private static final String ECMLINK_2G_V3_LIST_NAME = "ECMLink v3 - 2G DSM";
    private static final String ECMLINK_EVO3_V3_LIST_NAME = "ECMLink v3 - EVO1-3";

    public static String getDeviceDisplayName(int n) {
        switch (n) {
            case 1: {
                return DSMLINK_95DSM_V1_NAME;
            }
            case 2: {
                return DSMLINK_95DSM_V2_NAME;
            }
            case 16: {
                return DSMLINK_93DSM_V1_NAME;
            }
            case 3: {
                return ECMLINK_95DSM_V3_NAME;
            }
            case 8: {
                return ECMLINK_95DSM_V3LITE_NAME;
            }
            case 17: {
                return ECMLINK_93DSM_V3_NAME;
            }
            case 24: {
                return ECMLINK_93DSM_V3LITE_NAME;
            }
            case 32: {
                return ECMLINK_EVO3_NAME;
            }
        }
        return null;
    }

    public static boolean isECMLinkDevice(int n) {
        return ListUtil.isInList(n, ALL_ECMLINK_DEVICE_IDS_LIST);
    }

    public static boolean is1GDSMDevice(int n) {
        return ListUtil.isInList(n, ALL_ECMLINK_1GDSM_DEVICE_IDS_LIST);
    }

    public static boolean is2GDSMDevice(int n) {
        return ListUtil.isInList(n, ALL_ECMLINK_2GDSM_DEVICE_IDS_LIST);
    }

    public static boolean isEVO3Device(int n) {
        return ListUtil.isInList(n, ALL_ECMLINK_E3_DEVICE_IDS_LIST);
    }

    public static boolean isV1Device(int n) {
        return ListUtil.isInList(n, ALL_V1_DEVICE_IDS_LIST);
    }

    public static boolean isV2Device(int n) {
        return ListUtil.isInList(n, ALL_V2_DEVICE_IDS_LIST);
    }

    public static boolean isV1V2Device(int n) {
        return ECMLinkDeviceMap.isV1Device(n) || ECMLinkDeviceMap.isV2Device(n);
    }

    public static boolean isV3Device(int n) {
        return ListUtil.isInList(n, ALL_V3_DEVICE_IDS_LIST);
    }

    public static boolean isV3LiteDevice(int n) {
        return ListUtil.isInList(n, ALL_V3_LITE_DEVICE_IDS_LIST);
    }

    public static boolean isSameFamilyDevice(int n, int n2) {
        return ECMLinkDeviceMap.is1GDSMDevice(n) && ECMLinkDeviceMap.is1GDSMDevice(n2) || ECMLinkDeviceMap.is2GDSMDevice(n) && ECMLinkDeviceMap.is2GDSMDevice(n2) || ECMLinkDeviceMap.isEVO3Device(n) && ECMLinkDeviceMap.isEVO3Device(n2);
    }

    public static int getLatestDefinitionId(int n) {
        switch (n) {
            case 17: {
                return ALL_ECMLINK_1GDSM_V3_DEFINITION_IDS[ALL_ECMLINK_1GDSM_V3_DEFINITION_IDS.length - 1];
            }
            case 24: {
                return ALL_ECMLINK_1GDSM_V3LITE_DEFINITION_IDS[ALL_ECMLINK_1GDSM_V3LITE_DEFINITION_IDS.length - 1];
            }
            case 3: {
                return ALL_ECMLINK_2GDSM_V3_DEFINITION_IDS[ALL_ECMLINK_2GDSM_V3_DEFINITION_IDS.length - 1];
            }
            case 8: {
                return ALL_ECMLINK_2GDSM_V3LITE_DEFINITION_IDS[ALL_ECMLINK_2GDSM_V3LITE_DEFINITION_IDS.length - 1];
            }
            case 32: {
                return ALL_ECMLINK_E3_V3LITE_DEFINITION_IDS[ALL_ECMLINK_E3_V3LITE_DEFINITION_IDS.length - 1];
            }
        }
        return -1;
    }

    public static String getListDisplayName(int n) {
        switch (n) {
            case 1: {
                return ECMLINK_1G_V1V2_LIST_NAME;
            }
            case 3: {
                return ECMLINK_1G_V3_LIST_NAME;
            }
            case 2: {
                return ECMLINK_2G_V1V2_LIST_NAME;
            }
            case 4: {
                return ECMLINK_2G_V3_LIST_NAME;
            }
            case 5: {
                return ECMLINK_EVO3_V3_LIST_NAME;
            }
        }
        logger.warning("Invalid listId: " + n);
        return "unknown";
    }

    public static boolean is1GDSMList(int n) {
        return n == 1 || n == 3;
    }

    public static boolean is2GDSMList(int n) {
        return n == 2 || n == 4;
    }

    public static boolean isV1V2DSMList(int n) {
        return n == 1 || n == 2;
    }

    public static boolean isV3List(int n) {
        return n == 3 || n == 4 || n == 5;
    }

    public static String getDeviceVersionString(int n, int n2) {
        String string = ECMLinkDeviceMap.getVersionPrefix(n);
        if (ListUtil.isInList(n, ALL_V3_DEVICE_IDS_LIST)) {
            String string2 = Integer.toString((n2 & 0xFF00) >> 8) + "." + Integer.toString(n2 & 0xFF);
            string = string + "." + string2;
        }
        return string;
    }

    public static String getVersionPrefix(int n) {
        if (ListUtil.isInList(n, ALL_V1_DEVICE_IDS_LIST)) {
            return "1";
        }
        if (ListUtil.isInList(n, ALL_V2_DEVICE_IDS_LIST)) {
            return "2";
        }
        if (ListUtil.isInList(n, ALL_V3_DEVICE_IDS_LIST)) {
            return "3";
        }
        logger.warning("Invalid deviceId: " + n);
        return "unknown";
    }
}

