/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkCommand;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.exception.DeviceReflashConfigException;
import com.ecmtuning.ecmlink.device.ecmlink.exception.DeviceReflashModeException;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.CRCCCITT;
import com.ecmtuning.ecmlink.device.exception.DeviceInternalException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidDataException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECMLinkFlashOps {
    final ECMLinkDeviceManager devManager;
    private static final Logger logger = Logger.getLogger(ECMLinkFlashOps.class.getName());
    private static final boolean loggingFinest = logger.isLoggable(Level.FINEST);
    private static final boolean loggingFiner = logger.isLoggable(Level.FINER);
    private static final boolean loggingFine = logger.isLoggable(Level.FINE);
    int lastActiveBank;
    private static final int FLASHCMD_NOERR = 0;
    private static final int FLASHCMD_ERR_FAILED = 1;
    private static final int FLASHCMD_ERR_TIMEOUT = 2;
    private static final int FLASHCMD_ERR_BADDATA = 3;
    private static final int FLASHCMD_ERR_ACTIVE_MODIFY = 4;

    ECMLinkFlashOps(ECMLinkDeviceManager eCMLinkDeviceManager) {
        this.devManager = eCMLinkDeviceManager;
    }

    public void requestConfigSave() throws IOException, DeviceException {
        logger.fine("requestConfigSave called");
        boolean bl = false;
        try {
            this.devManager.setConnected(true);
            this.devManager.saveConfig();
            bl = true;
        }
        finally {
            if (!bl) {
                this.devManager.clearLocalCacheKeys();
            }
        }
    }

    public void clearLocalCacheKeys() {
        this.devManager.clearLocalCacheKeys();
    }

    public int requestReflashMode() throws IOException, DeviceException {
        logger.fine("requestReflashMode called");
        this.devManager.setConnected(true);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(10);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        int n = eCMLinkCommand2.getPayload8Bits(0);
        if (n != 0) {
            logger.info("reflashMode request rejected.  Error code " + n);
            if (n == 1) {
                throw new DeviceReflashModeException("Not allowed while engine is running.", n);
            }
            if (n == 2) {
                throw new DeviceReflashModeException("Ignition key appears to be off.", n);
            }
            if (n == 3) {
                throw new DeviceReflashConfigException();
            }
            throw new DeviceInternalException("Unknown Error returned from attempt to switch modes in ECU, errCode=" + n);
        }
        this.lastActiveBank = eCMLinkCommand2.getPayload8Bits(1) & 1;
        return this.lastActiveBank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashReboot(int n, boolean bl) throws IOException, DeviceException {
        if (loggingFine) {
            logger.fine("flashReboot called for bank " + n);
        }
        if (n != (n & 1)) {
            throw new DeviceInvalidDataException("Bank of " + n + " is invalid");
        }
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(36);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.add8Bits(n & 1);
        boolean bl2 = false;
        try {
            ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
            bl2 = true;
        }
        finally {
            try {
                if (bl && bl2) {
                    this.devManager.setKeepCacheAcrossConnection(true);
                }
                this.devManager.setConnected(false);
            }
            finally {
                this.devManager.setKeepCacheAcrossConnection(false);
            }
        }
    }

    public int[] getCRCBlocks(int n) throws IOException, DeviceException {
        if (loggingFine) {
            logger.fine("getCRCBlocks called for pageAddress 0x" + XFormatter.toHex4(n));
        }
        this.checkPageAddress(n);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(32);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.add8Bits(n & 0x1F);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = eCMLinkCommand2.getPayload8Bits(i * 2) * 256 + eCMLinkCommand2.getPayload8Bits(i * 2 + 1);
        }
        return nArray;
    }

    public void eraseInactiveSector(int n) throws IOException, DeviceException {
        n &= 0x1C;
        if (loggingFine) {
            logger.fine("eraseInactiveSector called for pageAddress 0x" + XFormatter.toHex4(n));
        }
        this.checkSectorAddress(n);
        boolean bl = this.devManager.getConnectedBootId() <= 4486;
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(33);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.setTimeoutMillis(bl ? 2000L : 6000L);
        eCMLinkCommand.add8Bits(n);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        int n2 = eCMLinkCommand2.getPayload8Bits(0);
        if (n2 == 2 && bl) {
            for (int i = 0; i < 40; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int[] nArray = this.getCRCBlocks(n);
                if (!this.isBlankCRCVals(nArray)) continue;
                return;
            }
        }
        this.checkAndThrowFlashError(eCMLinkCommand2, "erasing");
    }

    private boolean isBlankCRCVals(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 23343) continue;
            return false;
        }
        return true;
    }

    public void copyToInactiveBlock(int n, int n2) throws IOException, DeviceException {
        if (loggingFine) {
            logger.fine("copyToInactiveBlock called with start address 0x" + XFormatter.toHex4(n) + ", length=" + n2);
        }
        this.checkBlockAddress(n);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(34);
        eCMLinkCommand.setTimeoutMillis((n2 / 16 + 1) * 500);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.add16Bits(n & 0x1FF);
        eCMLinkCommand.add8Bits(n2);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        this.checkAndThrowFlashError(eCMLinkCommand2, "programming");
    }

    public boolean compareSector(int n) throws IOException, DeviceException {
        if (loggingFine) {
            logger.fine("compareSectors called for pageAddress 0x" + XFormatter.toHex4(n));
        }
        this.checkSectorAddress(n);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(37);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.add8Bits(n & 0x1C);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        return eCMLinkCommand2.getPayload8Bits(0) == 0;
    }

    public int[] readBlock(int n) throws IOException, DeviceException {
        int n2;
        if (loggingFine) {
            logger.fine("readBlock called for address 0x" + XFormatter.toHex4(n));
        }
        this.checkBlockAddress(n);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(38);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.add16Bits(n & 0x1FF);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        this.checkAndThrowFlashError(eCMLinkCommand2, "reading");
        int[] nArray = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            nArray[n2] = eCMLinkCommand2.getPayload8Bits(n2 + 1);
        }
        if (loggingFine) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 256; ++i) {
                if ((i & 0xF) == 0 && i > 0) {
                    logger.fine(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                stringBuffer.append("0x" + XFormatter.toHex2(nArray[i]) + " ");
            }
            logger.fine(stringBuffer.toString());
        }
        if ((n2 = CRCCCITT.calcCRC(nArray)) != eCMLinkCommand2.getPayload16Bits(257)) {
            throw new DeviceInternalException("Failed to read data from ECU.  CRC mismatch (0x" + XFormatter.toHex4(n2) + " != 0x" + XFormatter.toHex4(eCMLinkCommand2.getPayload16Bits(257)) + ").");
        }
        return nArray;
    }

    public void flashBlock(boolean bl, int n, int[] nArray, int n2) throws IOException, DeviceException {
        if (nArray.length != 256) {
            throw new DeviceInternalException("Invalid datablock length passed in for programming.");
        }
        boolean bl2 = false;
        for (int i = 0; !bl2 && i < 256; ++i) {
            if (nArray[i] == 255) continue;
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        if (loggingFine) {
            logger.fine("flashBlock called for address 0x" + XFormatter.toHex4(n));
        }
        this.checkBlockAddress(n);
        ECMLinkCommand eCMLinkCommand = new ECMLinkCommand(35);
        eCMLinkCommand.setAutoConnect(false);
        eCMLinkCommand.add8Bits(bl ? 1 : 0);
        eCMLinkCommand.add16Bits(n & 0x1FF);
        for (int i = 0; i < nArray.length; ++i) {
            eCMLinkCommand.add8Bits(nArray[i]);
        }
        eCMLinkCommand.add16Bits(n2);
        ECMLinkCommand eCMLinkCommand2 = this.devManager.local_sendCommand(eCMLinkCommand);
        this.checkAndThrowFlashError(eCMLinkCommand2, "programming");
    }

    private void checkPageAddress(int n) throws DeviceException {
        if (n != (n & 0x1F)) {
            throw new DeviceInvalidDataException("Page address of " + n + " is invalid");
        }
    }

    private void checkSectorAddress(int n) throws DeviceException {
        if (n != (n & 0x1C)) {
            throw new DeviceInvalidDataException("Sector address of " + n + " is invalid");
        }
    }

    private void checkBlockAddress(int n) throws DeviceException {
        if (n != (n & 0x1FF)) {
            throw new DeviceInvalidDataException("Block address of " + n + " is invalid");
        }
    }

    private void checkAndThrowFlashError(ECMLinkCommand eCMLinkCommand, String string) throws DeviceException {
        if (eCMLinkCommand == null) {
            throw new DeviceInternalException("Received no response from flash request!");
        }
        int n = eCMLinkCommand.getPayload8Bits(0);
        if (n != 0) {
            logger.info("Error code " + n + " returned from attempt to " + string + " device");
            if (n == 1) {
                throw new DeviceInvalidStateException("Device error while " + string + ".");
            }
            if (n == 2) {
                throw new DeviceInvalidStateException("Internal timeout while " + string + " device.");
            }
            if (n == 3) {
                throw new DeviceInvalidStateException("Verify failed while " + string + " device.");
            }
            if (n == 4) {
                throw new DeviceInternalException("Internal error while " + string + " device.  Invalid address.");
            }
            throw new DeviceInternalException("Unknown Error returned while " + string + " device.");
        }
    }
}

