/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.records.ALSV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.AuxV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.AuxV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC1GDSMRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC2GDSMRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTCE3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.DashV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.DashV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.DashV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.EGRV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.EGRV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.ExtendedSetupRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.ExtendedSetupV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FPSV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FPSV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FPSV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FPSV4Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FanV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FuelV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FuelV1_2_Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FuelV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FuelV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.FuelV4Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.IdleAirClampV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.IgnV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.IgnV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.KnockV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFClampV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFClampV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFClampV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV4Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV5Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV4Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV5Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV6Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV7Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV8Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV9Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscToolsV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscToolsV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscToolsV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscToolsV4Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.NBO2SimV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.RPMV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.RPMV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.SignatureRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.SpeedDensityV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.SpeedDensityV2Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.SpeedDensityV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.TPSV1Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.WGSV1Record;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.device.records.ConfigRecordAdapterInterface;
import java.util.logging.Logger;

public class ECMLinkRecordAdapter
implements ConfigRecordAdapterInterface {
    public static final int DTC_TABLE_EVO3_RECORD_ID = -3;
    public static final Integer DTC_TABLE_EVO3_OBJECT_RECORD_ID = new Integer(-3);
    public static final int DTC_TABLE_2GDSM_RECORD_ID = -2;
    public static final Integer DTC_TABLE_2GDSM_OBJECT_RECORD_ID = new Integer(-2);
    public static final int DTC_TABLE_1GDSM_RECORD_ID = -1;
    public static final Integer DTC_TABLE_1GDSM_OBJECT_RECORD_ID = new Integer(-1);
    public static final int FUEL_TABLE_V1_RECORD_ID = 1;
    public static final int IGN_TABLE_V1_RECORD_ID = 2;
    public static final int FAN_CONTROL_V1_RECORD_ID = 3;
    public static final int RPM_CONTROL_V1_RECORD_ID = 4;
    public static final int MISC_TOOLS_V1_RECORD_ID = 5;
    public static final int MAF_COMP_V1_RECORD_ID = 6;
    public static final int ALS_V1_RECORD_ID = 7;
    public static final int RPM_CONTROL_V2_RECORD_ID = 8;
    public static final int MAF_CLAMP_V1_RECORD_ID = 9;
    public static final int DASH_V1_RECORD_ID = 10;
    public static final int TPS_V1_RECORD_ID = 11;
    public static final int MISC_BITS_V1_RECORD_ID = 12;
    public static final int KNOCK_V1_RECORD_ID = 13;
    public static final int FPS_V1_RECORD_ID = 14;
    public static final int MAF_COMP_V2_RECORD_ID = 15;
    public static final int MISC_BITS_V2_RECORD_ID = 16;
    public static final int MISC_TOOLS_V2_RECORD_ID = 17;
    public static final int FPS_V2_RECORD_ID = 18;
    public static final int DASH_V2_RECORD_ID = 19;
    public static final int MISC_TOOLS_V3_RECORD_ID = 20;
    public static final int MISC_BITS_V3_RECORD_ID = 21;
    public static final int MISC_BITS_V4_RECORD_ID = 22;
    public static final int IDLE_AIR_CLAMP_V1_RECORD_ID = 23;
    public static final int NBO2SIM_V1_RECORD_ID = 24;
    public static final int FUEL_TABLE_V2_RECORD_ID = 25;
    public static final int IGN_TABLE_V2_RECORD_ID = 26;
    public static final int MAF_CLAMP_V2_RECORD_ID = 27;
    public static final int MAF_COMP_V3_RECORD_ID = 30;
    public static final int SIGNATURE_RECORD_ID = 31;
    public static final int MISC_BITS_V5_RECORD_ID = 32;
    public static final int MISC_BITS_V6_RECORD_ID = 33;
    public static final int EXTENDED_SETUP_RECORD_ID = 34;
    public static final int EGR_V1_RECORD_ID = 35;
    public static final int FPS_V3_RECORD_ID = 36;
    public static final int AUX_V1_RECORD_ID = 37;
    public static final int MAF_COMP_V4_RECORD_ID = 38;
    public static final int MAF_CLAMP_V3_RECORD_ID = 39;
    public static final int MISC_BITS_V7_RECORD_ID = 40;
    public static final int MISC_BITS_V8_RECORD_ID = 41;
    public static final int SPEED_DENSITY_V1_RECORD_ID = 42;
    public static final int DASH_V3_RECORD_ID = 43;
    public static final int MISC_BITS_V9_RECORD_ID = 44;
    public static final int MISC_TOOLS_V4_RECORD_ID = 45;
    public static final int FUEL_TABLE_V3_RECORD_ID = 46;
    public static final int SPEED_DENSITY_V2_RECORD_ID = 47;
    public static final int SPEED_DENSITY_V3_RECORD_ID = 48;
    public static final int MAF_COMP_V5_RECORD_ID = 49;
    public static final int WGS_V1_RECORD_ID = 50;
    public static final int EXTENDED_SETUP_V2_RECORD_ID = 51;
    public static final int FPS_V4_RECORD_ID = 52;
    public static final int EGR_V2_RECORD_ID = 53;
    public static final int AUX_V2_RECORD_ID = 54;
    public static final int FUEL_TABLE_V4_RECORD_ID = 55;
    public static final int FUEL_TABLE_V1_2_RECORD_ID = 56;
    public static final int[] RPM_CONTROL_RECORD_IDS = new int[]{4, 8};
    public static final int[] FPS_V1V2RECORD_IDS = new int[]{14, 18};
    public static final int[] FPS_V3V4RECORD_IDS = new int[]{36, 52};
    public static final int[] AUX_V1V2RECORD_IDS = new int[]{37, 54};
    public static final int[] FPS_RECORD_IDS = new int[]{14, 18, 36, 52};
    public static final int[] EGR_V1V2RECORD_IDS = new int[]{35, 53};
    public static final int[] MISC_BITS_RECORD_IDS = new int[]{12, 16, 21, 22, 32, 33, 40, 41, 44};
    public static final int[] MISC_TOOLS_RECORD_IDS = new int[]{5, 17, 20, 45};
    private static final Logger logger = Logger.getLogger(ECMLinkRecordAdapter.class.getName());

    public static ConfigRecord _createRecord(int n, int n2) {
        ConfigRecord configRecord = null;
        switch (n2) {
            case 1: {
                configRecord = new FuelV1Record(n);
                break;
            }
            case 56: {
                configRecord = new FuelV1_2_Record(n);
                break;
            }
            case 25: {
                configRecord = new FuelV2Record(n);
                break;
            }
            case 46: {
                configRecord = new FuelV3Record(n);
                break;
            }
            case 55: {
                configRecord = new FuelV4Record(n);
                break;
            }
            case 2: {
                configRecord = new IgnV1Record(n);
                break;
            }
            case 26: {
                configRecord = new IgnV2Record(n);
                break;
            }
            case 3: {
                configRecord = new FanV1Record(n);
                break;
            }
            case 4: {
                configRecord = new RPMV1Record(n);
                break;
            }
            case 5: {
                configRecord = new MiscToolsV1Record(n);
                break;
            }
            case 6: {
                configRecord = new MAFV1Record(n);
                break;
            }
            case 7: {
                configRecord = new ALSV1Record(n);
                break;
            }
            case 8: {
                configRecord = new RPMV2Record(n);
                break;
            }
            case 9: {
                configRecord = new MAFClampV1Record(n);
                break;
            }
            case 27: {
                configRecord = new MAFClampV2Record(n);
                break;
            }
            case 39: {
                configRecord = new MAFClampV3Record(n);
                break;
            }
            case 10: {
                configRecord = new DashV1Record(n);
                break;
            }
            case 19: {
                configRecord = new DashV2Record(n);
                break;
            }
            case 43: {
                configRecord = new DashV3Record(n);
                break;
            }
            case 11: {
                configRecord = new TPSV1Record(n);
                break;
            }
            case 12: {
                configRecord = new MiscBitsV1Record(n);
                break;
            }
            case 13: {
                configRecord = new KnockV1Record(n);
                break;
            }
            case 14: {
                configRecord = new FPSV1Record(n);
                break;
            }
            case 15: {
                configRecord = new MAFV2Record(n);
                break;
            }
            case 30: {
                configRecord = new MAFV3Record(n);
                break;
            }
            case 38: {
                configRecord = new MAFV4Record(n);
                break;
            }
            case 49: {
                configRecord = new MAFV5Record(n);
                break;
            }
            case 16: {
                configRecord = new MiscBitsV2Record(n);
                break;
            }
            case 17: {
                configRecord = new MiscToolsV2Record(n);
                break;
            }
            case 18: {
                configRecord = new FPSV2Record(n);
                break;
            }
            case 36: {
                configRecord = new FPSV3Record(n);
                break;
            }
            case 52: {
                configRecord = new FPSV4Record(n);
                break;
            }
            case 20: {
                configRecord = new MiscToolsV3Record(n);
                break;
            }
            case 45: {
                configRecord = new MiscToolsV4Record(n);
                break;
            }
            case 21: {
                configRecord = new MiscBitsV3Record(n);
                break;
            }
            case 22: {
                configRecord = new MiscBitsV4Record(n);
                break;
            }
            case 32: {
                configRecord = new MiscBitsV5Record(n);
                break;
            }
            case 33: {
                configRecord = new MiscBitsV6Record(n);
                break;
            }
            case 40: {
                configRecord = new MiscBitsV7Record(n);
                break;
            }
            case 41: {
                configRecord = new MiscBitsV8Record(n);
                break;
            }
            case 44: {
                configRecord = new MiscBitsV9Record(n);
                break;
            }
            case -1: {
                configRecord = new DTC1GDSMRecord(n);
                break;
            }
            case -2: {
                configRecord = new DTC2GDSMRecord(n);
                break;
            }
            case -3: {
                configRecord = new DTCE3Record(n);
                break;
            }
            case 23: {
                configRecord = new IdleAirClampV1Record(n);
                break;
            }
            case 24: {
                configRecord = new NBO2SimV1Record(n);
                break;
            }
            case 31: {
                configRecord = new SignatureRecord(n);
                break;
            }
            case 34: {
                configRecord = new ExtendedSetupRecord(n);
                break;
            }
            case 51: {
                configRecord = new ExtendedSetupV2Record(n);
                break;
            }
            case 35: {
                configRecord = new EGRV1Record(n);
                break;
            }
            case 53: {
                configRecord = new EGRV2Record(n);
                break;
            }
            case 50: {
                configRecord = new WGSV1Record(n);
                break;
            }
            case 37: {
                configRecord = new AuxV1Record(n);
                break;
            }
            case 54: {
                configRecord = new AuxV2Record(n);
                break;
            }
            case 42: {
                configRecord = new SpeedDensityV1Record(n);
                break;
            }
            case 47: {
                configRecord = new SpeedDensityV2Record(n);
                break;
            }
            case 48: {
                configRecord = new SpeedDensityV3Record(n);
                break;
            }
            default: {
                configRecord = null;
            }
        }
        return configRecord;
    }

    static String _getRecordDescription(int n, int n2) {
        ConfigRecord configRecord = ECMLinkRecordAdapter._createRecord(n, n2);
        if (configRecord != null) {
            return configRecord.getDescription();
        }
        String string = "Unknown device, record id: " + n + "," + n2;
        logger.info(string);
        return string;
    }

    @Override
    public ConfigRecord createRecord(int n, int n2) {
        return ECMLinkRecordAdapter._createRecord(n, n2);
    }

    @Override
    public String getRecordDescription(int n, int n2) {
        return ECMLinkRecordAdapter._getRecordDescription(n, n2);
    }
}

