/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink;

import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkCommand;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceDatastream;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.StreamQueueEntry;
import com.ecmtuning.ecmlink.util.CircularQueue;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

class ECMLinkStreamThread
extends Thread {
    protected CircularQueue queue;
    protected final Object queueMutex = new Object();
    protected final ECMLinkDeviceDatastream datastreamInterface;
    private final boolean highbaudOverride;
    private final int deviceId;
    private final boolean isV3Device;
    private final boolean[] isAlias;
    private final boolean[] is2Byte;
    private final float[] maxValueDivisor;
    private final int expectedPayloadSize;
    private final int outputPacketSize;
    private boolean stopRequested = false;
    private long loopSleepMillis;
    private static final Logger logger = Logger.getLogger(ECMLinkStreamThread.class.getName());
    private static final boolean loggingFinest = logger.isLoggable(Level.FINEST);
    private static final boolean loggingFine = logger.isLoggable(Level.FINE);
    PropertyChangeListener updateRateListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ECMLinkStreamThread.this.updateLoopSleepMillis();
            Object object = ECMLinkStreamThread.this.queueMutex;
            synchronized (object) {
                ECMLinkStreamThread.this.queue = ECMLinkStreamThread.this.createNewQueue(ECMLinkStreamThread.this.deviceId, ECMLinkStreamThread.this.loopSleepMillis, ECMLinkStreamThread.this.queue);
            }
        }
    };

    ECMLinkStreamThread(LocationTOC locationTOC, ECMLinkDeviceDatastream eCMLinkDeviceDatastream, boolean bl) {
        this.datastreamInterface = eCMLinkDeviceDatastream;
        this.deviceId = locationTOC.getDeviceId();
        this.isV3Device = ECMLinkDeviceMap.isV3Device(this.deviceId);
        this.highbaudOverride = bl;
        this.updateLoopSleepMillis();
        this.queue = this.createNewQueue(this.deviceId, this.loopSleepMillis, null);
        DatasetManager datasetManager = DatasetManager.getInstance();
        WeakListeners.addPropertyChangeListener(this.updateRateListener, (Object)datasetManager, "screenupdatehz");
        this.isAlias = new boolean[256];
        this.is2Byte = new boolean[256];
        Arrays.fill(this.isAlias, false);
        Arrays.fill(this.is2Byte, false);
        this.maxValueDivisor = new float[256];
        Arrays.fill(this.maxValueDivisor, 1.0f);
        int n = 2;
        for (LocationTOCEntry locationTOCEntry : locationTOC.getTOCEntries()) {
            int n2 = locationTOCEntry.getRealLocation().getSize();
            boolean bl2 = locationTOCEntry.isAliased();
            if (n2 < 8 || n2 > 16) {
                logger.warning("Found invalid bit size of " + n2 + " for realLocation = " + locationTOCEntry.getRealLocation().getAssignedName());
                continue;
            }
            boolean bl3 = n2 > 8;
            this.isAlias[n] = bl2;
            this.is2Byte[n] = bl3;
            this.maxValueDivisor[n] = (float)(Math.pow(2.0, n2) - 1.0);
            ++n;
            if (!bl3) continue;
            this.isAlias[++n] = this.isAlias[n - 1];
            this.is2Byte[n] = this.is2Byte[n - 1];
            this.maxValueDivisor[n] = this.maxValueDivisor[n - 1];
        }
        this.expectedPayloadSize = n;
        this.outputPacketSize = locationTOC.getTOCEntries().size();
        this.setName("ECMLinkStreamThread");
        this.setDaemon(true);
    }

    private CircularQueue createNewQueue(int n, long l, CircularQueue circularQueue) {
        int n2 = 20;
        if (ECMLinkDeviceMap.isV3Device(n)) {
            n2 = 30;
        } else if (ECMLinkDeviceMap.is1GDSMDevice(n)) {
            n2 = this.highbaudOverride ? 30 : 10;
        }
        int n3 = 1000 / n2;
        int n4 = (int)l / n3;
        if (n4 < 1) {
            n4 = 1;
        }
        Object[] objectArray = new StreamQueueEntry[n4 * 10];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new StreamQueueEntry();
        }
        CircularQueue circularQueue2 = new CircularQueue(objectArray);
        if (loggingFine) {
            logger.fine("Created queue with capacity of " + objectArray.length);
        }
        if (circularQueue != null) {
            circularQueue2.copyQueueDataFrom(circularQueue);
        }
        return circularQueue2;
    }

    private void updateLoopSleepMillis() {
        float f = DatasetManager.getInstance().getScreenUpdateHz();
        this.loopSleepMillis = Math.round(1000.0f / f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueCmdData(ECMLinkCommand eCMLinkCommand, long l) {
        Object object = this.queueMutex;
        synchronized (object) {
            StreamQueueEntry streamQueueEntry = (StreamQueueEntry)this.queue.push();
            streamQueueEntry.setContents(eCMLinkCommand, l);
        }
    }

    void requestStop() {
        this.stopRequested = true;
        if (this.isAlive()) {
            int n;
            try {
                for (n = 0; n < 4; ++n) {
                    Thread.sleep(this.loopSleepMillis);
                    if (this.isAlive()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isAlive()) {
                logger.info("Failed to stop streaming thread once.  Will try again.");
                this.interrupt();
                if (this.isAlive()) {
                    try {
                        for (n = 0; n < 4; ++n) {
                            Thread.sleep(this.loopSleepMillis);
                            if (this.isAlive()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.isAlive()) {
                        logger.warning("Failed to cleanly stop streaming thread");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        long l3 = 0L;
        double d = 0.0;
        float[] fArray = new float[this.outputPacketSize];
        ArrayList<TSDataPacket> arrayList = new ArrayList<TSDataPacket>();
        while (!this.stopRequested) {
            Object object = this.queueMutex;
            synchronized (object) {
                try {
                    this.queueMutex.wait(this.loopSleepMillis);
                }
                catch (InterruptedException interruptedException) {
                    logger.info("Stream thread interrupted");
                }
                int n3 = this.queue.size();
                if (n3 == 0) {
                    continue;
                }
                for (int i = 0; i < n3; ++i) {
                    StreamQueueEntry streamQueueEntry = (StreamQueueEntry)this.queue.pop(true);
                    int[] nArray = streamQueueEntry.payloadData;
                    int n4 = streamQueueEntry.payloadLength;
                    long l4 = streamQueueEntry.receiveTimeMillis;
                    if (this.isV3Device && n4 != this.expectedPayloadSize || !this.isV3Device && n4 < this.expectedPayloadSize) {
                        if (n < 4) {
                            logger.warning("Unexpected payload size received!  Expected " + this.expectedPayloadSize + ", got " + n4);
                        } else if (n == 5) {
                            logger.warning("Received too many payload size errors.  Individual logging of this error stopped.");
                        } else if (n % 50 == 0) {
                            logger.warning("Received another 50 packets with invalid payload size");
                        }
                        ++n;
                        continue;
                    }
                    int n5 = nArray[0] * 256 + nArray[1];
                    if (l == 0L) {
                        l = l2 = l4;
                        n2 = n5;
                    } else {
                        long l5 = l4 - l2;
                        l2 = l4;
                        double d2 = 0.0;
                        if (l5 > 272L) {
                            long l6 = l5 / 262L;
                        }
                        d2 = n5 > n2 ? (d2 += (double)(4 * (n5 - n2))) : (d2 += (double)(4 * (65536 - n2 + n5)));
                        n2 = n5;
                        l3 = l4 - l;
                        d += d2;
                        if (loggingFine && l5 > 1000L) {
                            logger.fine("Stream gap of " + l5 + " millis detected at running time " + l3);
                        }
                        if (loggingFinest) {
                            logger.finest("PC stream millis " + l3 + ", ECU " + d / 1000.0);
                        }
                    }
                    int n6 = 0;
                    for (int j = 2; j < this.expectedPayloadSize; ++j) {
                        float f = nArray[j];
                        if (this.is2Byte[j]) {
                            f = 256.0f * f + (float)nArray[++j];
                        }
                        if (this.isAlias[j]) {
                            f = 5.0f * f / this.maxValueDivisor[j];
                        }
                        fArray[n6++] = f;
                    }
                    arrayList.add(new TSDataPacket(d, fArray));
                }
            }
            this.datastreamInterface.fireStreamDataReceived(arrayList);
            arrayList.clear();
        }
    }
}

