/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.firmware;

import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.exception.DeviceUnsupportedOperationException;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FirmwareUpgradeRequest {
    public final int deviceId;
    public final int serialNum;
    public final int definitionId;
    public final int firmwareId;
    public final LocationTOC toc;
    public final ByteRecordSet byteRS;
    public final ECMLinkConfigRecordSet configRS;
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = -8413223053834044884L;

    private FirmwareUpgradeRequest(DataInputStream dataInputStream) throws IOException {
        this.deviceId = dataInputStream.readInt();
        this.serialNum = dataInputStream.readInt();
        this.definitionId = dataInputStream.readInt();
        this.firmwareId = dataInputStream.readInt();
        this.toc = LocationTOC.read(dataInputStream);
        this.byteRS = (ByteRecordSet)ByteRecordSet.read(dataInputStream);
        this.configRS = (ECMLinkConfigRecordSet)ECMLinkConfigRecordSet.read(dataInputStream);
    }

    public FirmwareUpgradeRequest(ECMLinkDeviceManager eCMLinkDeviceManager) throws Exception {
        this.deviceId = eCMLinkDeviceManager.getConnectedDeviceId();
        if (!ECMLinkDeviceMap.isV3Device(this.deviceId)) {
            throw new DeviceUnsupportedOperationException("This ECU does not support firmware upgrades.");
        }
        this.serialNum = eCMLinkDeviceManager.getConnectedSerialNum();
        this.definitionId = eCMLinkDeviceManager.getConnectedDefinitionId();
        this.firmwareId = eCMLinkDeviceManager.getConnectedFirmwareId();
        this.toc = eCMLinkDeviceManager.getConnectedLocationTOC();
        this.byteRS = eCMLinkDeviceManager.getByteRecordSet();
        this.configRS = eCMLinkDeviceManager.getConfigRecordSet();
    }

    public FirmwareUpgradeRequest(ByteRecordSet byteRecordSet, ECMLinkConfigRecordSet eCMLinkConfigRecordSet) {
        this.deviceId = byteRecordSet.getDeviceId();
        this.serialNum = eCMLinkConfigRecordSet.getSerialNum();
        this.definitionId = byteRecordSet.getDefinitionId();
        this.firmwareId = -1;
        this.toc = new LocationTOC(this.deviceId);
        this.byteRS = byteRecordSet;
        this.configRS = eCMLinkConfigRecordSet;
    }

    public void write(File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        this.write(dataOutputStream);
        dataOutputStream.close();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, -8413223053834044884L, 1);
        dataOutputStream.writeInt(this.deviceId);
        dataOutputStream.writeInt(this.serialNum);
        dataOutputStream.writeInt(this.definitionId);
        dataOutputStream.writeInt(this.firmwareId);
        this.toc.write(dataOutputStream);
        this.byteRS.write(dataOutputStream);
        this.configRS.write(dataOutputStream);
    }

    public static FirmwareUpgradeRequest read(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            inputStream = new FileInputStream(file);
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        FirmwareUpgradeRequest firmwareUpgradeRequest = FirmwareUpgradeRequest.read(dataInputStream);
        dataInputStream.close();
        return firmwareUpgradeRequest;
    }

    public static FirmwareUpgradeRequest read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "FirmwareUpgradeRequest", -8413223053834044884L, 1);
        FirmwareUpgradeRequest firmwareUpgradeRequest = new FirmwareUpgradeRequest(dataInputStream);
        return firmwareUpgradeRequest;
    }
}

