/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.data.AliasAssignment;
import com.ecmtuning.ecmlink.device.data.AliasAssignmentInterface;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.records.ConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.GenericListenerAdapter;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ECMLinkConfigRecordSet
extends ConfigRecordSet {
    protected final int originalSerialNum;
    protected List aliasAssignments;
    private final GenericListenerAdapter aliasListeners = new GenericListenerAdapter(AliasAssignmentInterface.class);
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 6221538772117830889L;

    public ECMLinkConfigRecordSet(int n, int n2) {
        this(n, n2, n != 0 ? DataManager.getAliasAssignments(n, n2) : Collections.EMPTY_LIST);
    }

    public ECMLinkConfigRecordSet(int n, int n2, List list) {
        super(n);
        this.originalSerialNum = n2;
        this.aliasAssignments = Collections.unmodifiableList(new ArrayList(list));
    }

    public ECMLinkConfigRecordSet(ECMLinkConfigRecordSet eCMLinkConfigRecordSet) {
        super(eCMLinkConfigRecordSet.getDeviceId());
        this.setPersistedMap(eCMLinkConfigRecordSet.getPersistentRecordMapCopy());
        this.originalSerialNum = eCMLinkConfigRecordSet.originalSerialNum;
        this.aliasAssignments = eCMLinkConfigRecordSet.aliasAssignments;
    }

    public void setAliasAssignments(List list) {
        this.aliasAssignments = Collections.unmodifiableList(new ArrayList(list));
        this.fireNewAliasAssignments(this.aliasAssignments);
    }

    public List getAliasAssignments() {
        return this.aliasAssignments;
    }

    public void addAliasAssignmentListener(AliasAssignmentInterface aliasAssignmentInterface) {
        this.aliasListeners.addListener(aliasAssignmentInterface);
    }

    public void removeAliasAssignmentListener(AliasAssignmentInterface aliasAssignmentInterface) {
        this.aliasListeners.removeListener(aliasAssignmentInterface);
    }

    protected void fireNewAliasAssignments(List list) {
        Iterator iterator = new ArrayList(this.aliasListeners.getListeners()).iterator();
        while (iterator.hasNext()) {
            ((AliasAssignmentInterface)iterator.next()).newAliasAssignments(list);
        }
    }

    public int getSerialNum() {
        return this.originalSerialNum;
    }

    @Override
    public synchronized void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 6221538772117830889L, 1);
        dataOutputStream.writeInt(this.originalDeviceId);
        dataOutputStream.writeInt(this.originalSerialNum);
        FileUtils.writeList(this.aliasAssignments, dataOutputStream);
        ECMLinkConfigRecordSet.writeRecordMap(dataOutputStream, this.volatileRecordMap);
    }

    public static RecordSet read(DataInputStream dataInputStream) throws IOException {
        boolean bl;
        long l = dataInputStream.readLong();
        if (l == 1263332511627593028L) {
            bl = true;
        } else if (l == 6221538772117830889L) {
            bl = false;
        } else {
            throw new IOException("Missing appropriate header information while reading ECMLinkConfigRecordSet");
        }
        int n = dataInputStream.readInt();
        if (n > 1) {
            throw new IOException("Incompatible file version while reading ECMLinkConfigRecordSet");
        }
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        ArrayList arrayList = new ArrayList();
        if (!bl) {
            n3 = dataInputStream.readInt();
            System.out.println("SerialNum of datalog: 0x" + XFormatter.toHex4(n3));
            FileUtils.readList(dataInputStream, arrayList, AliasAssignment.class);
        }
        Map map = ECMLinkConfigRecordSet.readRecordMap(dataInputStream, ConfigRecordSet.reader);
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = new ECMLinkConfigRecordSet(n2, n3, arrayList);
        eCMLinkConfigRecordSet.setPersistedMap(map);
        return eCMLinkConfigRecordSet;
    }

    public static int readDeviceId(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        if (l != 1263332511627593028L && l != 6221538772117830889L) {
            throw new IOException("Missing appropriate header information while reading ECMLinkConfigRecordSet");
        }
        int n = dataInputStream.readInt();
        if (n > 1) {
            throw new IOException("Incompatible file version while reading ECMLinkConfigRecordSet");
        }
        int n2 = dataInputStream.readInt();
        return n2;
    }
}

