/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.FuelScaleField;
import com.ecmtuning.ecmlink.device.ecmlink.records.FuelV3Record;
import com.ecmtuning.ecmlink.device.records.Scale256ListField;
import com.ecmtuning.ecmlink.device.records.SignedInt16Field;

public class FuelV4Record
extends FuelV3Record {
    public static final String MIN_IPW_FIELD_NAME = "MinIPW";
    public static final String FEATURE_MIN_IPW = "minIPW";

    public FuelV4Record(int n) {
        super(n, 55);
        this.addField("FuelTable", new Scale256ListField(10.0f, 80.0f, -50.0f, 17));
        this.addField("InjScale", new FuelScaleField());
        this.addField("GblInjDeadTime", new SignedInt16Field(-1000.0f, 2000.0f));
        this.addField("InjDeadTimeCyl1", new SignedInt16Field(-1000.0f, 2000.0f));
        this.addField("InjDeadTimeCyl2", new SignedInt16Field(-1000.0f, 2000.0f));
        this.addField("InjDeadTimeCyl3", new SignedInt16Field(-1000.0f, 2000.0f));
        this.addField("InjDeadTimeCyl4", new SignedInt16Field(-1000.0f, 2000.0f));
        this.addField(MIN_IPW_FIELD_NAME, new SignedInt16Field(840.0f, 4000.0f));
        this.addFeature("allInjDeadTimeFeature", this.stringAccesor("GblInjDeadTime"));
        this.addFeature("injDeadtimeCyl1Feature", this.stringAccesor("InjDeadTimeCyl1"));
        this.addFeature("injDeadtimeCyl2Feature", this.stringAccesor("InjDeadTimeCyl2"));
        this.addFeature("injDeadtimeCyl3Feature", this.stringAccesor("InjDeadTimeCyl3"));
        this.addFeature("injDeadtimeCyl4Feature", this.stringAccesor("InjDeadTimeCyl4"));
        this.addFeature(FEATURE_MIN_IPW, this.stringAccesor(MIN_IPW_FIELD_NAME));
    }

    @Override
    public String getDescription() {
        return "Fuel data (V4)";
    }
}

