/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.MAFClampPntField;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.device.records.Scale128ListField;
import com.ecmtuning.ecmlink.device.records.Scale256Field;

public class MAFClampV1Record
extends ConfigRecord {
    public static final String VE_TABLE_FIELD_NAME = "VETbl";
    public static final String MAP_DECAY_FIELD_NAME = "MAPDecay";
    public static final String MAP_OFFSET_FIELD_NAME = "MAPOffset";
    public static final String MAF_CLAMP_AND_BITS_FIELD_NAME = "MAFClampPnt";
    public static final String FEATURE_MAP_OFFSET = "mapOffsetFeature";

    public MAFClampV1Record(int n) {
        super(n, 9);
        this.addV1FieldsAndFeatures();
    }

    protected void addV1FieldsAndFeatures() {
        this.addField(VE_TABLE_FIELD_NAME, new Scale128ListField(50.0f, 110.0f, 0.0f, 17));
        this.addField(MAP_DECAY_FIELD_NAME, new Scale256Field());
        this.addField(MAP_OFFSET_FIELD_NAME, new Float8Field(0.019607844f, 0.0f, 1.5f, 0.0f));
        this.addField(MAF_CLAMP_AND_BITS_FIELD_NAME, new MAFClampPntField());
        this.addFeature(FEATURE_MAP_OFFSET, this.stringAccesor(MAP_OFFSET_FIELD_NAME, 2));
    }

    @Override
    public String getDescription() {
        return "MAF clamp (V1)";
    }

    public MAFClampV1Record(int n, int n2) {
        super(n, n2);
    }
}

