/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV2Record;
import com.ecmtuning.ecmlink.device.records.BitMaskField;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.device.records.SignedInt8Field;

public class MiscBitsV3Record
extends MiscBitsV2Record {
    public static final String MISCBITS2_FIELD_NAME = "MiscBits2";
    public static final String LOCK_IATVAL_FIELD_NAME = "LockIATVal";
    public static final String LOCK_BARO_FIELD_NAME = "LockBaroVal";
    public static final String LOCK_FRONTO2_FIELD_NAME = "LockFrontO2Val";
    public static final String LOCK_COOLANT_FIELD_NAME = "LockCoolantVal";
    public static final String LOCK_EGRT_FIELD_NAME = "LockEGRTVal";
    public static final String LOCK_MDP_FIELD_NAME = "LockMDPVal";
    public static final String LOCK_REARO2_FIELD_NAME = "LockRearO2Val";
    public static final String INTAKE_TEMP_INPUTX_FIELD_NAME = "IntakeTempInputX";
    public static final String MAP_INPUTX_FIELD_NAME = "MAPInputX";
    public static final String WB_INPUTX_FIELD_NAME = "WBInputX";
    public static final int MB1_LOCK_COMM = 4;
    public static final int MB2_FORCE_OPENLOOP = 128;
    public static final int MB2_INVERT_CLUTCH = 64;
    public static final int MB2_LOCK_IAT_BARO = 32;
    public static final int MB2_LOCK_MDP = 16;
    public static final int MB2_LOCK_REARO2 = 8;
    public static final int MB2_LOCK_FRONTO2 = 4;
    public static final int MB2_LOCK_EGRT = 2;
    public static final int MB2_LOCK_COOLANT = 1;
    public static final String FEATURE_LOCK_COMM = "lockComm";
    public static final String FEATURE_LOCK_IAT_BARO = "lockIATBaro";
    public static final String FEATURE_LOCK_MDP = "lockMDP";
    public static final String FEATURE_LOCK_REARO2 = "lockRearO2";
    public static final String FEATURE_LOCK_FRONTO2 = "lockFrontO2";
    public static final String FEATURE_LOCK_COOLANT = "lockCoolant";
    public static final String FEATURE_INTAKE_TEMP_INPUTX = "intakeTempInputX";
    public static final String FEATURE_MAP_INPUTX = "mapInputX";
    public static final String FEATURE_WB_INPUTX = "wbInputX";
    public static final int INPUT_X_UNDEFINED = 0;
    public static final int INPUT_X_INTAKE_TEMP = 1;
    public static final int INPUT_X_BARO = 2;
    public static final int INPUT_X_FRONTO2 = 3;
    public static final int INPUT_X_COOLANT = 4;
    public static final int INPUT_X_REARO2 = 5;
    public static final int INPUT_X_MDP = 6;
    public static final int INPUT_X_EGR_TEMP = 7;
    public static final int INPUT_X_MUX0 = 8;
    public static final int INPUT_X_MUX1 = 9;
    public static final int INPUT_X_MUX2 = 10;
    public static final int INPUT_X_MUX3 = 11;
    public static final int INPUT_X_MAX_VALUE = 11;
    public static final String[] INPUT_X_TO_LOCNAME = new String[]{null, "RawIntakeTempInput", "RawBaroPressInput", "RawFrO2VoltsInput", "RawCoolantTempInput", "RawRrO2VoltsInput", "RawMDPSensorInput", "RawEGRTempInput", null, null, null, null};

    public MiscBitsV3Record(int n) {
        super(n, 21);
        this.addV3MB12Fields();
        this.addV3InputLockFields();
        this.addV3Features();
    }

    protected void addV3MB12Fields() {
        this.addField("MiscBits1", new BitMaskField(247));
        this.addField(MISCBITS2_FIELD_NAME, new BitMaskField(255));
    }

    protected void addV3InputLockFields() {
        this.addField(LOCK_IATVAL_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_BARO_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_FRONTO2_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_COOLANT_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_EGRT_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_MDP_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_REARO2_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(INTAKE_TEMP_INPUTX_FIELD_NAME, new SignedInt8Field(0.0f, 11.0f));
        this.addField(MAP_INPUTX_FIELD_NAME, new SignedInt8Field(0.0f, 11.0f));
        this.addField(WB_INPUTX_FIELD_NAME, new SignedInt8Field(0.0f, 11.0f));
    }

    protected void addV3Features() {
        this.addFeature(FEATURE_INTAKE_TEMP_INPUTX, this.integerAccesor(INTAKE_TEMP_INPUTX_FIELD_NAME));
        this.addFeature(FEATURE_MAP_INPUTX, this.integerAccesor(MAP_INPUTX_FIELD_NAME));
        this.addFeature(FEATURE_WB_INPUTX, this.integerAccesor(WB_INPUTX_FIELD_NAME));
        this.addFeature("shiftRPMCtl", this.booleanAccessor("MiscBits1", 64));
        this.addFeature("timingCheckCtl", this.booleanAccessor("MiscBits1", 32));
        this.addFeature("diagPinCtl", this.booleanAccessor("MiscBits1", 16));
        this.addFeature("forceOpenloop", this.booleanAccessor(MISCBITS2_FIELD_NAME, 128));
        this.addFeature("invertClutch", this.booleanAccessor(MISCBITS2_FIELD_NAME, 64));
        this.addFeature(FEATURE_LOCK_IAT_BARO, this.booleanAccessor(MISCBITS2_FIELD_NAME, 32));
        this.addFeature(FEATURE_LOCK_FRONTO2, this.booleanAccessor(MISCBITS2_FIELD_NAME, 4));
        this.addFeature(FEATURE_LOCK_COOLANT, this.booleanAccessor(MISCBITS2_FIELD_NAME, 1));
        this.addFeature(FEATURE_LOCK_COMM, this.booleanAccessor("MiscBits1", 4));
        this.addFeature(FEATURE_LOCK_MDP, this.booleanAccessor(MISCBITS2_FIELD_NAME, 16));
        this.addFeature(FEATURE_LOCK_REARO2, this.booleanAccessor(MISCBITS2_FIELD_NAME, 8));
        this.addFeature("casInvert", this.booleanAccessor("MiscBits1", 128));
        this.addFeature("fanCtl", this.booleanAccessor("MiscBits1", 3));
    }

    protected MiscBitsV3Record(int n, int n2) {
        super(n, n2);
    }

    @Override
    public String getDescription() {
        return "Miscellaneous bits (V3)";
    }
}

