/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV3Record;
import com.ecmtuning.ecmlink.device.records.BitMaskField;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.device.records.SignedInt8Field;

public class MiscBitsV4Record
extends MiscBitsV3Record {
    public static final String FEATURE_LOCK_EGRT = "lockEGRT";

    public MiscBitsV4Record(int n) {
        super(n, 22);
        this.addV4MB12Fields();
        this.addV4InputLockFields();
        this.addV4Features();
    }

    protected void addV4MB12Fields() {
        this.addField("MiscBits1", new BitMaskField(116));
        this.addField("MiscBits2", new BitMaskField(255));
    }

    protected void addV4InputLockFields() {
        this.addField("LockIATVal", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("LockBaroVal", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("LockFrontO2Val", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("LockCoolantVal", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("LockEGRTVal", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("LockMDPVal", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("LockRearO2Val", new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField("IntakeTempInputX", new SignedInt8Field(0.0f, 11.0f));
        this.addField("MAPInputX", new SignedInt8Field(0.0f, 11.0f));
        this.addField("WBInputX", new SignedInt8Field(0.0f, 11.0f));
    }

    protected void addV4Features() {
        this.addFeature("intakeTempInputX", this.integerAccesor("IntakeTempInputX"));
        this.addFeature("mapInputX", this.integerAccesor("MAPInputX"));
        this.addFeature("wbInputX", this.integerAccesor("WBInputX"));
        this.addFeature("shiftRPMCtl", this.booleanAccessor("MiscBits1", 64));
        this.addFeature("timingCheckCtl", this.booleanAccessor("MiscBits1", 32));
        this.addFeature("diagPinCtl", this.booleanAccessor("MiscBits1", 16));
        this.addFeature("forceOpenloop", this.booleanAccessor("MiscBits2", 128));
        this.addFeature("invertClutch", this.booleanAccessor("MiscBits2", 64));
        this.addFeature("lockIATBaro", this.booleanAccessor("MiscBits2", 32));
        this.addFeature("lockFrontO2", this.booleanAccessor("MiscBits2", 4));
        this.addFeature("lockCoolant", this.booleanAccessor("MiscBits2", 1));
        this.addFeature("lockComm", this.booleanAccessor("MiscBits1", 4));
        this.addFeature(FEATURE_LOCK_EGRT, this.booleanAccessor("MiscBits2", 2));
    }

    protected MiscBitsV4Record(int n, int n2) {
        super(n, n2);
    }

    @Override
    public String getDescription() {
        return "Miscellaneous bits (V4)";
    }
}

