/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV4Record;
import com.ecmtuning.ecmlink.device.records.BitMaskField;

public class MiscBitsV6Record
extends MiscBitsV4Record {
    public static final String MISCBITS3_FIELD_NAME = "MiscBits3";
    public static final String MISCBITS3_MASK_FIELD_NAME = "MiscBits3Mask";
    public static final int MB3_NO_SD_MAFCOMP = 16;
    public static final int MB3_NO_SD_SMOOTHING = 8;
    public static final int MB3_HOT_START_FUEL = 1;
    public static final String FEATURE_NO_SD_MAFCOMP = "noSDMAFComp";
    public static final String FEATURE_NO_SD_SMOOTHING = "noSDSmoothing";
    public static final String FEATURE_HOT_START_FUEL = "hotStartFuel";

    @Override
    public boolean hasFeature(String string) {
        int n = this.getIntField(MISCBITS3_MASK_FIELD_NAME);
        if (string == FEATURE_NO_SD_MAFCOMP) {
            return (n & 0x10) != 0;
        }
        if (string == FEATURE_NO_SD_SMOOTHING) {
            return (n & 8) != 0;
        }
        if (string == FEATURE_HOT_START_FUEL) {
            return (n & 1) != 0;
        }
        return super.hasFeature(string);
    }

    public MiscBitsV6Record(int n) {
        super(n, 33);
        this.addV4MB12Fields();
        this.addV6MB3Fields();
        this.addV4InputLockFields();
        this.addV4Features();
        this.addV6Features();
    }

    protected void addV6MB3Fields() {
        this.addField(MISCBITS3_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS3_MASK_FIELD_NAME, new BitMaskField(255));
    }

    protected void addV6Features() {
        this.addFeature(FEATURE_NO_SD_MAFCOMP, this.booleanAccessor(MISCBITS3_FIELD_NAME, 16));
        this.addFeature(FEATURE_NO_SD_SMOOTHING, this.booleanAccessor(MISCBITS3_FIELD_NAME, 8));
        this.addFeature(FEATURE_HOT_START_FUEL, this.booleanAccessor(MISCBITS3_FIELD_NAME, 1));
    }

    protected MiscBitsV6Record(int n, int n2) {
        super(n, n2);
    }

    @Override
    public String getDescription() {
        return "Miscellaneous bits (V6)";
    }
}

