/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV5Record;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.device.records.SignedInt8Field;

public class MiscBitsV7Record
extends MiscBitsV5Record {
    public static final String MAPSELECT_FIELD_NAME = "MAPSelect";
    public static final String MAPSCALE_FIELD_NAME = "MAPScale";
    public static final String MAPOFFSET_FIELD_NAME = "MAPOffset";
    public static final int MAPSELECT_NONE = 0;
    public static final int MAPSELECT_GM3BAR = 1;
    public static final int MAPSELECT_GM33BAR = 2;
    public static final int MAPSELECT_AEM35BAR = 3;
    public static final int MAPSELECT_AEM5BAR = 4;
    public static final int MAPSELECT_OMNIPOWER3BAR = 5;
    public static final int MAPSELECT_OMNIPOWER4BAR = 6;
    public static final int MAPSELECT_USERDEFINED = 127;
    public static final String DISPLAY_NAME_GM3BAR = "GM 3 bar";
    public static final String DISPLAY_NAME_GM33BAR = "GM 3.3 bar";
    public static final String DISPLAY_NAME_AEM35BAR = "AEM 3.5 bar";
    public static final String DISPLAY_NAME_AEM50BAR = "AEM 5 bar";
    public static final String DISPLAY_NAME_OMNIPOWER3BAR = "Omni Power 3 bar";
    public static final String DISPLAY_NAME_OMNIPOWER4BAR = "Omni Power 4 bar";
    public static final String DISPLAY_NAME_USERDEFINED = "User defined";
    public static final int MAPSELECT_MAXVALUE = 127;
    public static final String FEATURE_MAPSELECT = "mapSelectFeature";

    public static Float getMAPScaleValue(int n) {
        if (n == 1) {
            return new Float(100.0f);
        }
        if (n == 2) {
            return new Float(106.0f);
        }
        if (n == 3) {
            return new Float(137.0f);
        }
        if (n == 4) {
            return new Float(205.0f);
        }
        if (n == 5) {
            return new Float(100.0f);
        }
        if (n == 6) {
            return new Float(131.0f);
        }
        return new Float(0.0f);
    }

    public static Float getMAPOffsetValue(int n) {
        if (n == 1) {
            return new Float(-1.0f);
        }
        if (n == 2) {
            return new Float(-26.0f);
        }
        if (n == 3) {
            return new Float(26.0f);
        }
        if (n == 4) {
            return new Float(26.0f);
        }
        if (n == 5) {
            return new Float(-1.0f);
        }
        if (n == 6) {
            return new Float(-2.0f);
        }
        return new Float(0.0f);
    }

    public MiscBitsV7Record(int n) {
        super(n, 40);
        this.addV3MB12Fields();
        this.addV5MB3Fields();
        this.addV3InputLockFields();
        this.addV7MAPFields();
        this.addV3Features();
        this.addV5Features();
        this.addV7Features();
        this.addFeature("hotStartFuel", this.booleanAccessor("MiscBits3", 1));
    }

    protected void addV7MAPFields() {
        this.addField(MAPSELECT_FIELD_NAME, new SignedInt8Field(0.0f, 127.0f));
        this.addField(MAPSCALE_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(MAPOFFSET_FIELD_NAME, new SignedInt8Field());
    }

    protected void addV7Features() {
        this.addFeature(FEATURE_MAPSELECT, this.integerAccesor(MAPSELECT_FIELD_NAME));
    }

    protected MiscBitsV7Record(int n, int n2) {
        super(n, n2);
    }

    @Override
    public String getDescription() {
        return "Miscellaneous bits (V7)";
    }
}

