/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV7Record;
import com.ecmtuning.ecmlink.device.records.BitMaskField;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.device.records.SignedInt8Field;

public class MiscBitsV9Record
extends ConfigRecord {
    public static final String MISCBITS1_FIELD_NAME = "MiscBits1";
    public static final String MISCBITS1_MASK_FIELD_NAME = "MiscBits1Mask";
    public static final String MISCBITS2_FIELD_NAME = "MiscBits2";
    public static final String MISCBITS2_MASK_FIELD_NAME = "MiscBits2Mask";
    public static final String MISCBITS3_FIELD_NAME = "MiscBits3";
    public static final String MISCBITS3_MASK_FIELD_NAME = "MiscBits3Mask";
    public static final String MISCBITS4_FIELD_NAME = "MiscBits4";
    public static final String MISCBITS4_MASK_FIELD_NAME = "MiscBits4Mask";
    public static final int MB1_CAS_INVERSION_ON = 128;
    public static final int MB1_SHIFT_RPM_CTL = 64;
    public static final int MB1_TIMING_CHECK_CTL = 32;
    public static final int MB1_DIAG_PIN_CTL = 16;
    public static final int MB1_LOCK_COMM = 4;
    public static final int MB1_FAN_CONTROL_FANS_ON = 3;
    public static final int MB2_FORCE_OPENLOOP = 128;
    public static final int MB2_INVERT_CLUTCH = 64;
    public static final int MB2_LOCK_IAT_BARO = 32;
    public static final int MB2_LOCK_MDP = 16;
    public static final int MB2_LOCK_REARO2 = 8;
    public static final int MB2_LOCK_FRONTO2 = 4;
    public static final int MB2_LOCK_EGRT = 2;
    public static final int MB2_LOCK_COOLANT = 1;
    public static final int MB3_FUELPUMP_PRIME = 64;
    public static final int MB3_LOAD_LIMIT = 32;
    public static final int MB3_NO_SD_MAFCOMP = 16;
    public static final int MB3_NO_SD_SMOOTHING = 8;
    public static final int MB3_WB_SELECT_ENABLE = 4;
    public static final int MB3_MAP_SELECT_ENABLE = 2;
    public static final int MB3_HOT_START_FUEL = 1;
    public static final String LOCK_IATVAL_FIELD_NAME = "LockIATVal";
    public static final String LOCK_BARO_FIELD_NAME = "LockBaroVal";
    public static final String LOCK_FRONTO2_FIELD_NAME = "LockFrontO2Val";
    public static final String LOCK_COOLANT_FIELD_NAME = "LockCoolantVal";
    public static final String LOCK_EGRT_FIELD_NAME = "LockEGRTVal";
    public static final String LOCK_MDP_FIELD_NAME = "LockMDPVal";
    public static final String LOCK_REARO2_FIELD_NAME = "LockRearO2Val";
    public static final String INTAKE_TEMP_INPUTX_FIELD_NAME = "IntakeTempInputX";
    public static final String MAP_INPUTX_FIELD_NAME = "MAPInputX";
    public static final String WB_INPUTX_FIELD_NAME = "WBInputX";
    public static final int INPUT_X_UNDEFINED = 0;
    public static final int INPUT_X_INTAKE_TEMP = 1;
    public static final int INPUT_X_BARO = 2;
    public static final int INPUT_X_FRONTO2 = 3;
    public static final int INPUT_X_COOLANT = 4;
    public static final int INPUT_X_REARO2 = 5;
    public static final int INPUT_X_MDP = 6;
    public static final int INPUT_X_EGR_TEMP = 7;
    public static final int INPUT_X_MUX0 = 8;
    public static final int INPUT_X_MUX1 = 9;
    public static final int INPUT_X_MUX2 = 10;
    public static final int INPUT_X_MUX3 = 11;
    public static final int INPUT_X_MAX_VALUE = 11;
    public static final String RESERVED4_FIELD_NAME = "reserved4";
    public static final String RESERVED5_FIELD_NAME = "reserved5";
    public static final String RESERVED6_FIELD_NAME = "reserved6";
    public static final String RESERVED7_FIELD_NAME = "reserved7";
    public static final String RESERVED8_FIELD_NAME = "reserved8";
    public static final String MAPSELECT_FIELD_NAME = "MAPSelect";
    public static final String MAPSCALE_FIELD_NAME = "MAPScale";
    public static final String MAPOFFSET_FIELD_NAME = "MAPOffset";
    public static final int MAPSELECT_NONE = 0;
    public static final String LOAD_LIMIT_FIELD_NAME = "LoadLimit";
    public static final String MAPADJ_LIMIT_FIELD_NAME = "MAPAdjLimit";
    public static final String FUELPUMP_PRIMESECS_FIELD_NAME = "FPTmr400KeyOn";
    public static final String FEATURE_SHIFT_RPM_CTL = "shiftRPMCtl";
    public static final String FEATURE_TIMING_CHECK_CTL = "timingCheckCtl";
    public static final String FEATURE_DIAG_PIN_CTL = "diagPinCtl";
    public static final String FEATURE_FREEZE_CTL = "freezeCtl";
    public static final String FEATURE_CAS_INVERT = "casInvert";
    public static final String FEATURE_FAN_CTL = "fanCtl";
    public static final String FEATURE_LOCK_COMM = "lockComm";
    public static final String FEATURE_FORCE_OPENLOOP = "forceOpenloop";
    public static final String FEATURE_INVERT_CLUTCH = "invertClutch";
    public static final String FEATURE_LOCK_IAT_BARO = "lockIATBaro";
    public static final String FEATURE_LOCK_MDP = "lockMDP";
    public static final String FEATURE_LOCK_REARO2 = "lockRearO2";
    public static final String FEATURE_LOCK_FRONTO2 = "lockFrontO2";
    public static final String FEATURE_LOCK_COOLANT = "lockCoolant";
    public static final String FEATURE_LOCK_EGRT = "lockEGRT";
    public static final String FEATURE_NO_SD_MAFCOMP = "noSDMAFComp";
    public static final String FEATURE_NO_SD_SMOOTHING = "noSDSmoothing";
    public static final String FEATURE_HOT_START_FUEL = "hotStartFuel";
    public static final String FEATURE_MAP_INPUTX = "mapInputX";
    public static final String FEATURE_WB_INPUTX = "wbInputX";
    public static final String FEATURE_MAPSELECT = "mapSelectFeature";

    @Override
    public boolean localCacheOK() {
        return false;
    }

    public static Float getMAPScaleValue(int n) {
        return MiscBitsV7Record.getMAPScaleValue(n);
    }

    public static Float getMAPOffsetValue(int n) {
        return MiscBitsV7Record.getMAPOffsetValue(n);
    }

    @Override
    public boolean hasFeature(String string) {
        if (!super.hasFeature(string)) {
            return false;
        }
        int n = this.getIntField(MISCBITS1_MASK_FIELD_NAME);
        int n2 = this.getIntField(MISCBITS2_MASK_FIELD_NAME);
        int n3 = this.getIntField(MISCBITS3_MASK_FIELD_NAME);
        if (string == FEATURE_SHIFT_RPM_CTL) {
            return (n & 0x40) != 0;
        }
        if (string == FEATURE_TIMING_CHECK_CTL) {
            return (n & 0x20) != 0;
        }
        if (string == FEATURE_DIAG_PIN_CTL) {
            return (n & 0x10) != 0;
        }
        if (string == FEATURE_CAS_INVERT) {
            return (n & 0x80) != 0;
        }
        if (string == FEATURE_FAN_CTL) {
            return (n & 3) != 0;
        }
        if (string == FEATURE_LOCK_COMM) {
            return (n & 4) != 0;
        }
        if (string == FEATURE_FORCE_OPENLOOP) {
            return (n2 & 0x80) != 0;
        }
        if (string == FEATURE_INVERT_CLUTCH) {
            return (n2 & 0x40) != 0;
        }
        if (string == FEATURE_LOCK_EGRT) {
            return (n2 & 2) != 0;
        }
        if (string == FEATURE_LOCK_IAT_BARO) {
            return (n2 & 0x20) != 0;
        }
        if (string == FEATURE_LOCK_FRONTO2) {
            return (n2 & 4) != 0;
        }
        if (string == FEATURE_LOCK_COOLANT) {
            return (n2 & 1) != 0;
        }
        if (string == FEATURE_LOCK_MDP) {
            return (n2 & 0x10) != 0;
        }
        if (string == FEATURE_LOCK_REARO2) {
            return (n2 & 8) != 0;
        }
        if (string == FEATURE_NO_SD_MAFCOMP) {
            return (n3 & 0x10) != 0;
        }
        if (string == FEATURE_NO_SD_SMOOTHING) {
            return (n3 & 8) != 0;
        }
        if (string == FEATURE_HOT_START_FUEL) {
            return (n3 & 1) != 0;
        }
        if (string == FEATURE_MAP_INPUTX) {
            return (n3 & 2) != 0;
        }
        if (string == FEATURE_WB_INPUTX) {
            return (n3 & 4) != 0;
        }
        if (string == FEATURE_MAPSELECT) {
            return (n3 & 2) != 0;
        }
        return true;
    }

    public MiscBitsV9Record(int n) {
        super(n, 44);
        this.addField(MISCBITS1_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS1_MASK_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS2_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS2_MASK_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS3_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS3_MASK_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS4_FIELD_NAME, new BitMaskField(255));
        this.addField(MISCBITS4_MASK_FIELD_NAME, new BitMaskField(255));
        this.addField(LOCK_IATVAL_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_BARO_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_FRONTO2_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_COOLANT_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_EGRT_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_MDP_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(LOCK_REARO2_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(INTAKE_TEMP_INPUTX_FIELD_NAME, new SignedInt8Field(0.0f, 11.0f));
        this.addField(MAP_INPUTX_FIELD_NAME, new SignedInt8Field(0.0f, 11.0f));
        this.addField(WB_INPUTX_FIELD_NAME, new SignedInt8Field(0.0f, 11.0f));
        this.addField(MAPSELECT_FIELD_NAME, new SignedInt8Field(0.0f, 127.0f));
        this.addField(MAPSCALE_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(MAPOFFSET_FIELD_NAME, new SignedInt8Field());
        this.addField(LOAD_LIMIT_FIELD_NAME, new Float8Field(0.05f, 0.0f, 12.75f, 0.0f));
        this.addField(MAPADJ_LIMIT_FIELD_NAME, new Float8Field(0.459375f, 0.0f, 117.1f, 0.0f));
        this.addField(FUELPUMP_PRIMESECS_FIELD_NAME, new Float8Field(0.5f, 0.0f, 30.0f, 0.0f));
        this.addField(RESERVED4_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(RESERVED5_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(RESERVED6_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(RESERVED7_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addField(RESERVED8_FIELD_NAME, new Float8Field(1.0f, 0.0f, 255.0f, 0.0f));
        this.addFeature(FEATURE_SHIFT_RPM_CTL, this.booleanAccessor(MISCBITS1_FIELD_NAME, 64));
        this.addFeature(FEATURE_TIMING_CHECK_CTL, this.booleanAccessor(MISCBITS1_FIELD_NAME, 32));
        this.addFeature(FEATURE_DIAG_PIN_CTL, this.booleanAccessor(MISCBITS1_FIELD_NAME, 16));
        this.addFeature(FEATURE_CAS_INVERT, this.booleanAccessor(MISCBITS1_FIELD_NAME, 128));
        this.addFeature(FEATURE_FAN_CTL, this.booleanAccessor(MISCBITS1_FIELD_NAME, 3));
        this.addFeature(FEATURE_LOCK_COMM, this.booleanAccessor(MISCBITS1_FIELD_NAME, 4));
        this.addFeature(FEATURE_FORCE_OPENLOOP, this.booleanAccessor(MISCBITS2_FIELD_NAME, 128));
        this.addFeature(FEATURE_INVERT_CLUTCH, this.booleanAccessor(MISCBITS2_FIELD_NAME, 64));
        this.addFeature(FEATURE_LOCK_EGRT, this.booleanAccessor(MISCBITS2_FIELD_NAME, 2));
        this.addFeature(FEATURE_LOCK_IAT_BARO, this.booleanAccessor(MISCBITS2_FIELD_NAME, 32));
        this.addFeature(FEATURE_LOCK_FRONTO2, this.booleanAccessor(MISCBITS2_FIELD_NAME, 4));
        this.addFeature(FEATURE_LOCK_COOLANT, this.booleanAccessor(MISCBITS2_FIELD_NAME, 1));
        this.addFeature(FEATURE_LOCK_MDP, this.booleanAccessor(MISCBITS2_FIELD_NAME, 16));
        this.addFeature(FEATURE_LOCK_REARO2, this.booleanAccessor(MISCBITS2_FIELD_NAME, 8));
        this.addFeature(FEATURE_NO_SD_MAFCOMP, this.booleanAccessor(MISCBITS3_FIELD_NAME, 16));
        this.addFeature(FEATURE_HOT_START_FUEL, this.booleanAccessor(MISCBITS3_FIELD_NAME, 1));
        this.addFeature(FEATURE_NO_SD_SMOOTHING, this.booleanAccessor(MISCBITS3_FIELD_NAME, 8));
        this.addFeature(FEATURE_MAP_INPUTX, this.integerAccesor(MAP_INPUTX_FIELD_NAME));
        this.addFeature(FEATURE_WB_INPUTX, this.integerAccesor(WB_INPUTX_FIELD_NAME));
        this.addFeature(FEATURE_MAPSELECT, this.integerAccesor(MAPSELECT_FIELD_NAME));
    }

    @Override
    public String getDescription() {
        return "Miscellaneous bits (V9)";
    }
}

