/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.ecmlink.records;

import com.ecmtuning.ecmlink.device.records.Float16Field;

public class RawMPRField
extends Float16Field {
    public static final int RAW_MPR_DIVISIBLE_BY = 50;

    public RawMPRField() {
        this(0.0f, 12000.0f);
    }

    public RawMPRField(float f, float f2) {
        super(1.0f, f, f2, 0.0f);
    }

    @Override
    protected int scaleToRawValue(float f) {
        if (f < 115.0f) {
            return Short.MAX_VALUE;
        }
        return Math.round(3750000.0f / f);
    }

    @Override
    protected float scaleFromRawValue(int n) {
        if (n >= Short.MAX_VALUE) {
            return 0.0f;
        }
        if (n < 312) {
            return 12000.0f;
        }
        return 3750000.0f / (float)n;
    }
}

