/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.mitsu.Mitsu97UpCommand;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommand;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceMap;
import com.ecmtuning.ecmlink.device.mitsu.MitsuPre95Command;

public class MitsuCommandMgr {
    public static final int CMDID_NULL = -1;
    public static final String FEATURE_BCS_ACTIVATION = "bcsAct";
    public static final String FEATURE_EGR_ACTIVATION = "egrAct";
    public static final String FEATURE_FPS_ACTIVATION = "fpsAct";
    public static final String FEATURE_EVAP_ACTIVATION = "evapAct";
    public static final String FEATURE_FUELPUMP_ACTIVATION = "fuelpumpAct";
    public static final String FEATURE_INJ6_DISABLE = "inj6Disable";
    public static final String FEATURE_INJ5_DISABLE = "inj5Disable";
    public static final String FEATURE_INJ4_DISABLE = "inj4Disable";
    public static final String FEATURE_INJ3_DISABLE = "inj3Disable";
    public static final String FEATURE_INJ2_DISABLE = "inj2Disable";
    public static final String FEATURE_INJ1_DISABLE = "inj1Disable";
    private static final int CMDID_MUTII_ID_REQUEST = 253;
    private static final int CMDID_MUTII_CONFIGBYTE1_REQUEST = 254;
    private static final int CMDID_MUTII_CONFIGBYTE2_REQUEST = 255;

    public static MitsuCommand createCommandForFeature(int n, String string) {
        int n2 = -1;
        if (MitsuDeviceMap.is97UpDeviceId(n)) {
            n2 = Mitsu97UpCommand.getFeatureCmdId(string);
        } else if (MitsuDeviceMap.isPre95DeviceId(n)) {
            n2 = MitsuPre95Command.getFeatureCmdId(string);
        }
        if (n2 != -1) {
            return MitsuCommandMgr.createBasicCommand(n, n2);
        }
        return null;
    }

    public static MitsuCommand createReadCommand(int n, int n2) {
        if (MitsuDeviceMap.is97UpDeviceId(n)) {
            if (n2 < 0 || n2 > 127) {
                n2 = 0;
            }
        } else if (n2 < 0 || n2 > 61) {
            n2 = 0;
        }
        return MitsuCommandMgr.createBasicCommand(n, n2);
    }

    public static MitsuCommand createDTCClearCommand(int n) {
        int n2 = 202;
        if (MitsuDeviceMap.is97UpDeviceId(n)) {
            n2 = 252;
        }
        return MitsuCommandMgr.createBasicCommand(n, n2);
    }

    public static MitsuCommand createDefinitionIdReadCommand(int n) {
        return MitsuCommandMgr.createBasicCommand(n, 253);
    }

    public static MitsuCommand createConfig1ReadCommand(int n) {
        return MitsuCommandMgr.createBasicCommand(n, 254);
    }

    public static MitsuCommand createConfig2ReadCommand(int n) {
        return MitsuCommandMgr.createBasicCommand(n, 255);
    }

    private static MitsuCommand createBasicCommand(int n, int n2) {
        if (MitsuDeviceMap.is97UpDeviceId(n)) {
            return new Mitsu97UpCommand(n2);
        }
        if (MitsuDeviceMap.isPre95DeviceId(n)) {
            return new MitsuPre95Command(n2);
        }
        return null;
    }
}

