/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.exception.DeviceInternalException;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommand;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommandMgr;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDTC;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceMap;
import com.ecmtuning.ecmlink.device.records.BitMaskField;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.device.records.Float16ListField;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.jgoodies.binding.list.ArrayListModel;
import foxtrot.Task;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MitsuControlRecord
extends ConfigRecord {
    public static final int MAX_DTC_COUNT = 16;
    public static final String DTC_TABLE_FIELD_NAME = "DtcTable";
    public static final String SCANTOOL_CTL_FIELD_NAME = "ScanToolCtlMod";
    public static final int SCANTOOL_EVAP_MASK = 1;
    public static final int SCANTOOL_FUEL_PUMP_MASK = 2;
    public static final int SCANTOOL_FPS_MASK = 4;
    public static final int SCANTOOL_EGR_MASK = 8;
    public static final int SCANTOOL_BCS_MASK = 16;
    public static final int INJ_CYL_1_MASK = 32;
    public static final int INJ_CYL_2_MASK = 64;
    public static final int INJ_CYL_3_MASK = 128;
    public static final int INJ_CYL_4_MASK = 256;
    public static final String FEATURE_EVAP_ON = "evapOn";
    public static final String FEATURE_FUEL_PUMP_ON = "fuelPumpOn";
    public static final String FEATURE_FPS_ON = "fpsOn";
    public static final String FEATURE_EGR_ON = "egrOn";
    public static final String FEATURE_BCS_ON = "bcsOn";
    public static final String FEATURE_INJ1_OFF = "inj1Off";
    public static final String FEATURE_INJ2_OFF = "inj2Off";
    public static final String FEATURE_INJ3_OFF = "inj3Off";
    public static final String FEATURE_INJ4_OFF = "inj4Off";
    private final int definitionId;
    private final MitsuDeviceManager deviceManager;
    ArrayListModel listMdlDTCs = new ArrayListModel();
    ArrayListModel listMdlDTCDescs = new ArrayListModel();
    static final Logger logger = Logger.getLogger(MitsuControlRecord.class.getName());
    private static final boolean loggingFinest = logger.isLoggable(Level.FINEST);
    private static final boolean loggingFiner = logger.isLoggable(Level.FINER);
    private static final boolean loggingFine = logger.isLoggable(Level.FINE);
    PropertyChangeListener scantoolListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            final int n = MitsuControlRecord.this.getScantoolMask();
            if (n != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainActions.handleMainFrameTask(new Task(){

                            public Object run() throws Exception {
                                MitsuControlRecord.this.setScanToolMask(n);
                                return null;
                            }
                        }, true);
                    }
                });
            }
        }
    };
    private BitMaskField scantoolField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScanToolMask(int n) throws DeviceException, IOException {
        String string;
        if (loggingFine) {
            logger.fine("Requested to send mask 0x" + XFormatter.toHex4(n));
        }
        if (n == 1) {
            string = "evapAct";
        } else if (n == 2) {
            string = "fuelpumpAct";
        } else if (n == 4) {
            string = "fpsAct";
        } else if (n == 8) {
            string = "egrAct";
        } else if (n == 16) {
            string = "bcsAct";
        } else if (n == 32) {
            string = "inj1Disable";
        } else if (n == 64) {
            string = "inj2Disable";
        } else if (n == 128) {
            string = "inj3Disable";
        } else if (n == 256) {
            string = "inj4Disable";
        } else {
            throw new DeviceInternalException("Invalid mask requested (0x" + XFormatter.toHex4(n) + ")");
        }
        if (loggingFine) {
            logger.fine("Translated to feature '" + string + "'");
        }
        try {
            int n2 = this.deviceManager.getConnectedDeviceId();
            MitsuCommand mitsuCommand = MitsuCommandMgr.createCommandForFeature(n2, string);
            if (mitsuCommand == null) {
                this.deviceManager.sendNewStatusText("FAILED: Unable to map feature to action");
                return;
            }
            mitsuCommand.setTryCount(1);
            if (MitsuDeviceMap.isPre95DeviceId(n2)) {
                mitsuCommand.setTimeoutMillis(2500L);
                mitsuCommand.setNoResponseOk(true);
            }
            logger.fine("Sending activation command");
            this.deviceManager.sendNewStatusText("Sending action request, cmdId = 0x" + XFormatter.toHex2(mitsuCommand.getCmdId()));
            MitsuCommand mitsuCommand2 = this.deviceManager.sendCommand(mitsuCommand);
            if (!mitsuCommand2.hasResponseData()) {
                logger.fine("Got no response; good!");
                this.deviceManager.sendNewStatusText("Got no response; assuming good");
            } else {
                int n3 = mitsuCommand2.getResponseData();
                logger.fine("Got response to activation command: 0x" + XFormatter.toHex2(n3));
                if (n3 == 0) {
                    this.deviceManager.sendNewStatusText("Action request returned good response.  Waiting for deactivation to take place.");
                    try {
                        Thread.sleep(6000L);
                    }
                    catch (Exception exception) {}
                } else {
                    this.deviceManager.sendNewStatusText("Action request failed, resp code = 0x" + XFormatter.toHex2(n3));
                }
            }
        }
        finally {
            this._setScanToolField(0);
        }
    }

    private void _setScanToolField(final int n) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MitsuControlRecord.this.getField(MitsuControlRecord.SCANTOOL_CTL_FIELD_NAME).setValue(n);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private int getScantoolMask() {
        return ((Number)this.scantoolField.getValue()).intValue();
    }

    public MitsuControlRecord(MitsuDeviceManager mitsuDeviceManager, int n) {
        super(0x7F000000, 1);
        this.deviceManager = mitsuDeviceManager;
        this.definitionId = n;
        this.scantoolField = new BitMaskField(511);
        this.addField(SCANTOOL_CTL_FIELD_NAME, this.scantoolField);
        this.scantoolField.addValueChangeListener(this.scantoolListener);
        this.addField(DTC_TABLE_FIELD_NAME, new Float16ListField(16));
        this.addFeature(FEATURE_EVAP_ON, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 1));
        this.addFeature(FEATURE_FUEL_PUMP_ON, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 2));
        this.addFeature(FEATURE_FPS_ON, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 4));
        this.addFeature(FEATURE_EGR_ON, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 8));
        this.addFeature(FEATURE_BCS_ON, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 16));
        this.addFeature(FEATURE_INJ1_OFF, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 32, true));
        this.addFeature(FEATURE_INJ2_OFF, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 64, true));
        this.addFeature(FEATURE_INJ3_OFF, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 128, true));
        this.addFeature(FEATURE_INJ4_OFF, this.booleanAccessor(SCANTOOL_CTL_FIELD_NAME, 256, true));
    }

    public int getDefinitionId() {
        return this.definitionId;
    }

    @Override
    public String getDescription() {
        return "Mitsu Control Record";
    }

    public void updateLists() throws IOException, DeviceException {
        Integer n;
        List list = MitsuDTC.getDTCList(this.deviceManager);
        this.listMdlDTCs.clear();
        this.listMdlDTCDescs.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (n = (Integer)iterator.next()) != 0) {
            this.listMdlDTCs.add((Object)XFormatter.toHex4(n));
            this.listMdlDTCDescs.add((Object)MitsuDTC.getDTCDesc(this.deviceId, this.definitionId, n));
        }
    }

    public void clearDTCs() throws IOException, DeviceException {
        MitsuDTC.clearDTCs(this.deviceManager);
        this.updateLists();
    }

    public void setDTCS(List list) {
        Float16ListField float16ListField = (Float16ListField)this.getField(DTC_TABLE_FIELD_NAME);
        for (int i = 0; i < 16; ++i) {
            if (i >= list.size()) {
                float16ListField.put(i, new Float(0.0f));
                continue;
            }
            float16ListField.put(i, new Float(((Number)list.get(i)).floatValue()));
        }
    }

    public List getDTCs() {
        Float16ListField float16ListField = (Float16ListField)this.getField(DTC_TABLE_FIELD_NAME);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            arrayList.add(new Integer(float16ListField.get(i).intValue()));
        }
        return arrayList;
    }

    public ArrayListModel getListMdlDTCs() {
        return this.listMdlDTCs;
    }

    public ArrayListModel getListMdlDTCDescs() {
        return this.listMdlDTCDescs;
    }
}

