/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.exception.DeviceIncompatibleException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommand;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommandMgr;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class MitsuDTC {
    public static final String NOT_FOUND_DESC = "DTC not found in lookup table";
    private static final Hashtable mutDescTbl = new Hashtable();
    private static final Hashtable e931MutMaskTbl = new Hashtable();
    private static final Hashtable eb23MutMaskTbl = new Hashtable();

    public static List getDTCList(MitsuDeviceManager mitsuDeviceManager) throws IOException, DeviceException {
        int[] nArray = new int[4];
        Arrays.fill(nArray, -1);
        int n = mitsuDeviceManager.getConnectedDeviceId() & 0xFF000000;
        int n2 = mitsuDeviceManager.getConnectedDefinitionID();
        if (n == 0x7F000000) {
            nArray[1] = 59;
            nArray[0] = 60;
        } else if (n == 0x7E000000) {
            nArray[2] = 59;
            nArray[1] = 60;
            nArray[0] = 61;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n4 < 4) {
            if (nArray[n4] != -1) {
                int n6 = mitsuDeviceManager.readData(nArray[n4], false);
                n3 |= n5 * n6;
            }
            ++n4;
            n5 *= 256;
        }
        return MitsuDTC.getDTCList(n, n2, n3);
    }

    public static void clearDTCs(MitsuDeviceManager mitsuDeviceManager) throws IOException, DeviceException {
        int n = mitsuDeviceManager.getConnectedDeviceId();
        MitsuCommand mitsuCommand = MitsuCommandMgr.createDTCClearCommand(n);
        if (mitsuCommand != null) {
            MitsuCommand mitsuCommand2 = mitsuDeviceManager.sendCommand(mitsuCommand);
            if (mitsuCommand2.getResponseData() == 255) {
                throw new DeviceInvalidStateException("Clear codes failed.  Perhaps engine is running?");
            }
        } else {
            throw new DeviceIncompatibleException("Undefined clear DTC command for connected device");
        }
    }

    public static String getDTCDesc(int n, int n2, Integer n3) {
        String string = NOT_FOUND_DESC;
        Hashtable hashtable = MitsuDTC.lookupDescTbl(n & 0xFF000000, n2);
        if (hashtable != null) {
            string = (String)hashtable.get(n3);
        }
        return string == null ? NOT_FOUND_DESC : string;
    }

    public static Object[] getDTCDescs(int n, int n2) {
        Hashtable hashtable = MitsuDTC.lookupDescTbl(n & 0xFF000000, n2);
        return new ArrayList(hashtable.values()).toArray();
    }

    private static Hashtable lookupDescTbl(int n, int n2) {
        Hashtable hashtable = null;
        if (n == 0x7F000000 || n == 0x7E000000) {
            hashtable = mutDescTbl;
        }
        return hashtable;
    }

    private static List getDTCList(int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable = null;
        if (n == 0x7F000000) {
            hashtable = e931MutMaskTbl;
        } else if (n == 0x7E000000) {
            hashtable = eb23MutMaskTbl;
        }
        if (hashtable != null) {
            for (Integer n4 : hashtable.keySet()) {
                int n5 = n4;
                if ((n3 & n5) != n5) continue;
                arrayList.add(hashtable.get(n4));
            }
        }
        return arrayList;
    }

    static {
        mutDescTbl.put(new Integer(17), "02 sensor circuit malfunction (front)");
        mutDescTbl.put(new Integer(18), "Volume air flow circuit malfunction");
        mutDescTbl.put(new Integer(19), "Intake air temperature circuit malfunction");
        mutDescTbl.put(new Integer(20), "Throttle position circuit malfunction");
        mutDescTbl.put(new Integer(21), "Idle air control malfunction");
        mutDescTbl.put(new Integer(33), "Engine coolant temperature circuit malfunction");
        mutDescTbl.put(new Integer(34), "Crankshaft position sensor circuit malfunction");
        mutDescTbl.put(new Integer(35), "Camshaft position sensor circuit malfunction");
        mutDescTbl.put(new Integer(36), "Vehicle speed sensor malfunction");
        mutDescTbl.put(new Integer(37), "Barometric pressure circuit malfunction");
        mutDescTbl.put(new Integer(49), "Knock sensor 1 circuit malfunction");
        mutDescTbl.put(new Integer(54), "Base ignition timing signal malfunction");
        mutDescTbl.put(new Integer(65), "Injector circuit malfunction");
        mutDescTbl.put(new Integer(66), "Fuel pump circuit malfunction");
        mutDescTbl.put(new Integer(67), "EGR circuit malfunction");
        mutDescTbl.put(new Integer(68), "Ignition circuit malfunction");
        mutDescTbl.put(new Integer(85), "Idle air control malfunction");
        mutDescTbl.put(new Integer(89), "02 sensor circuit malfunction (rear)");
        mutDescTbl.put(new Integer(97), "A/T torque reduction signal malfunction");
        mutDescTbl.put(new Integer(100), "Catalytic converter efficiency malfunction");
        mutDescTbl.put(new Integer(113), "Traction control vacuum solenoid malfunction");
        mutDescTbl.put(new Integer(114), "Traction control ventilation solenoid malfunction");
        e931MutMaskTbl.put(new Integer(256), new Integer(17));
        e931MutMaskTbl.put(new Integer(512), new Integer(18));
        e931MutMaskTbl.put(new Integer(1024), new Integer(19));
        e931MutMaskTbl.put(new Integer(2048), new Integer(20));
        e931MutMaskTbl.put(new Integer(8192), new Integer(33));
        e931MutMaskTbl.put(new Integer(16384), new Integer(34));
        e931MutMaskTbl.put(new Integer(32768), new Integer(35));
        e931MutMaskTbl.put(new Integer(1), new Integer(36));
        e931MutMaskTbl.put(new Integer(2), new Integer(37));
        e931MutMaskTbl.put(new Integer(4), new Integer(49));
        e931MutMaskTbl.put(new Integer(8), new Integer(65));
        e931MutMaskTbl.put(new Integer(16), new Integer(66));
        e931MutMaskTbl.put(new Integer(32), new Integer(67));
        e931MutMaskTbl.put(new Integer(64), new Integer(68));
        eb23MutMaskTbl.put(new Integer(65536), new Integer(17));
        eb23MutMaskTbl.put(new Integer(131072), new Integer(18));
        eb23MutMaskTbl.put(new Integer(262144), new Integer(19));
        eb23MutMaskTbl.put(new Integer(524288), new Integer(20));
        eb23MutMaskTbl.put(new Integer(0x100000), new Integer(85));
        eb23MutMaskTbl.put(new Integer(0x200000), new Integer(33));
        eb23MutMaskTbl.put(new Integer(0x400000), new Integer(34));
        eb23MutMaskTbl.put(new Integer(0x800000), new Integer(35));
        eb23MutMaskTbl.put(new Integer(256), new Integer(36));
        eb23MutMaskTbl.put(new Integer(512), new Integer(37));
        eb23MutMaskTbl.put(new Integer(1024), new Integer(49));
        eb23MutMaskTbl.put(new Integer(2048), new Integer(65));
        eb23MutMaskTbl.put(new Integer(8192), new Integer(67));
        eb23MutMaskTbl.put(new Integer(16384), new Integer(68));
        eb23MutMaskTbl.put(new Integer(32768), new Integer(54));
        eb23MutMaskTbl.put(new Integer(4), new Integer(97));
        eb23MutMaskTbl.put(new Integer(128), new Integer(89));
    }
}

