/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.data.DataAdapter;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceMap;
import java.util.List;
import java.util.Map;

public class MitsuDataAdapter
extends DataAdapter {
    private final MitsuDeviceManager deviceManager;

    public MitsuDataAdapter(MitsuDeviceManager mitsuDeviceManager) {
        this.deviceManager = mitsuDeviceManager;
    }

    @Override
    public String getConverterPackageName() {
        return this.getClass().getPackage().getName() + ".converter";
    }

    @Override
    public String getDeviceAreaName() {
        return "mitsu";
    }

    @Override
    public String getDeviceFullName() {
        return "Mitsu";
    }

    @Override
    public int getLocationDeviceId(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        n2 = MitsuDeviceMap.convertToLocationDefinitionId(n, n2);
        return n & 0xFF000000 | n2 << 16;
    }

    @Override
    public boolean supportsDeviceId(int n) {
        return this.deviceManager.supportsDeviceId(n);
    }

    @Override
    public String adjustFileSpec(String string) {
        int n = string.indexOf("mitsu.");
        if (n != -1 && string.length() == n + 10) {
            String string2 = string.substring(n + 6, n + 10).toUpperCase();
            try {
                int n2 = Integer.parseInt(string2, 16);
                return string.substring(0, n + 6) + Integer.toString(n2 * 65536);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    protected void installAliasCandidates(Map map) {
    }

    @Override
    protected void newAliasAssignments(int n, int n2, List list) {
    }
}

