/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MitsuDeviceConfigData
extends DeviceConfigData {
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 338117247233637215L;
    final int serialNum;
    final int definitionId;
    final int configId;

    public MitsuDeviceConfigData(int n, int n2, int n3, int n4) {
        super(n);
        this.serialNum = n2;
        this.definitionId = n3;
        this.configId = n4;
    }

    @Override
    public int getDeviceSerialNumber() {
        return this.serialNum;
    }

    static MitsuDeviceConfigData read(int n, DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "MitsuConfig", 338117247233637215L, 1);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        return new MitsuDeviceConfigData(n, n2, n3, n4);
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        FileUtils.writeMarkerAndVersion(dataOutputStream, 338117247233637215L, 1);
        dataOutputStream.writeInt(this.serialNum);
        dataOutputStream.writeInt(this.definitionId);
        dataOutputStream.writeInt(this.configId);
    }
}

