/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.AbstractDeviceDatastream;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceConfigData;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import java.io.DataInputStream;
import java.io.IOException;

public final class MitsuDeviceDatastream
extends AbstractDeviceDatastream {
    private final MitsuDeviceManager manager;

    MitsuDeviceDatastream(MitsuDeviceManager mitsuDeviceManager) {
        this.manager = mitsuDeviceManager;
    }

    @Override
    public boolean isConnected() {
        return this.manager.isConnected();
    }

    @Override
    public DeviceConfigData getStaticConfigData() throws DeviceException, IOException {
        int n = this.manager.getConnectedDeviceId();
        int n2 = this.manager.getConnectedSerialNum();
        int n3 = this.manager.getConnectedDefinitionID();
        int n4 = this.manager.getConnectedConfigID();
        return new MitsuDeviceConfigData(n, n2, n3, n4);
    }

    @Override
    public LocationTOC getLiveTOC(boolean bl) throws DeviceException, IOException {
        return this.manager.getConnectedLocationTOC();
    }

    @Override
    public void setLiveTOC(LocationTOC locationTOC) throws DeviceException, IOException {
        this.manager.setConnectedLocationTOC(locationTOC);
    }

    @Override
    public DeviceConfigData readConfigData(int n, DataInputStream dataInputStream) throws IOException {
        return MitsuDeviceConfigData.read(n, dataInputStream);
    }

    @Override
    public void setStreaming(boolean bl) throws DeviceException, IOException {
        this.manager.setStreaming(bl);
    }
}

