/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.DeviceCommand;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DevicePort;
import com.ecmtuning.ecmlink.device.DevicePortFailedException;
import com.ecmtuning.ecmlink.device.data.AliasAssignment;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.DeviceDatastreamInterface;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.exception.DeviceInterruptedException;
import com.ecmtuning.ecmlink.device.exception.DeviceTimeoutException;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommand;
import com.ecmtuning.ecmlink.device.mitsu.MitsuCommandMgr;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDataAdapter;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceDatastream;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceMap;
import com.ecmtuning.ecmlink.device.mitsu.MitsuPre95Command;
import com.ecmtuning.ecmlink.device.mitsu.MitsuStreamThread;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class MitsuDeviceManager
extends DeviceManager {
    static final Logger logger = Logger.getLogger(MitsuDeviceManager.class.getName());
    private static final boolean loggingFinest = logger.isLoggable(Level.FINEST);
    private static final boolean loggingFiner = logger.isLoggable(Level.FINER);
    private static final boolean loggingFine = logger.isLoggable(Level.FINE);
    public static final String PROPERTYNAME_BIT_RATE = "BitRate";
    public static final String PROPERTYNAME_DIAG_SLEEP_TIME_MILLIS = "diagSleepTimeMillis";
    public static final String PROPERTYNAME_BYTE_DELAY_MILLIS = "byteDelayMillis";
    public static final String PROPERTYNAME_CMD_TIMEOUT_MILLIS = "cmdTimeoutMillis";
    public static final String PROPERTYNAME_TOC_LIST = "tocList";
    public static final String PROPERTYNAME_CONNECT_TRY_DEVID = "connectTryDevId";
    private static final int DEFAULT_BIT_RATE = 1952;
    private static final long DEFAULT_DIAG_SLEEP_TIME_MILLIS = 100L;
    private static final long DEFAULT_BYTE_DELAY_MILLIS = 0L;
    private static final long DEFAULT_CMD_TIMEOUT_MILLIS = 250L;
    private static final String DEFAULT_TOC_LIST = "RawFrO2Volts,RPM32,DegreesBTDC,RawKnock,RawThrotPos,SmallMAFFreq";
    private static final int DEFAULT_CONNECT_TRY_DEVID = 0x7E000000;
    private int bitRate;
    private long diagSleepTimeMillis;
    private long byteDelayMillis;
    private long cmdTimeoutMillis;
    private String tocList;
    private int connectTryDevId;
    private static final long RETRY_DELAY_MILLIS = 250L;
    final Object currentCommandMutex = new Object();
    MitsuCommand currentCommand = null;
    private static final long MINIMUM_POLL_INTERVAL_MILLIS = 2000L;
    private long lastResponseCommandMillis = 0L;
    private MitsuDataAdapter dataAdapter;
    private int connectedDeviceId;
    private LocationTOC locationTOC;
    private MitsuStreamThread streamThread;
    private Object streamThreadMutex = new Object();
    private boolean installed = false;

    public void setConnected(boolean bl) throws IOException, DeviceException {
        if (this.isInTxThread()) {
            return;
        }
        if (!bl && this.isConnected()) {
            try {
                DatasetManager.getInstance().setStreaming(false);
            }
            finally {
                this.device_closeConnection();
            }
        } else if (bl && !this.isConnected()) {
            MitsuPre95Command mitsuPre95Command = new MitsuPre95Command(-1);
            this.local_sendCommand(mitsuPre95Command);
        }
    }

    public int getConnectedDefinitionID() throws IOException, DeviceException {
        return (this.getConnectedDeviceId() & 0xFF0000) >> 16;
    }

    public int getSafeDefinitionID() {
        if (!this.isConnected()) {
            return -1;
        }
        return (this.connectedDeviceId & 0xFF0000) >> 16;
    }

    public int getConnectedConfigID() throws IOException, DeviceException {
        return this.getConnectedDeviceId() & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreaming(boolean bl) throws IOException, DeviceException {
        if (bl) {
            this.setConnected(true);
            this.getCurrentPort().setRTS(true);
            Object object = this.streamThreadMutex;
            synchronized (object) {
                if (this.streamThread == null) {
                    this.streamThread = new MitsuStreamThread(this.getConnectedLocationTOC(), this);
                    this.streamThread.start();
                    this.sendNewStatusText("Stream data started");
                }
            }
        } else {
            this.tearDownStream();
        }
    }

    public LocationTOC getConnectedLocationTOC() throws IOException, DeviceException {
        this.setConnected(true);
        return this.locationTOC;
    }

    public void setConnectedLocationTOC(LocationTOC locationTOC) throws IOException, DeviceException {
        this.setConnected(true);
        logger.fine("Attempting to store new TOC data");
        LocationTOC locationTOC2 = this.getConnectedLocationTOC();
        ArrayList arrayList = new ArrayList(locationTOC2.getTOCEntries());
        if (locationTOC.getTOCEntries().equals(arrayList)) {
            logger.fine("No changes to TOC.  Ignoring update.");
            return;
        }
        List list = locationTOC.getTOCEntries();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LocationTOCEntry locationTOCEntry = (LocationTOCEntry)iterator.next();
            stringBuffer.append(locationTOCEntry.getRealLocation().getAssignedName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        this.setTocList(stringBuffer.toString());
        locationTOC2.setTOCEntries(list);
    }

    public int readData(int n, boolean bl) throws IOException, DeviceException {
        this.setConnected(true);
        if (loggingFinest) {
            logger.finest("address = 0x" + XFormatter.toHex2(n) + " (" + n + "), twoByte = " + bl);
        }
        MitsuCommand mitsuCommand = MitsuCommandMgr.createReadCommand(this.connectedDeviceId, n);
        MitsuCommand mitsuCommand2 = this.local_sendCommand(mitsuCommand);
        int n2 = mitsuCommand2.getResponseData();
        if (bl) {
            n2 *= 256;
            mitsuCommand = MitsuCommandMgr.createReadCommand(this.connectedDeviceId, n + 1);
            mitsuCommand2 = this.local_sendCommand(mitsuCommand);
            n2 += mitsuCommand2.getResponseData();
        }
        if (loggingFinest) {
            logger.finest("response = 0x" + XFormatter.toHex4(n2) + " (" + n2 + ")");
        }
        return n2;
    }

    MitsuCommand sendCommand(MitsuCommand mitsuCommand) throws DeviceException, IOException {
        this.setConnected(true);
        if (loggingFine) {
            logger.fine("requested to send command: " + mitsuCommand.toString());
        }
        MitsuCommand mitsuCommand2 = this.local_sendCommand(mitsuCommand);
        if (loggingFine) {
            logger.fine("got response command: " + mitsuCommand2.toString());
        }
        return mitsuCommand2;
    }

    @Override
    protected Collection device_openConnection(DevicePort devicePort) throws IOException, DeviceException {
        if (loggingFine) {
            logger.fine("Called for port " + devicePort);
        }
        try {
            if (loggingFine) {
                logger.fine("Setting bitrate to " + this.getBitRate());
            }
            devicePort.setBitRate(this.getBitRate());
        }
        catch (Exception exception) {
            throw new DevicePortFailedException("Port refused to accept required bitrate");
        }
        MitsuCommand mitsuCommand = MitsuCommandMgr.createDefinitionIdReadCommand(this.connectTryDevId);
        mitsuCommand.setTryCount(2);
        MitsuCommand mitsuCommand2 = this._device_sendCommand(mitsuCommand, devicePort);
        int n = mitsuCommand2.getResponseData();
        if (loggingFine) {
            logger.fine("Got ID response [1 of 3]: 0x" + XFormatter.toHex2(n));
        }
        this.sendNewStatusText(devicePort.getPortId() + ": Got device definition ID [1 of 3]");
        mitsuCommand = MitsuCommandMgr.createConfig1ReadCommand(this.connectTryDevId);
        mitsuCommand.setTryCount(2);
        mitsuCommand2 = this._device_sendCommand(mitsuCommand, devicePort);
        int n2 = mitsuCommand2.getResponseData();
        if (loggingFine) {
            logger.fine("Got configByte1 response [2 of 3]: 0x" + XFormatter.toHex2(n2));
        }
        this.sendNewStatusText(devicePort.getPortId() + ": Got first config byte [2 of 3]");
        mitsuCommand = MitsuCommandMgr.createConfig2ReadCommand(this.connectTryDevId);
        mitsuCommand.setTryCount(2);
        mitsuCommand2 = this._device_sendCommand(mitsuCommand, devicePort);
        int n3 = mitsuCommand2.getResponseData();
        if (loggingFine) {
            logger.fine("Got configByte2 response [3 of 3]: 0x" + XFormatter.toHex2(n3));
        }
        this.sendNewStatusText(devicePort.getPortId() + ": Got second config byte [3 of 3]");
        logger.fine("CONNECTED!");
        this.connectedDeviceId = this.getConnectTryDevId();
        this.connectedDeviceId |= (n & 0xFF) << 16;
        this.connectedDeviceId |= (n2 & 0xFF) << 8;
        this.connectedDeviceId |= n3 & 0xFF;
        logger.info("Connected to device ID: 0x" + XFormatter.toHex8(this.connectedDeviceId));
        if (this.locationTOC != null && this.locationTOC.getDeviceId() != this.connectedDeviceId) {
            this.locationTOC = null;
        }
        if (this.locationTOC == null) {
            String[] stringArray = BasicStrings.trimAll(this.tocList.split(","));
            List list = DataManager.getAliasAssignments(this.getConnectedDeviceId(), this.getConnectedSerialNum());
            ArrayList<LocationTOCEntry> arrayList = new ArrayList<LocationTOCEntry>();
            for (int i = 0; i < stringArray.length; ++i) {
                LocationTOCEntry locationTOCEntry = this.createTOCEntry(list, stringArray[i]);
                if (locationTOCEntry == null) continue;
                arrayList.add(locationTOCEntry);
            }
            this.locationTOC = new LocationTOC(this.connectedDeviceId, arrayList);
        }
        return null;
    }

    public void updateDTCRecord() throws IOException, DeviceException {
        this.setConnected(true);
    }

    private LocationTOCEntry createTOCEntry(List list, String string) throws IOException, DeviceException {
        int n = this.getConnectedDeviceId();
        Location location = DataManager.getLocationByName(n, string);
        Location location2 = null;
        if (loggingFine) {
            logger.fine("Real TOC location: from='" + string + "' - to=" + (location == null ? "null" : location.getDisplayName()));
        }
        if (location == null) {
            logger.warning("Unknown location returned from device: deviceId = " + n + ", assignedName = '" + string + "'");
            return null;
        }
        AliasAssignment aliasAssignment = DataManager.findAssignmentOfLocation(list, location);
        if (aliasAssignment != null) {
            location2 = new Location(location, aliasAssignment.getFinalAlias());
            if (loggingFine) {
                logger.fine("    aliased as: " + location2.getDisplayName() + ", type " + location2.getDataType());
            }
        }
        return new LocationTOCEntry(location, location2, false);
    }

    @Override
    protected void device_doOpenTask(Object object) throws IOException, DeviceException {
    }

    @Override
    protected void device_closeConnection() {
        if (loggingFiner) {
            logger.finer("Called");
        }
        this.setCurrentPort(null);
        this.tearDownStream();
        this.lastResponseCommandMillis = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownStream() {
        MitsuStreamThread mitsuStreamThread;
        Object object = this.streamThreadMutex;
        synchronized (object) {
            mitsuStreamThread = this.streamThread;
            this.streamThread = null;
        }
        if (mitsuStreamThread != null) {
            mitsuStreamThread.requestStop();
            this.sendNewStatusText("Stream data stopped");
            try {
                this.getCurrentPort().setRTS(false);
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, "Got exception while trying to setRTS off", iOException);
            }
        }
    }

    @Override
    protected boolean device_isConnected() {
        return this.getCurrentPort() != null;
    }

    MitsuCommand local_sendCommand(MitsuCommand mitsuCommand) throws IOException, DeviceException {
        MitsuCommand mitsuCommand2 = this.isInTxThread() ? (MitsuCommand)this.device_sendCommand(mitsuCommand) : (MitsuCommand)this.manager_sendCommand(mitsuCommand);
        return mitsuCommand2;
    }

    @Override
    protected Object device_sendCommand(DeviceCommand deviceCommand) throws IOException, DeviceException {
        MitsuCommand mitsuCommand = (MitsuCommand)deviceCommand;
        if (mitsuCommand.getCmdId() == -1) {
            return mitsuCommand;
        }
        DevicePort devicePort = this.getCurrentPort();
        return this._device_sendCommand(mitsuCommand, devicePort);
    }

    private MitsuCommand _device_sendCommand(MitsuCommand mitsuCommand, DevicePort devicePort) throws IOException, DeviceException {
        if (devicePort == null || !devicePort.isOpen()) {
            throw new IOException("Port closed before sendCommand");
        }
        boolean bl = false;
        this.deviceListeners.fire("commandSendStart");
        try {
            MitsuCommand mitsuCommand2 = this.__device_sendCommand(mitsuCommand, devicePort);
            bl = true;
            this.deviceListeners.fire("commandSendEnd");
            MitsuCommand mitsuCommand3 = mitsuCommand2;
            return mitsuCommand3;
        }
        catch (DeviceException deviceException) {
            if (loggingFinest) {
                logger.finest("Got exception: " + deviceException);
                logger.finest("CLOSING PORT");
            }
            throw deviceException;
        }
        catch (IOException iOException) {
            if (loggingFinest) {
                logger.finest("Got exception: " + iOException);
                logger.finest("CLOSING PORT");
            }
            throw iOException;
        }
        finally {
            if (!bl) {
                this.deviceListeners.fire("commandSendEndError");
                this.setCurrentPort(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MitsuCommand __device_sendCommand(MitsuCommand mitsuCommand, DevicePort devicePort) throws IOException, DeviceException {
        boolean bl;
        boolean bl2 = DatasetManager.getInstance().isStreaming();
        boolean bl3 = bl = !bl2 && MitsuDeviceMap.isPre95DeviceId(this.connectTryDevId);
        if (bl) {
            if (!devicePort.supportsRTS()) {
                throw new IOException("'" + devicePort.getPortId() + "' does not support required RTS signaling");
            }
            devicePort.setRTS(true);
            try {
                Thread.sleep(this.diagSleepTimeMillis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long l = this.byteDelayMillis;
        long l2 = mitsuCommand.getTimeoutMillis();
        if (l2 == -1L) {
            l2 = this.cmdTimeoutMillis;
        }
        int[] nArray = mitsuCommand.getRawRequestBytes();
        try {
            for (int i = mitsuCommand.getTryCount(); i > 0; --i) {
                long l3 = System.currentTimeMillis() - this.lastResponseCommandMillis;
                if (l3 > 4500L && MitsuDeviceMap.is97UpDeviceId(this.connectTryDevId)) {
                    logger.fine("Need to trigger 97+ MUT mode");
                    if (l3 < 5750L) {
                        try {
                            logger.fine("Waiting a little longer to ensure ECU is out of MUT override");
                            Thread.sleep(5700L - l3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    logger.fine("Sending MUT override signal to ECU");
                    devicePort.setRTS(true);
                    devicePort.sendBreak(1800);
                    devicePort.setRTS(false);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                devicePort.clearReadBuffer();
                Object object = this.currentCommandMutex;
                synchronized (object) {
                    try {
                        mitsuCommand.resetResponseState();
                        this.currentCommand = mitsuCommand;
                        this.writeBytes(devicePort, nArray, l);
                        long l4 = System.currentTimeMillis();
                        while (!this.currentCommand.hasResponseData()) {
                            long l5 = l2 - (System.currentTimeMillis() - l4);
                            if (l5 <= 50L) {
                                break;
                            }
                            this.currentCommandMutex.wait(l5);
                        }
                    }
                    finally {
                        this.currentCommand = null;
                    }
                }
                if (mitsuCommand.hasResponseData()) break;
                if (mitsuCommand.isNoResponseOk()) {
                    break;
                }
                try {
                    if (i > 1) {
                        logger.fine("Issuing retry of timed out command");
                        Thread.sleep(250L);
                        continue;
                    }
                    logger.fine("Command timed out, no more retries allowed");
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DeviceInterruptedException("Interrupted while waiting for reply");
        }
        finally {
            if (bl) {
                devicePort.setRTS(false);
            }
        }
        if (!mitsuCommand.hasResponseData() && !mitsuCommand.isNoResponseOk()) {
            throw new DeviceTimeoutException("No response received!");
        }
        return mitsuCommand.createCopy();
    }

    private void writeBytes(DevicePort devicePort, int[] nArray, long l) throws IOException, DeviceException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] & 0xFF;
            try {
                if (l > 0L) {
                    Thread.sleep(l);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l > 0L) {
                if (loggingFinest) {
                    this.logOutput(n);
                }
                devicePort.putBytes(new int[]{n}, 0, 1);
                continue;
            }
            if (loggingFinest) {
                for (int j = 0; j < nArray.length; ++j) {
                    this.logOutput(nArray[j]);
                }
            }
            devicePort.putBytes(nArray, 0, nArray.length);
            i += nArray.length;
        }
    }

    protected void logOutput(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Output: 0x");
        stringBuffer.append(XFormatter.toHex2(n));
        stringBuffer.append(" (");
        stringBuffer.append(Integer.toString(n));
        stringBuffer.append(")");
        logger.finest(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void device_parseAndDispatchRxData(int[] nArray, int n) {
        Object object = this.currentCommandMutex;
        synchronized (object) {
            if (this.currentCommand == null) {
                return;
            }
            this.currentCommand.parseIncomingData(nArray, n);
            if (this.currentCommand.hasResponseData()) {
                this.currentCommandMutex.notifyAll();
                this.lastResponseCommandMillis = System.currentTimeMillis();
            }
        }
    }

    @Override
    protected void device_poll() {
        block8: {
            if (loggingFinest) {
                logger.finest("Called");
            }
            if (System.currentTimeMillis() - this.lastResponseCommandMillis < 2000L) {
                return;
            }
            if (!this.device_isConnected()) {
                return;
            }
            if (DatasetManager.getInstance().isStreaming()) {
                return;
            }
            try {
                MitsuCommand mitsuCommand = MitsuCommandMgr.createDefinitionIdReadCommand(this.connectTryDevId);
                this.local_sendCommand(mitsuCommand);
                if (loggingFinest) {
                    logger.finest("Poll completed OK");
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                if (!loggingFinest) break block8;
                logger.finest("Got exception: " + exception);
            }
        }
    }

    @Override
    protected DeviceDatastreamInterface device_createDatastreamInterface() {
        return new MitsuDeviceDatastream(this);
    }

    @Override
    protected int device_getConnectedDeviceId() throws IOException, DeviceException {
        this.setConnected(true);
        return this.connectedDeviceId;
    }

    @Override
    protected int device_getConnectedSerialNum() throws IOException, DeviceException {
        this.setConnected(true);
        return 1;
    }

    @Override
    protected int device_getConnectedFirmwareId() throws IOException, DeviceException {
        this.setConnected(true);
        return -1;
    }

    @Override
    protected String device_getDeviceDisplayName(int n) {
        return "MUTII-" + XFormatter.toHex4(n & 0xFFFF);
    }

    @Override
    protected String device_getPreferencesId() {
        return "MitsuDevice";
    }

    @Override
    protected boolean device_supportsDeviceId(int n) {
        return MitsuDeviceManager.isSupportedDeviceId(n);
    }

    public static boolean isSupportedDeviceId(int n) {
        return (n &= 0xFF000000) == 0x7F000000 || n == 0x7E000000;
    }

    @Override
    public void manager_install() {
        if (!this.installed) {
            this.dataAdapter = new MitsuDataAdapter(this);
            DataManager.addKnownDataAdapter(this.dataAdapter);
            this.installed = true;
        }
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(int n) {
        this.bitRate = n;
    }

    public long getDiagSleepTimeMillis() {
        return this.diagSleepTimeMillis;
    }

    public void setDiagSleepTimeMillis(long l) {
        long l2 = this.diagSleepTimeMillis;
        this.diagSleepTimeMillis = l;
        this.firePropertyChange(PROPERTYNAME_DIAG_SLEEP_TIME_MILLIS, l2, l);
    }

    public long getByteDelayMillis() {
        return this.byteDelayMillis;
    }

    public void setByteDelayMillis(long l) {
        long l2 = this.byteDelayMillis;
        this.byteDelayMillis = l;
        this.firePropertyChange(PROPERTYNAME_BYTE_DELAY_MILLIS, l2, l);
    }

    public long getCmdTimeoutMillis() {
        return this.cmdTimeoutMillis;
    }

    public void setCmdTimeoutMillis(long l) {
        long l2 = this.cmdTimeoutMillis;
        this.cmdTimeoutMillis = l;
        this.firePropertyChange(PROPERTYNAME_CMD_TIMEOUT_MILLIS, l2, l);
    }

    public String getTocList() {
        return this.tocList;
    }

    public void setTocList(String string) {
        String string2 = this.tocList;
        this.tocList = string;
        this.firePropertyChange(PROPERTYNAME_TOC_LIST, string2, string);
    }

    public int getConnectTryDevId() {
        return this.connectTryDevId;
    }

    public void setConnectTryDevId(int n) {
        int n2 = this.connectTryDevId;
        this.connectTryDevId = n;
        this.firePropertyChange(PROPERTYNAME_CONNECT_TRY_DEVID, n2, n);
    }

    @Override
    protected void device_restoreFrom(Preferences preferences) {
        this.setBitRate(preferences.getInt(PROPERTYNAME_BIT_RATE, 1952));
        this.setDiagSleepTimeMillis(preferences.getInt(PROPERTYNAME_DIAG_SLEEP_TIME_MILLIS, 100));
        this.setByteDelayMillis(preferences.getInt(PROPERTYNAME_BYTE_DELAY_MILLIS, 0));
        this.setCmdTimeoutMillis(preferences.getInt(PROPERTYNAME_CMD_TIMEOUT_MILLIS, 250));
        this.setTocList(preferences.get(PROPERTYNAME_TOC_LIST, DEFAULT_TOC_LIST));
        this.setConnectTryDevId(preferences.getInt(PROPERTYNAME_CONNECT_TRY_DEVID, 0x7E000000));
    }

    @Override
    protected void device_storeIn(Preferences preferences) {
        preferences.putInt(PROPERTYNAME_BIT_RATE, this.getBitRate());
        preferences.putInt(PROPERTYNAME_DIAG_SLEEP_TIME_MILLIS, (int)this.getDiagSleepTimeMillis());
        preferences.putInt(PROPERTYNAME_BYTE_DELAY_MILLIS, (int)this.getByteDelayMillis());
        preferences.putInt(PROPERTYNAME_CMD_TIMEOUT_MILLIS, (int)this.getCmdTimeoutMillis());
        preferences.put(PROPERTYNAME_TOC_LIST, this.getTocList());
        preferences.putInt(PROPERTYNAME_CONNECT_TRY_DEVID, this.getConnectTryDevId());
    }
}

