/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.mitsu;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.data.LocationTOCEntry;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceDatastream;
import com.ecmtuning.ecmlink.device.mitsu.MitsuDeviceManager;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class MitsuStreamThread
extends Thread {
    private final MitsuDeviceManager deviceManager;
    private final MitsuDeviceDatastream datastreamInterface;
    private boolean stopRequested = false;
    private boolean stopped = false;
    private final boolean[] isAlias;
    private final boolean[] is2Byte;
    private final int[] address;
    private long loopSleepMillis;
    private final int outputPacketSize;
    private static final Logger logger = Logger.getLogger(MitsuStreamThread.class.getName());
    PropertyChangeListener updateRateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MitsuStreamThread.this.updateLoopSleepMillis();
        }
    };

    MitsuStreamThread(LocationTOC locationTOC, MitsuDeviceManager mitsuDeviceManager) {
        this.deviceManager = mitsuDeviceManager;
        this.datastreamInterface = (MitsuDeviceDatastream)mitsuDeviceManager.getDatastreamInterface();
        this.updateLoopSleepMillis();
        DatasetManager datasetManager = DatasetManager.getInstance();
        WeakListeners.addPropertyChangeListener(this.updateRateListener, (Object)datasetManager, "screenupdatehz");
        this.setName("MitsuStreamThread");
        this.setDaemon(true);
        this.isAlias = new boolean[256];
        this.is2Byte = new boolean[256];
        this.address = new int[256];
        Arrays.fill(this.isAlias, false);
        Arrays.fill(this.is2Byte, false);
        Arrays.fill(this.address, 0);
        int n = 0;
        for (LocationTOCEntry locationTOCEntry : locationTOC.getTOCEntries()) {
            int n2 = locationTOCEntry.getRealLocation().getSize();
            boolean bl = locationTOCEntry.isAliased();
            if (n2 < 8 || n2 > 16) {
                logger.warning("Found invalid bit size of " + n2 + " for realLocation = " + locationTOCEntry.getRealLocation().getAssignedName());
            }
            boolean bl2 = n2 > 8;
            this.isAlias[n] = bl;
            this.is2Byte[n] = bl2;
            this.address[n] = locationTOCEntry.getRealLocation().getAddress();
            ++n;
        }
        this.outputPacketSize = locationTOC.getTOCEntries().size();
    }

    private void updateLoopSleepMillis() {
        float f = DatasetManager.getInstance().getScreenUpdateHz();
        this.loopSleepMillis = Math.round(1000.0f / f);
    }

    void requestStop() {
        this.stopRequested = true;
        if (this.isAlive()) {
            int n;
            try {
                for (n = 0; n < 4; ++n) {
                    Thread.sleep(this.loopSleepMillis);
                    if (this.isAlive()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isAlive()) {
                logger.info("Failed to stop streaming thread once.  Will try again.");
                this.interrupt();
                if (this.isAlive()) {
                    try {
                        for (n = 0; n < 4; ++n) {
                            Thread.sleep(this.loopSleepMillis);
                            if (this.isAlive()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.isAlive()) {
                        logger.warning("Failed to cleanly stop streaming thread");
                    }
                }
            }
        }
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        float[] fArray = new float[this.outputPacketSize];
        ArrayList<TSDataPacket> arrayList = new ArrayList<TSDataPacket>();
        while (!this.stopRequested) {
            if (this.outputPacketSize == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            for (int i = 0; i < this.outputPacketSize; ++i) {
                boolean bl = false;
                try {
                    float f = this.deviceManager.readData(this.address[i], this.is2Byte[i]);
                    if (this.isAlias[i]) {
                        f = 5.0f * f / 255.0f;
                    }
                    fArray[i] = f;
                    bl = true;
                }
                catch (DeviceException deviceException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bl) continue;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long l5 = System.currentTimeMillis();
            if (l == 0L) {
                l = l2 = l5;
                l3 = 0L;
            } else {
                l2 = l5;
                l3 = l5 - l;
            }
            arrayList.add(new TSDataPacket(l3 * 1000L, fArray));
            if (System.currentTimeMillis() - l4 < this.loopSleepMillis) continue;
            this.datastreamInterface.fireStreamDataReceived(arrayList);
            arrayList.clear();
            l4 = System.currentTimeMillis();
        }
    }
}

