/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseField;
import com.ecmtuning.ecmlink.device.records.FeatureAccessor;
import com.ecmtuning.ecmlink.device.records.RawValueInterface;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.Number2BooleanFilter;
import com.ecmtuning.ecmlink.util.model.Number2IntegerFilter;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

public abstract class BaseRecord
implements RawValueInterface,
Serializable {
    protected ArrayList fieldNames;
    protected ArrayList fields;
    protected Hashtable featureAccessors = new Hashtable();
    protected final int deviceId;
    Object recordId;
    protected int byteCount;
    private static final Logger logger = Logger.getLogger(BaseRecord.class.getName());

    protected BaseRecord(int n, Object object) {
        this.deviceId = n;
        this.recordId = object;
        this.fieldNames = new ArrayList();
        this.fields = new ArrayList();
    }

    protected void addField(String string, BaseField baseField) {
        this.fieldNames.add(string);
        this.fields.add(baseField);
        this.byteCount += baseField.getByteLength();
    }

    protected void addFeature(String string, FeatureAccessor featureAccessor) {
        this.featureAccessors.put(string, featureAccessor);
    }

    public boolean hasFeature(String string) {
        return this.featureAccessors.containsKey(string);
    }

    public final ValueModelPlug getFeaturePlug(String string) {
        if (!this.hasFeature(string)) {
            return null;
        }
        return this._getFeaturePlug(string);
    }

    public final ValueModelPlug _getFeaturePlug(String string) {
        Object v = this.featureAccessors.get(string);
        if (v == null || !(v instanceof FeatureAccessor)) {
            return null;
        }
        return ((FeatureAccessor)v).getFeaturePlug(this);
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public BaseField getField(String string) {
        int n = this.fieldNames.indexOf(string);
        BaseField baseField = null;
        if (n != -1) {
            baseField = (BaseField)this.fields.get(n);
        }
        return baseField;
    }

    public List getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public Object getRecordID() {
        return this.recordId;
    }

    public boolean isRecordID(int n) {
        return this.recordId.equals(new Integer(n));
    }

    public boolean isRecordID(String string) {
        return this.recordId.equals(string);
    }

    @Override
    public int getByteLength() {
        return this.byteCount;
    }

    @Override
    public void putToBytes(int[] nArray, int n) {
        for (RawValueInterface rawValueInterface : this.fields) {
            rawValueInterface.putToBytes(nArray, n);
            n += rawValueInterface.getByteLength();
        }
    }

    @Override
    public void setFromBytes(int[] nArray, int n) {
        for (RawValueInterface rawValueInterface : this.fields) {
            rawValueInterface.setFromBytes(nArray, n);
            n += rawValueInterface.getByteLength();
        }
    }

    public void copyRawDataFrom(BaseRecord baseRecord) {
        if (baseRecord.getByteLength() != this.getByteLength()) {
            logger.warning("Internal error: copyRawDataFrom called for invalid record");
            return;
        }
        int[] nArray = new int[this.getByteLength()];
        baseRecord.putToBytes(nArray, 0);
        this.setFromBytes(nArray, 0);
    }

    public Object clone() {
        BaseRecord baseRecord = null;
        try {
            baseRecord = (BaseRecord)super.clone();
            baseRecord.fieldNames = new ArrayList(this.fieldNames);
            baseRecord.cloneFieldsFrom(this.fields);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return baseRecord;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof BaseRecord)) {
            return false;
        }
        BaseRecord baseRecord = (BaseRecord)object;
        return baseRecord.getByteLength() == this.getByteLength() && baseRecord.getRecordID().equals(this.getRecordID()) && baseRecord.fieldNames.equals(this.fieldNames) && baseRecord.fields.equals(this.fields);
    }

    public int hashCode() {
        int n = 0;
        n = this.getByteLength();
        n += 31 * this.getRecordID().hashCode();
        n += 31 * this.fieldNames.hashCode();
        return n += 31 * this.fields.hashCode();
    }

    private void cloneFieldsFrom(ArrayList arrayList) {
        this.fields = new ArrayList(arrayList.size());
        for (BaseField baseField : arrayList) {
            this.fields.add(baseField.clone());
        }
    }

    public String getDescription() {
        return "record id " + this.recordId.toString();
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("{recordId=");
        stringBuffer.append(this.recordId.toString());
        stringBuffer.append(",length=");
        stringBuffer.append(Integer.toString(this.getByteLength()));
        stringBuffer.append("} fields={");
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.fieldNames.get(i);
            Object e = this.fields.get(i);
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(e.toString());
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public BaseField getListField(String string) {
        int n = this.fieldNames.indexOf(string);
        BaseField baseField = null;
        if (n != -1 && !((baseField = (BaseField)this.fields.get(n)).getValue() instanceof ArrayListModel)) {
            baseField = null;
        }
        return baseField;
    }

    public ListModelPlug numberListField(String string) {
        return new ListModelPlug((ValueModel)this.getListField(string), null);
    }

    public ListModelPlug numberListFieldAsString(String string, int n) {
        ArrayList<Number2StringFilter> arrayList = new ArrayList<Number2StringFilter>();
        arrayList.add(new Number2StringFilter(n));
        return new ListModelPlug((ValueModel)this.getField(string), arrayList);
    }

    public ValueModelPlug numberFieldAsInteger(String string) {
        return this.numberFieldAsInteger(string, 1);
    }

    public ValueModelPlug numberFieldAsInteger(String string, int n) {
        ArrayList<Number2IntegerFilter> arrayList = new ArrayList<Number2IntegerFilter>();
        arrayList.add(new Number2IntegerFilter(n));
        return new ValueModelPlug((ValueModel)this.getField(string), arrayList);
    }

    public ValueModelPlug numberFieldAsIntegerString(String string, int n) {
        ArrayList<ObjectFilter> arrayList = new ArrayList<ObjectFilter>();
        arrayList.add(new Number2IntegerFilter(n));
        arrayList.add(new Number2StringFilter(0));
        return new ValueModelPlug((ValueModel)this.getField(string), arrayList);
    }

    public ValueModelPlug numberFieldAsString(String string, int n) {
        ArrayList<Number2StringFilter> arrayList = new ArrayList<Number2StringFilter>();
        arrayList.add(new Number2StringFilter(n));
        return new ValueModelPlug((ValueModel)this.getField(string), arrayList);
    }

    public ValueModelPlug numberFieldAsString(String string) {
        return this.numberFieldAsString(string, 0);
    }

    public ValueModelPlug numberFieldAsBoolean(String string, int n, boolean bl) {
        ArrayList<Number2BooleanFilter> arrayList = new ArrayList<Number2BooleanFilter>();
        arrayList.add(new Number2BooleanFilter(n, bl));
        return new ValueModelPlug((ValueModel)this.getField(string), arrayList);
    }

    public ValueModelPlug numberFieldAsBoolean(String string, int n) {
        return this.numberFieldAsBoolean(string, n, false);
    }

    protected FeatureAccessor booleanAccessor(String string, int n) {
        return this.booleanAccessor(string, n, false);
    }

    protected FeatureAccessor booleanAccessor(String string, int n, boolean bl) {
        return new BooleanAccessor(string, n, bl);
    }

    protected FeatureAccessor integerAccesor(String string) {
        return new IntegerAccessor(string);
    }

    protected FeatureAccessor integerAccesor(String string, int n) {
        return new IntegerAccessor(string, n);
    }

    protected FeatureAccessor stringAccesor(String string) {
        return new StringAccessor(string);
    }

    protected FeatureAccessor stringAccesor(String string, int n) {
        return new StringAccessor(string, n);
    }

    static final class StringAccessor
    implements FeatureAccessor {
        final String fieldName;
        final int precision;

        public StringAccessor(String string) {
            this(string, 0);
        }

        public StringAccessor(String string, int n) {
            this.fieldName = string;
            this.precision = n;
        }

        @Override
        public ValueModelPlug getFeaturePlug(BaseRecord baseRecord) {
            return baseRecord.numberFieldAsString(this.fieldName, this.precision);
        }
    }

    static final class IntegerAccessor
    implements FeatureAccessor {
        final String fieldName;
        final int divisibleBy;

        public IntegerAccessor(String string) {
            this(string, 1);
        }

        public IntegerAccessor(String string, int n) {
            this.fieldName = string;
            this.divisibleBy = n;
        }

        @Override
        public ValueModelPlug getFeaturePlug(BaseRecord baseRecord) {
            return baseRecord.numberFieldAsInteger(this.fieldName, this.divisibleBy);
        }
    }

    static final class BooleanAccessor
    implements FeatureAccessor {
        final String fieldName;
        final int bitmask;
        final boolean invert;

        public BooleanAccessor(String string, int n, boolean bl) {
            this.fieldName = string;
            this.bitmask = n;
            this.invert = bl;
        }

        @Override
        public ValueModelPlug getFeaturePlug(BaseRecord baseRecord) {
            return baseRecord.numberFieldAsBoolean(this.fieldName, this.bitmask, this.invert);
        }
    }
}

