/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.Float16ListField;
import com.ecmtuning.ecmlink.device.records.Float8ListField;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteRecord
extends BaseRecord {
    protected final int definitionId;
    protected final int[] byteAddrs;
    protected final int fieldBitSize;
    public static final String FIELD_NAME = "bytes";
    private static final int FILE_VERSION = 3;
    private static final long FILE_MARKER = 3630067263219068347L;

    public ByteRecord(int n, int n2, ByteRecordDescriptor byteRecordDescriptor, int[] nArray) {
        this(n, n2, byteRecordDescriptor.getRecordId(), byteRecordDescriptor.getByteAddrs(), byteRecordDescriptor.getValuesFieldByteLength() * 8, nArray);
    }

    private ByteRecord(int n, int n2, String string, int[] nArray, int n3, int[] nArray2) {
        super(n, string);
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("ByteRecord (" + string + ") constructed with byteAddrs length (" + nArray.length + ") != data length (" + nArray2.length + ")");
        }
        this.definitionId = n2;
        this.byteAddrs = nArray;
        this.fieldBitSize = n3;
        if (this.fieldBitSize == 16) {
            this.addField(FIELD_NAME, new Float16ListField(this.byteAddrs.length / 2));
        } else {
            this.addField(FIELD_NAME, new Float8ListField(nArray.length));
        }
        this.setFromBytes(nArray2, 0);
    }

    public int getDefinitionId() {
        return this.definitionId;
    }

    public int[] getByteAddrs() {
        return this.byteAddrs;
    }

    public boolean isContiguous() {
        int n = this.byteAddrs[0];
        for (int i = 1; i < this.byteAddrs.length; ++i) {
            if (n + i == this.byteAddrs[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getRawBytesCopy() {
        int[] nArray = new int[this.byteAddrs.length];
        this.getField(FIELD_NAME).putToBytes(nArray, 0);
        return nArray;
    }

    @Override
    public String getDescription() {
        return this.getRecordID().toString();
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 3630067263219068347L, 3);
        dataOutputStream.writeInt(this.deviceId);
        dataOutputStream.writeInt(this.definitionId);
        dataOutputStream.writeUTF((String)this.getRecordID());
        dataOutputStream.writeInt(this.byteAddrs.length);
        for (int i = 0; i < this.byteAddrs.length; ++i) {
            dataOutputStream.writeInt(this.byteAddrs[i]);
        }
        dataOutputStream.writeInt(this.fieldBitSize);
        int[] nArray = new int[this.getByteLength()];
        this.putToBytes(nArray, 0);
        dataOutputStream.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public static ByteRecord read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3 = FileUtils.readFileVersion(dataInputStream, "ByteRecord", 3630067263219068347L, 3);
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        int[] nArray = null;
        if (n3 > 2) {
            n2 = dataInputStream.readInt();
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = dataInputStream.readInt();
            }
        } else {
            n2 = dataInputStream.readInt();
            n = dataInputStream.readInt();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = n2 + i;
            }
        }
        n2 = 8;
        if (n3 > 1) {
            n2 = dataInputStream.readInt();
        }
        n = dataInputStream.readInt();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = dataInputStream.readInt();
        }
        return new ByteRecord(n4, n5, string, nArray, n2, nArray2);
    }
}

