/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.ByteRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptorBase;
import com.ecmtuning.ecmlink.device.records.ByteRecordFilter;
import com.ecmtuning.ecmlink.device.records.ColorMapEntry;
import com.ecmtuning.ecmlink.device.records.Float16Field;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.device.records.SignedInt8Field;
import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;

public class ByteRecordDescriptor
extends ByteRecordDescriptorBase {
    private static final String Z_AXIS_PREFIX = "z";
    private static final String Y_AXIS_PREFIX = "y";
    private static final String X_AXIS_PREFIX = "x";
    private static final String KEY_REVERSE = "reverse";
    private static final String KEY_FLIPXY = "flipxy";
    private static final String KEY_BANNER = "banner";
    private static final String KEY_DESC = "desc";
    private static final String KEY_DEVICE_IDS = "deviceids";
    private static final String KEY_COPY_DEVICE_IDS = "copydeviceids";
    private static final String KEY_ADDRESS = "address";
    private static final String KEY_ADDRESSES = "addresses";
    private static final String KEY_YSIZE = "ysize";
    private static final String KEY_XSIZE = "xsize";
    private static final String KEY_STOCKVALUES = "stockvalues";
    private static final String KEY_ORIGIN = "origin";
    private static final String KEY_GRID = "grid";
    private static final String KEY_VIEWPORT = "viewport";
    private static final String KEY_COLORMAP = "colormap";
    private static final String KEY_VALUE_PROTOTYPES = "valueprototypes";
    private static final String KEY_TRACK_XVALUES = "track.xvalues";
    private static final String KEY_TRACK_YVALUES = "track.yvalues";
    private static final String KEY_TRACK_XTYPE = "track.xtype";
    private static final String KEY_TRACK_YTYPE = "track.ytype";
    private static final String KEY_MENU_SETVALUES = "menu.setvalues";
    private static final String KEY_SUFFIX_FIELDTYPE = "fieldtype";
    private static final String KEY_SUFFIX_FIELDPARMS = "fieldparms";
    private static final String KEY_SUFFIX_FIELDRECIP = "fieldrecip";
    private static final String KEY_SUFFIX_FILTERVALS = "filtervals";
    private static final String KEY_SUFFIX_FILTER = "filter";
    private static final String KEY_SUFFIX_AXIS_TYPE = "type";
    private static final String KEY_SUFFIX_AXIS_HEADER = "header";
    private static final String KEY_SUFFIX_AXIS_VALUES = "values";
    private static final String KEY_SUFFIX_AXIS_PREC = "prec";
    private static final String VALUE_AXIS_TYPE_NUMBER = "number";
    private static final String VALUE_AXIS_TYPE_TEMPC = "tempc";
    private static final String VALUE_AXIS_TYPE_TEMPF = "tempf";
    private static final String VALUE_AXIS_TYPE_TEXT = "text";
    private static final String VALUE_FIELDTYPE_FLOAT8 = "Float8";
    private static final String VALUE_FIELDTYPE_FLOAT16 = "Float16";
    private static final String VALUE_FIELDTYPE_SIGNEDINT8 = "SignedInt8";
    private static final String VALUE_FILTER_SCALE = "ScaleFilter";
    public static final int AXIS_TYPE_NUMBER = 1;
    public static final int AXIS_TYPE_TEMPC = 2;
    public static final int AXIS_TYPE_TEMPF = 3;
    public static final int AXIS_TYPE_TEXT = 4;
    private static final int AXIS_TYPE_UNASSIGNED = -1;
    String bannerText;
    String descText;
    Collection deviceDefIds;
    int[] addresses = new int[0];
    int xSize = Integer.MAX_VALUE;
    int ySize = Integer.MAX_VALUE;
    int[] stockByteValues;
    int[] stockValues;
    ListModelPlug stockValuesModel;
    FloatRect viewportRect = null;
    FloatRect grid = null;
    FloatRect origin = null;
    String[] valuePrototypes = null;
    boolean reverseOrder = false;
    boolean flipXY;
    int xAxisType = -1;
    int yAxisType = -1;
    ValueModel xAxisHeaderModel;
    ValueModel yAxisHeaderModel;
    ListModelPlug xAxisValuesModel;
    ListModelPlug yAxisValuesModel;
    ListModelPlug xAxisRawValuesModel;
    ListModelPlug yAxisRawValuesModel;
    int xAxisPrec;
    int yAxisPrec;
    float[] trackXValues;
    float[] trackYValues;
    String trackXDataTypeName;
    String trackYDataTypeName;
    boolean menuSetValues;
    ObjectFilter valueFilter;
    Float8Field valueBaseField;
    String valueHeader;
    int valuePrec;
    ColorMapEntry[] colorMap;
    private static final float[] gridOptions = new float[]{2.0f, 5.0f, 10.0f, 20.0f, 25.0f, 50.0f, 100.0f, 500.0f};
    private static final String[] defaultValuePrototypes = new String[]{"9999"};

    ByteRecordDescriptor(String string, String string2, int n, List list) {
        super(string, string2, n);
        this.deviceDefIds = list;
    }

    public Float8Field getValueBaseField() {
        return this.valueBaseField;
    }

    public float getAxisMinX() {
        if (this.viewportRect != null) {
            return this.viewportRect.getX();
        }
        return ListUtil.findMin((List)this.xAxisRawValuesModel.getLocalArrayListValue()).floatValue();
    }

    public float getAxisMaxX() {
        if (this.viewportRect != null) {
            return this.viewportRect.getMaxX();
        }
        return ListUtil.findMax((List)this.xAxisRawValuesModel.getLocalArrayListValue()).floatValue();
    }

    public float getAxisMinValue() {
        if (this.viewportRect != null) {
            return this.viewportRect.getY();
        }
        return 0.0f;
    }

    public float getAxisMaxValue() {
        if (this.viewportRect != null) {
            return this.viewportRect.getMaxY();
        }
        return 255.0f;
    }

    public float getGridWidth() {
        if (this.grid != null) {
            return this.grid.getWidth();
        }
        float f = (this.getAxisMaxX() - this.getAxisMinX()) * 0.1f;
        return ListUtil.findClosest(f, gridOptions);
    }

    public float getGridHeight() {
        if (this.grid != null) {
            return this.grid.getHeight();
        }
        float f = (this.getAxisMaxValue() - this.getAxisMinValue()) * 0.1f;
        return ListUtil.findClosest(f, gridOptions);
    }

    public float getOriginX() {
        if (this.origin != null) {
            return this.origin.getX();
        }
        return 0.0f;
    }

    public float getOriginValue() {
        if (this.origin != null) {
            return this.origin.getY();
        }
        return 0.0f;
    }

    public String getDescText() {
        return this.descText;
    }

    public String getBannerText() {
        return this.bannerText;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public boolean isFlipXY() {
        return this.flipXY;
    }

    public FloatRect getGrid() {
        return this.grid;
    }

    public FloatRect getViewportRect() {
        return this.viewportRect;
    }

    public FloatRect getOrigin() {
        return this.origin;
    }

    public int[] getStockByteValues() {
        return this.stockByteValues;
    }

    public ValueModel getStockValuesModel() {
        return this.stockValuesModel;
    }

    public int getByteSize() {
        if (this.isTableRecord()) {
            return this.getXSize() * this.getYSize() * this.getValuesFieldByteLength();
        }
        if (this.isListRecord()) {
            return this.getXSize() * this.getValuesFieldByteLength();
        }
        if (this.isCodeBinaryRecord()) {
            return this.getXSize();
        }
        return 0;
    }

    public int getValuesFieldByteLength() {
        return this.getValueBaseField().getByteLength();
    }

    public int getElementCount() {
        if (this.isTableRecord()) {
            return this.getXSize() * this.getYSize();
        }
        if (this.isListRecord()) {
            return this.getXSize();
        }
        if (this.isCodeBinaryRecord()) {
            return this.getXSize();
        }
        return 0;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        if (this.isTableRecord()) {
            return this.ySize;
        }
        if (this.isListRecord()) {
            return this.getXSize();
        }
        if (this.isCodeBinaryRecord()) {
            return this.getXSize();
        }
        return 0;
    }

    public int[] getByteAddrs() {
        return this.addresses;
    }

    public String[] getValuePrototypes() {
        if (this.valuePrototypes != null) {
            return this.valuePrototypes;
        }
        return defaultValuePrototypes;
    }

    public String getValueHeader() {
        return this.valueHeader;
    }

    public int getValuePrec() {
        return this.valuePrec;
    }

    public ObjectFilter getValueFilter() {
        return this.valueFilter;
    }

    public ValueModel getXAxisHeaderModel() {
        return this.xAxisHeaderModel;
    }

    public int getXAxisType() {
        return this.xAxisType;
    }

    public int getXAxisPrec() {
        return this.xAxisPrec;
    }

    public ValueModel getXAxisValuesModel() {
        return this.xAxisValuesModel;
    }

    public ValueModel getXAxisRawValuesModel() {
        return this.xAxisRawValuesModel;
    }

    public ValueModel getYAxisHeaderModel() {
        return this.yAxisHeaderModel;
    }

    public int getYAxisType() {
        return this.yAxisType;
    }

    public int getYAxisPrec() {
        return this.yAxisPrec;
    }

    public ValueModel getYAxisValuesModel() {
        return this.yAxisValuesModel;
    }

    public ValueModel getYAxisRawValuesModel() {
        return this.yAxisRawValuesModel;
    }

    public boolean hasTrackData() {
        return this.isTableRecord() && this.trackXDataTypeName != null && this.trackXValues != null && this.trackYDataTypeName != null && this.trackYValues != null;
    }

    public String getTrackXDataTypeName() {
        return this.trackXDataTypeName;
    }

    public float[] getTrackXValues() {
        return this.trackXValues;
    }

    public String getTrackYDataTypeName() {
        return this.trackYDataTypeName;
    }

    public float[] getTrackYValues() {
        return this.trackYValues;
    }

    public boolean doMenuSetValues() {
        return this.menuSetValues;
    }

    public ColorMapEntry[] getColorMap() {
        return this.colorMap;
    }

    public ByteRecord findCompatibleRecord(Collection collection) {
        for (ByteRecord byteRecord : collection) {
            if (this.isCompatibleWithRecord(byteRecord)) {
                return byteRecord;
            }
            if (!this.getRecordId().equals(byteRecord.getRecordID())) continue;
            return byteRecord;
        }
        return null;
    }

    Collection getSupportedDeviceDefIds() {
        return this.deviceDefIds;
    }

    public boolean isCompatibleWithDevice(int n, int n2) {
        int n3 = (n & 0xFF) << 8 | n2 & 0xFF;
        return this.getSupportedDeviceDefIds().contains(new Integer(n3));
    }

    public boolean isCompatibleWithRecord(ByteRecord byteRecord) {
        return this.isCompatibleWithDevice(byteRecord.getDeviceId(), byteRecord.getDefinitionId()) && Arrays.equals(byteRecord.getByteAddrs(), this.getByteAddrs());
    }

    boolean isCompatibleWithDescriptor(ByteRecordDescriptor byteRecordDescriptor) {
        if (byteRecordDescriptor.getRecordId().equals(this.getRecordId())) {
            return ListUtil.containsAny(this.getSupportedDeviceDefIds(), byteRecordDescriptor.getSupportedDeviceDefIds());
        }
        return false;
    }

    boolean initialize(ResourceBundle resourceBundle, String string) {
        this.parseViewport(resourceBundle);
        this.parseGrid(resourceBundle);
        this.parseOrigin(resourceBundle);
        this.parseReverse(resourceBundle);
        this.parseMenuItems(resourceBundle);
        this.parseFlipXY(resourceBundle);
        this.parseColormap(resourceBundle);
        this.parsePrototypes(resourceBundle);
        boolean bl = true;
        bl &= this.parseBanner(resourceBundle);
        bl = coreValuesOnly ? this.parseCoreAxisAndFieldType(resourceBundle, bl) : this.parseAxisAndFieldType(resourceBundle, bl &= this.parseDesc(resourceBundle));
        bl &= this.parseSize(resourceBundle);
        if (bl &= this.parseAddress(resourceBundle, string)) {
            bl &= this.parseStockValues(resourceBundle, string);
            if (this.getValuesFieldByteLength() == 2) {
                this.stockByteValues = new int[this.stockValues.length * 2];
                for (int i = 0; i < this.stockValues.length; ++i) {
                    this.stockByteValues[i * 2] = (this.stockValues[i] & 0xFF00) >> 8;
                    this.stockByteValues[i * 2 + 1] = this.stockValues[i] & 0xFF;
                }
            }
        }
        return bl;
    }

    private boolean parseCoreAxisAndFieldType(ResourceBundle resourceBundle, boolean bl) {
        this.xAxisType = this.parseAxisType(resourceBundle, X_AXIS_PREFIX);
        if (this.xAxisType != -1) {
            if (this.isTableRecord()) {
                this.yAxisType = this.parseAxisType(resourceBundle, Y_AXIS_PREFIX);
                if (this.yAxisType == -1) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        if (bl) {
            String string = Y_AXIS_PREFIX;
            if (this.isTableRecord()) {
                string = Z_AXIS_PREFIX;
            }
            this.valueHeader = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_AXIS_HEADER, true);
            if (this.valueHeader != null) {
                this.valuePrec = this.parseAxisPrec(resourceBundle, string);
                bl &= this.parseFieldType(resourceBundle, string);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private boolean parseAxisAndFieldType(ResourceBundle resourceBundle, boolean bl) {
        this.xAxisType = this.parseAxisType(resourceBundle, X_AXIS_PREFIX);
        if (this.xAxisType != -1) {
            this.xAxisHeaderModel = this.parseAxisHeader(resourceBundle, X_AXIS_PREFIX, this.xAxisType);
            this.xAxisRawValuesModel = this.parseAxisValues(resourceBundle, X_AXIS_PREFIX, this.xAxisType);
            this.xAxisPrec = this.parseAxisPrec(resourceBundle, X_AXIS_PREFIX);
            if (this.xAxisHeaderModel != null && this.xAxisRawValuesModel != null) {
                this.xAxisValuesModel = this.produceFilteredModel(this.xAxisRawValuesModel, this.xAxisType);
                if (this.isTableRecord()) {
                    this.trackXValues = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, KEY_TRACK_XVALUES, false);
                    this.trackYValues = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, KEY_TRACK_YVALUES, false);
                    this.trackXDataTypeName = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_TRACK_XTYPE, false);
                    this.trackYDataTypeName = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_TRACK_YTYPE, false);
                    if (!(this.trackXValues == null && this.trackYValues == null && this.trackXDataTypeName == null && this.trackYDataTypeName == null || this.trackXValues != null && this.trackYValues != null && this.trackXDataTypeName != null && this.trackYDataTypeName != null)) {
                        bl = false;
                    }
                    this.yAxisType = this.parseAxisType(resourceBundle, Y_AXIS_PREFIX);
                    if (this.yAxisType != -1) {
                        this.yAxisHeaderModel = this.parseAxisHeader(resourceBundle, Y_AXIS_PREFIX, this.yAxisType);
                        this.yAxisRawValuesModel = this.parseAxisValues(resourceBundle, Y_AXIS_PREFIX, this.yAxisType);
                        this.yAxisPrec = this.parseAxisPrec(resourceBundle, Y_AXIS_PREFIX);
                        if (this.yAxisHeaderModel != null && this.yAxisRawValuesModel != null) {
                            this.yAxisValuesModel = this.produceFilteredModel(this.yAxisRawValuesModel, this.yAxisType);
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            String string = Y_AXIS_PREFIX;
            if (this.isTableRecord()) {
                string = Z_AXIS_PREFIX;
            }
            this.valueHeader = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_AXIS_HEADER, true);
            if (this.valueHeader != null) {
                this.valuePrec = this.parseAxisPrec(resourceBundle, string);
                if (bl &= this.parseFieldType(resourceBundle, string)) {
                    bl &= this.parseValueFilter(resourceBundle, string);
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private boolean parseFieldType(ResourceBundle resourceBundle, String string) {
        String string2 = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_FIELDTYPE, true);
        if (string2 == null) {
            return false;
        }
        if (VALUE_FIELDTYPE_FLOAT8.equals(string2)) {
            float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, string + KEY_SUFFIX_FIELDPARMS, true);
            if (fArray == null) {
                return false;
            }
            if (fArray.length != 4) {
                ByteRecordDescriptor.logInitExceptionText("Float8 fieldparms must contain exactly 4 float values");
            }
            this.valueBaseField = new Float8Field(fArray[0], fArray[1], fArray[2], fArray[3]);
            String string3 = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_FIELDRECIP, false);
            if (string3 != null && Boolean.valueOf(string3).booleanValue()) {
                this.valueBaseField.reciprocateRaw();
            }
            return true;
        }
        if (VALUE_FIELDTYPE_FLOAT16.equals(string2)) {
            float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, string + KEY_SUFFIX_FIELDPARMS, true);
            if (fArray == null) {
                return false;
            }
            if (fArray.length != 4) {
                ByteRecordDescriptor.logInitExceptionText("Float16 fieldparms must contain exactly 4 float values");
            }
            this.valueBaseField = new Float16Field(fArray[0], fArray[1], fArray[2], fArray[3]);
            String string4 = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_FIELDRECIP, false);
            if (string4 != null && Boolean.valueOf(string4).booleanValue()) {
                this.valueBaseField.reciprocateRaw();
            }
            return true;
        }
        if (VALUE_FIELDTYPE_SIGNEDINT8.equals(string2)) {
            float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, string + KEY_SUFFIX_FIELDPARMS, true);
            if (fArray == null) {
                return false;
            }
            if (fArray.length != 2) {
                ByteRecordDescriptor.logInitExceptionText("SignedInt8 fieldparms must contain exactly 2 float values");
            }
            this.valueBaseField = new SignedInt8Field(fArray[0], fArray[1]);
            return true;
        }
        ByteRecordDescriptor.logInitExceptionText("Unknown fieldtype value of '" + string2 + "'");
        return false;
    }

    private boolean parseValueFilter(ResourceBundle resourceBundle, String string) {
        String string2 = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_FILTER, false);
        if (string2 == null) {
            return true;
        }
        float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, string + KEY_SUFFIX_FILTERVALS, false);
        if (fArray == null) {
            return false;
        }
        if (VALUE_FILTER_SCALE.equalsIgnoreCase(string2)) {
            this.valueFilter = new ByteRecordFilter(fArray[0], fArray[1], fArray[2], fArray[3]);
            return true;
        }
        ByteRecordDescriptor.logInitExceptionText("Unknown filter value of '" + string2 + "'");
        return false;
    }

    private int parseAxisType(ResourceBundle resourceBundle, String string) {
        String string2 = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_AXIS_TYPE, true);
        if (VALUE_AXIS_TYPE_NUMBER.equalsIgnoreCase(string2)) {
            return 1;
        }
        if (VALUE_AXIS_TYPE_TEMPC.equalsIgnoreCase(string2)) {
            return 2;
        }
        if (VALUE_AXIS_TYPE_TEMPF.equalsIgnoreCase(string2)) {
            return 3;
        }
        if (VALUE_AXIS_TYPE_TEXT.equalsIgnoreCase(string2)) {
            return 4;
        }
        return -1;
    }

    private int parseAxisPrec(ResourceBundle resourceBundle, String string) {
        Integer n = ByteRecordDescriptor.parseIntParameter(resourceBundle, string + KEY_SUFFIX_AXIS_PREC, false);
        if (n != null) {
            return n;
        }
        return 0;
    }

    private ValueModel parseAxisHeader(ResourceBundle resourceBundle, String string, int n) {
        String string2 = ByteRecordDescriptor.loadParameter(resourceBundle, string + KEY_SUFFIX_AXIS_HEADER, true);
        if (string2 == null) {
            return null;
        }
        if (n == 1 || n == 4) {
            return new ValueHolder((Object)string2);
        }
        if (n == 2 || n == 3) {
            ValueHolder valueHolder = new ValueHolder((Object)"");
            TemperatureChangeListener temperatureChangeListener = new TemperatureChangeListener((ValueModel)valueHolder, string2);
            UnitsModel unitsModel = UnitsModel.getInstance();
            AbstractValueModel abstractValueModel = unitsModel.getBeanAdapter().getValueModel("temperatureIndex");
            abstractValueModel.addValueChangeListener((PropertyChangeListener)temperatureChangeListener);
            return valueHolder;
        }
        return null;
    }

    private ListModelPlug parseAxisValues(ResourceBundle resourceBundle, String string, int n) {
        Object object;
        Object[] objectArray;
        if (n == 4) {
            objectArray = ByteRecordDescriptor.loadArrayParameter(resourceBundle, string + KEY_SUFFIX_AXIS_VALUES, true);
        } else {
            object = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, string + KEY_SUFFIX_AXIS_VALUES, false);
            if (object == null) {
                return null;
            }
            objectArray = ListUtil.convertToFloatArray(object);
        }
        object = new ArrayListModel(Arrays.asList(objectArray));
        ValueHolder valueHolder = new ValueHolder(object);
        ListModelPlug listModelPlug = new ListModelPlug((ValueModel)valueHolder, null, false);
        listModelPlug.setReverseSubjectAccess(this.isReverseOrder());
        return listModelPlug;
    }

    private ListModelPlug produceFilteredModel(ValueModel valueModel, int n) {
        ListModelPlug listModelPlug = new ListModelPlug(valueModel, null, false);
        if (n == 2) {
            UnitsHelper.installFilter(listModelPlug, "typeTemperatureFromC");
        } else if (n == 3) {
            UnitsHelper.installFilter(listModelPlug, "typeTemperatureFromF");
        }
        return listModelPlug;
    }

    private void parseReverse(ResourceBundle resourceBundle) {
        this.reverseOrder = false;
        String string = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_REVERSE, false);
        if (string != null) {
            this.reverseOrder = Boolean.valueOf(string);
        }
    }

    private void parseMenuItems(ResourceBundle resourceBundle) {
        this.menuSetValues = true;
        String string = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_MENU_SETVALUES, false);
        if (string != null) {
            this.menuSetValues = Boolean.valueOf(string);
        }
    }

    private void parseFlipXY(ResourceBundle resourceBundle) {
        this.flipXY = false;
        String string = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_FLIPXY, false);
        if (string != null) {
            this.flipXY = Boolean.valueOf(string);
        }
    }

    private void parsePrototypes(ResourceBundle resourceBundle) {
        String[] stringArray = ByteRecordDescriptor.loadArrayParameter(resourceBundle, KEY_VALUE_PROTOTYPES, false);
        if (stringArray != null) {
            this.valuePrototypes = stringArray;
        }
    }

    private void parseColormap(ResourceBundle resourceBundle) {
        float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, KEY_COLORMAP, false);
        if (fArray == null) {
            return;
        }
        if ((fArray.length & 1) == 1) {
            ByteRecordDescriptor.logInitExceptionText("Invalid colormap specification '" + ByteRecordDescriptor.loadParameter(resourceBundle, KEY_COLORMAP, false) + "'.  Must be an even number of elements.");
            return;
        }
        try {
            this.colorMap = new ColorMapEntry[fArray.length / 2];
            for (int i = 0; i < fArray.length; i += 2) {
                ColorMapEntry colorMapEntry;
                this.colorMap[i / 2] = colorMapEntry = new ColorMapEntry(fArray[i], (int)fArray[i + 1]);
            }
            Arrays.sort(this.colorMap, new Comparator(){

                public int compare(Object object, Object object2) {
                    ColorMapEntry colorMapEntry = (ColorMapEntry)object;
                    ColorMapEntry colorMapEntry2 = (ColorMapEntry)object2;
                    return Float.compare(colorMapEntry.value, colorMapEntry2.value);
                }
            });
        }
        catch (Exception exception) {
            ByteRecordDescriptor.logInitExceptionText("Invalid colormap specification '" + ByteRecordDescriptor.loadParameter(resourceBundle, KEY_COLORMAP, false) + "'");
        }
    }

    private void parseViewport(ResourceBundle resourceBundle) {
        float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, KEY_VIEWPORT, false);
        if (fArray == null) {
            return;
        }
        if (fArray.length != 4) {
            ByteRecordDescriptor.logInitExceptionText("Invalid viewport specification '" + ByteRecordDescriptor.loadParameter(resourceBundle, KEY_VIEWPORT, false) + "'");
            return;
        }
        this.viewportRect = new FloatRect();
        this.viewportRect.setCorners(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    private void parseGrid(ResourceBundle resourceBundle) {
        float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, KEY_GRID, false);
        if (fArray == null) {
            return;
        }
        if (fArray.length != 2) {
            ByteRecordDescriptor.logInitExceptionText("Invalid grid specification '" + ByteRecordDescriptor.loadParameter(resourceBundle, KEY_GRID, false) + "'");
            return;
        }
        this.grid = new FloatRect();
        this.grid.setCorners(0.0f, 0.0f, fArray[0], fArray[1]);
    }

    private void parseOrigin(ResourceBundle resourceBundle) {
        float[] fArray = ByteRecordDescriptor.parseFloatArrayParameter(resourceBundle, KEY_ORIGIN, false);
        if (fArray == null) {
            return;
        }
        if (fArray.length != 2) {
            ByteRecordDescriptor.logInitExceptionText("Invalid origin specification '" + ByteRecordDescriptor.loadParameter(resourceBundle, KEY_ORIGIN, false) + "'");
            return;
        }
        this.origin = new FloatRect(fArray[0], fArray[1], 0.0f, 0.0f);
    }

    private boolean parseBanner(ResourceBundle resourceBundle) {
        this.bannerText = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_BANNER, true);
        return this.bannerText != null;
    }

    private boolean parseDesc(ResourceBundle resourceBundle) {
        this.descText = ByteRecordDescriptor.loadParameter(resourceBundle, KEY_DESC, true);
        return this.descText != null;
    }

    private boolean parseAddress(ResourceBundle resourceBundle, String string) {
        Integer n = ByteRecordDescriptor.parseIntParameter(resourceBundle, "address." + string, true);
        if (n != null) {
            int n2 = n;
            int n3 = this.getByteSize();
            this.addresses = new int[n3];
            for (int i = 0; i < n3; ++i) {
                this.addresses[i] = n2 + i;
            }
        } else {
            int[] nArray = ByteRecordDescriptor.parseIntArrayParameter(resourceBundle, "addresses." + string, true);
            if (nArray == null) {
                return false;
            }
            if (nArray.length != this.getByteSize()) {
                ByteRecordDescriptor.logInitExceptionText("Addresses of length " + nArray.length + " != size of " + this.getByteSize());
                return false;
            }
            this.addresses = nArray;
        }
        return true;
    }

    private boolean parseSize(ResourceBundle resourceBundle) {
        Integer n = ByteRecordDescriptor.parseIntParameter(resourceBundle, KEY_XSIZE, true);
        if (n != null) {
            this.xSize = n;
            if (this.isTableRecord()) {
                n = ByteRecordDescriptor.parseIntParameter(resourceBundle, KEY_YSIZE, true);
                if (n != null) {
                    this.ySize = n;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean parseStockValues(ResourceBundle resourceBundle, String string) {
        int[] nArray = ByteRecordDescriptor.parseIntArrayParameter(resourceBundle, "stockvalues." + string, true);
        if (nArray == null) {
            return false;
        }
        if (nArray.length != this.getElementCount()) {
            ByteRecordDescriptor.logInitExceptionText("Stock values length of " + nArray.length + " != size of " + this.getElementCount());
            return false;
        }
        this.stockValues = nArray;
        this.stockByteValues = nArray;
        Float[] floatArray = ListUtil.convertToFloatArray(this.stockValues);
        ArrayListModel arrayListModel = new ArrayListModel(Arrays.asList(floatArray));
        ValueHolder valueHolder = new ValueHolder((Object)arrayListModel);
        this.stockValuesModel = new ListModelPlug((ValueModel)valueHolder, null, false);
        this.stockValuesModel.setReverseSubjectAccess(this.isReverseOrder());
        return true;
    }

    static List parse(ResourceBundle resourceBundle, String string, String string2, int n) {
        int[] nArray = ByteRecordDescriptor.parseIntArrayParameter(resourceBundle, KEY_DEVICE_IDS, true);
        if (nArray == null) {
            return null;
        }
        ArrayList<ByteRecordDescriptor> arrayList = new ArrayList<ByteRecordDescriptor>();
        List<Integer> list = Arrays.asList(ListUtil.convertToIntegerArray(nArray));
        for (Integer n2 : list) {
            ByteRecordDescriptor byteRecordDescriptor;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(n2);
            String string3 = "0x" + XFormatter.toHex4(n2);
            String string4 = "copydeviceids." + string3;
            int[] nArray2 = ByteRecordDescriptor.parseIntArrayParameter(resourceBundle, string4, false);
            if (nArray2 != null) {
                arrayList2.addAll(Arrays.asList(ListUtil.convertToIntegerArray(nArray2)));
            }
            if (!(byteRecordDescriptor = new ByteRecordDescriptor(string, string2, n, arrayList2)).initialize(resourceBundle, string3)) continue;
            arrayList.add(byteRecordDescriptor);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    static class TemperatureChangeListener
    implements PropertyChangeListener {
        final ValueModel model;
        final String prefix;

        public TemperatureChangeListener(ValueModel valueModel, String string) {
            this.model = valueModel;
            this.prefix = string;
            this.updateString();
        }

        void updateString() {
            String string = this.prefix + " (" + UnitsModel.getInstance().getTemperatureUnitsLabel() + ")";
            this.model.setValue((Object)string);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateString();
        }
    }
}

