/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.ByteRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordGroupDescriptor;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.util.DescriptiveException;
import com.ecmtuning.ecmlink.util.FileUtils;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ResourceLocation;
import com.ecmtuning.ecmlink.util.ResourceLocator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteRecordDescriptorBase {
    protected static final String KEY_RECORD_ID = "recordid";
    protected static final String KEY_LISTBOXNAME = "listboxname";
    protected static final String KEY_RECORD_TYPE = "type";
    protected static final String VALUE_RECORD_TYPE_TABLE = "table";
    protected static final String VALUE_RECORD_TYPE_LIST = "list";
    protected static final String VALUE_RECORD_TYPE_GROUP = "group";
    protected static final String VALUE_RECORD_TYPE_CODE_BINARY = "binarycode";
    private static final int RECORD_TYPE_UNASSIGNED = -1;
    protected static final int RECORD_TYPE_LIST = 1;
    protected static final int RECORD_TYPE_TABLE = 2;
    protected static final int RECORD_TYPE_GROUP = 3;
    protected static final int RECORD_TYPE_CODE_BINARY = 4;
    private static final String RECORDS_DIRECTORY_NAME = "records";
    private static final String DEFINITIONS_PACKAGE_NAME = "definitions";
    protected static String baseDir = ".";
    protected static boolean coreValuesOnly = false;
    private static String initBaseName;
    private static String prevBaseName;
    private static DescriptiveException initEx;
    private static final Logger logger;
    protected static List allDescriptors;
    protected static List allGroups;
    private final String recordId;
    private final String listBoxName;
    private final int recordType;

    public String getRecordId() {
        return this.recordId;
    }

    public String getListBoxName() {
        return this.listBoxName;
    }

    public boolean isTableRecord() {
        return this.recordType == 2;
    }

    public boolean isListRecord() {
        return this.recordType == 1;
    }

    public boolean isCodeBinaryRecord() {
        return this.recordType == 4;
    }

    public boolean isGroupRecord() {
        return this.recordType == 3;
    }

    protected ByteRecordDescriptorBase(String string, String string2, int n) {
        this.recordId = string;
        this.listBoxName = string2;
        this.recordType = n;
    }

    protected static Boolean parseBoolParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, string, bl);
        if (string2 == null) {
            return null;
        }
        return Boolean.valueOf(string2);
    }

    protected static Integer parseIntParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, string, bl);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ByteRecordDescriptorBase.logInitExceptionText("Failed to parse integer " + string + " = '" + string2 + "'");
            return null;
        }
    }

    protected static Float parseFloatParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, string, bl);
        if (string2 == null) {
            return null;
        }
        try {
            return new Float(Float.parseFloat(string2));
        }
        catch (NumberFormatException numberFormatException) {
            ByteRecordDescriptorBase.logInitExceptionText("Failed to parse float " + string + " = '" + string2 + "'");
            return null;
        }
    }

    protected static int[] parseIntArrayParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, string, bl);
        if (string2 == null) {
            return null;
        }
        try {
            String[] stringArray = string2.trim().split(",");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.decode(stringArray[i].trim());
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            ByteRecordDescriptorBase.logInitExceptionText("Failed to parse integer " + string + " = '" + string2 + "'");
            return null;
        }
    }

    protected static float[] parseFloatArrayParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, string, bl);
        if (string2 == null) {
            return null;
        }
        try {
            String[] stringArray = string2.trim().split(",");
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                try {
                    fArray[i] = Float.parseFloat(stringArray[i].trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    fArray[i] = Integer.decode(stringArray[i].trim()).floatValue();
                }
            }
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            ByteRecordDescriptorBase.logInitExceptionText("Failed to parse float " + string + " = '" + string2 + "'");
            return null;
        }
    }

    protected static String[] loadArrayParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, string, bl);
        if (string2 == null) {
            return null;
        }
        try {
            String[] stringArray = string2.trim().split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            return stringArray;
        }
        catch (Exception exception) {
            ByteRecordDescriptorBase.logInitExceptionText("Failed to parse " + string + " = '" + string2 + "'");
            return null;
        }
    }

    protected static String loadParameter(ResourceBundle resourceBundle, String string, boolean bl) {
        try {
            return resourceBundle.getString(string).trim();
        }
        catch (Exception exception) {
            if (bl) {
                ByteRecordDescriptorBase.logInitExceptionText("Failed to load required '" + string + "' value");
            }
            return null;
        }
    }

    protected static synchronized DescriptiveException initDescriptors() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Iterator iterator;
        Object object6;
        Object object7;
        if (allDescriptors != null) {
            return null;
        }
        allDescriptors = new ArrayList();
        String string = FileUtils.constructPackagePath(ByteRecordDescriptor.class) + "." + DEFINITIONS_PACKAGE_NAME;
        HashMap<Object, NamedBundle> hashMap = new HashMap<Object, NamedBundle>();
        try {
            object7 = new ResourceLocator(new String[]{string}, ".properties");
            object6 = ((ResourceLocator)object7).getAllResourceLocations();
            iterator = object6.iterator();
            while (iterator.hasNext()) {
                object52 = (ResourceLocation)iterator.next();
                object4 = ((ResourceLocation)object52).getResourceName();
                try {
                    object3 = ResourceBundle.getBundle((String)object4, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
                    hashMap.put(object4, new NamedBundle((String)object4, (ResourceBundle)object3));
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Record definition '" + (String)object4 + "' failed to load.  Ignoring.", exception);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to load record definitions", exception);
        }
        object7 = FilenameModel.buildUserResourcesPath() + File.separator + RECORDS_DIRECTORY_NAME;
        object6 = new File((String)object7);
        if (((File)object6).exists() && ((File)object6).isDirectory()) {
            iterator = FileUtils.listResourceProperties((String)object7);
            object52 = iterator.iterator();
            while (object52.hasNext()) {
                object4 = (String)object52.next();
                object3 = string + "." + (String)object4;
                object2 = (String)object7 + File.separator + (String)object4 + ".properties";
                try {
                    object = new BufferedInputStream(new FileInputStream((String)object2));
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle((InputStream)object);
                    if (hashMap.containsKey(object3)) {
                        logger.info((String)object4 + " is being overridden by " + (String)object2);
                    }
                    hashMap.put(object3, new NamedBundle((String)object2, propertyResourceBundle));
                    ((BufferedInputStream)object).close();
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to load '" + (String)object2 + "'.  Ignoring.", exception);
                }
            }
        }
        initEx = new DescriptiveException("");
        for (Object object52 : hashMap.values()) {
            initBaseName = ((NamedBundle)object52).bundleName;
            object4 = ((NamedBundle)object52).bundle;
            logger.finer("Processing resourceName: " + ((NamedBundle)object52).bundleName);
            object3 = ByteRecordDescriptorBase.parse((ResourceBundle)object4);
            if (object3 == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (ByteRecordDescriptor)object2.next();
                boolean bl = false;
                Iterator iterator2 = allDescriptors.iterator();
                while (!bl && iterator2.hasNext()) {
                    List<Integer> list;
                    List<Integer> list2;
                    ByteRecordDescriptor byteRecordDescriptor = (ByteRecordDescriptor)iterator2.next();
                    if (byteRecordDescriptor.isCompatibleWithDescriptor((ByteRecordDescriptor)object)) {
                        ByteRecordDescriptorBase.logInitExceptionText("Found multiple deviceId matches on '" + ((ByteRecordDescriptorBase)object).getRecordId() + "', dropping duplicate.");
                        bl = true;
                    }
                    if (byteRecordDescriptor.getRecordId().equals(((ByteRecordDescriptorBase)object).getRecordId()) && byteRecordDescriptor.getByteSize() != ((ByteRecordDescriptor)object).getByteSize()) {
                        ByteRecordDescriptorBase.logInitExceptionText("Found instances of '" + byteRecordDescriptor.getRecordId() + "' with varying sizes.");
                        bl = true;
                    }
                    if (!ListUtil.containsAny(byteRecordDescriptor.getSupportedDeviceDefIds(), ((ByteRecordDescriptor)object).getSupportedDeviceDefIds()) || !ListUtil.containsAny(list2 = Arrays.asList(ListUtil.convertToIntegerArray(byteRecordDescriptor.getByteAddrs())), list = Arrays.asList(ListUtil.convertToIntegerArray(((ByteRecordDescriptor)object).getByteAddrs())))) continue;
                    ByteRecordDescriptorBase.logInitExceptionText(byteRecordDescriptor.getRecordId() + " overlaps with " + ((ByteRecordDescriptorBase)object).getRecordId());
                    bl = true;
                }
                if (bl) continue;
                allDescriptors.add(object);
            }
        }
        if (initEx.getMessage().length() > 0) {
            return initEx;
        }
        return null;
    }

    private static boolean isBetween(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private static List parse(ResourceBundle resourceBundle) {
        String string = ByteRecordDescriptorBase.loadParameter(resourceBundle, KEY_RECORD_ID, true);
        String string2 = ByteRecordDescriptorBase.loadParameter(resourceBundle, KEY_LISTBOXNAME, true);
        String string3 = ByteRecordDescriptorBase.loadParameter(resourceBundle, KEY_RECORD_TYPE, true);
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        int n = -1;
        if (string3.equalsIgnoreCase(VALUE_RECORD_TYPE_LIST)) {
            n = 1;
        } else if (string3.equalsIgnoreCase(VALUE_RECORD_TYPE_TABLE)) {
            n = 2;
        } else if (string3.equalsIgnoreCase(VALUE_RECORD_TYPE_GROUP)) {
            n = 3;
        } else if (string3.equalsIgnoreCase(VALUE_RECORD_TYPE_CODE_BINARY)) {
            n = 4;
        } else {
            ByteRecordDescriptorBase.logInitExceptionText("Failed to parse type '" + string3 + "'");
            return null;
        }
        if (n == 3) {
            ByteRecordGroupDescriptor byteRecordGroupDescriptor = ByteRecordGroupDescriptor.parse(resourceBundle, string, string2);
            if (byteRecordGroupDescriptor != null) {
                allGroups.add(byteRecordGroupDescriptor);
            }
            return null;
        }
        if (n == 1 || n == 2 || n == 4) {
            return ByteRecordDescriptor.parse(resourceBundle, string, string2, n);
        }
        return null;
    }

    protected static void logInitExceptionText(String string) {
        if (initBaseName != prevBaseName) {
            initEx.appendLine(initBaseName + ":");
            prevBaseName = initBaseName;
        }
        initEx.appendLine("    " + string);
        logger.warning(initBaseName + ": " + string);
    }

    public static List getCompatibleGroups(List list) {
        List list2 = ByteRecordDescriptorBase.createFullGroups(ByteRecordDescriptorBase.removeSubsets(ByteRecordDescriptorBase.findBasicGroupMatches(list)), list);
        return list2.size() == 0 ? null : list2;
    }

    private static List createFullGroups(List list, List list2) {
        ArrayList<ByteRecordGroupDescriptor> arrayList = new ArrayList<ByteRecordGroupDescriptor>();
        for (ByteRecordGroupDescriptor byteRecordGroupDescriptor : list) {
            if (!byteRecordGroupDescriptor.matches(list2)) continue;
            arrayList.add(byteRecordGroupDescriptor.createFullGroupDescriptor(list2));
        }
        return arrayList;
    }

    private static List removeSubsets(List list) {
        Iterator iterator = list.iterator();
        ArrayList<ByteRecordGroupDescriptor> arrayList = new ArrayList<ByteRecordGroupDescriptor>();
        while (iterator.hasNext()) {
            ByteRecordGroupDescriptor byteRecordGroupDescriptor = (ByteRecordGroupDescriptor)iterator.next();
            Iterator iterator2 = list.iterator();
            boolean bl = false;
            while (!bl && iterator2.hasNext()) {
                ByteRecordGroupDescriptor byteRecordGroupDescriptor2 = (ByteRecordGroupDescriptor)iterator2.next();
                if (byteRecordGroupDescriptor2 == byteRecordGroupDescriptor) continue;
                bl = byteRecordGroupDescriptor2.isSupersetOf(byteRecordGroupDescriptor);
            }
            if (bl) continue;
            arrayList.add(byteRecordGroupDescriptor);
        }
        return arrayList;
    }

    private static List findBasicGroupMatches(List list) {
        ArrayList<ByteRecordGroupDescriptor> arrayList = new ArrayList<ByteRecordGroupDescriptor>();
        for (ByteRecordGroupDescriptor byteRecordGroupDescriptor : allGroups) {
            if (!byteRecordGroupDescriptor.matches(list)) continue;
            arrayList.add(byteRecordGroupDescriptor);
        }
        return arrayList;
    }

    public static List getDescriptorsForDevice(int n, int n2) {
        DescriptiveException descriptiveException = ByteRecordDescriptorBase.initDescriptors();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(descriptiveException);
        for (ByteRecordDescriptor byteRecordDescriptor : allDescriptors) {
            if (!byteRecordDescriptor.isCompatibleWithDevice(n, n2)) continue;
            arrayList.add(byteRecordDescriptor);
        }
        return arrayList;
    }

    public static ByteRecordDescriptor getDescriptorByName(int n, int n2, String string) {
        List list = ByteRecordDescriptorBase.getDescriptorsForDevice(n, n2);
        Iterator iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            ByteRecordDescriptor byteRecordDescriptor = (ByteRecordDescriptor)iterator.next();
            if (!byteRecordDescriptor.getRecordId().equals(string)) continue;
            return byteRecordDescriptor;
        }
        return null;
    }

    public static List getCompatibleDescriptors(Collection collection) {
        DescriptiveException descriptiveException = ByteRecordDescriptorBase.initDescriptors();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(descriptiveException);
        block0: for (ByteRecordDescriptor byteRecordDescriptor : allDescriptors) {
            for (ByteRecord byteRecord : collection) {
                if (!byteRecordDescriptor.isCompatibleWithRecord(byteRecord)) continue;
                arrayList.add(byteRecordDescriptor);
                continue block0;
            }
        }
        return arrayList;
    }

    public static void setBaseDir(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        baseDir = string;
    }

    public static void setCoreValuesOnly(boolean bl) {
        coreValuesOnly = true;
    }

    static {
        prevBaseName = null;
        logger = Logger.getLogger(ByteRecordDescriptorBase.class.getName());
        allGroups = new ArrayList();
    }

    private static class NamedBundle {
        final String bundleName;
        final ResourceBundle bundle;

        NamedBundle(String string, ResourceBundle resourceBundle) {
            this.bundleName = string;
            this.bundle = resourceBundle;
        }
    }
}

