/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.util.model.ObjectFilter;

public class ByteRecordFilter
implements ObjectFilter {
    protected float scaleFactor;
    protected float minValue;
    protected float maxValue;
    protected float offsetValue;
    protected int minRawValue;
    protected int maxRawValue;

    public ByteRecordFilter(float f, float f2, float f3, float f4) {
        this.scaleFactor = f;
        this.minValue = f2;
        this.maxValue = f3;
        this.offsetValue = f4;
        this.minRawValue = 0;
        this.maxRawValue = 255;
    }

    @Override
    public Object filter(Object object) {
        return new Float(this.convertFromRawValue(((Number)object).intValue()));
    }

    @Override
    public Object unfilter(Object object, Object object2) throws Exception {
        return new Float(this.convertToRawValue(((Float)object).floatValue()));
    }

    protected int scaleToRawValue(float f) {
        return Math.round(f / this.scaleFactor);
    }

    protected float scaleFromRawValue(int n) {
        return (float)n * this.scaleFactor;
    }

    protected int convertToRawValue(float f) {
        f = (f -= this.offsetValue) < this.minValue ? this.minValue : (f > this.maxValue ? this.maxValue : f);
        int n = this.scaleToRawValue(f);
        n = n < this.minRawValue ? this.minRawValue : (n > this.maxRawValue ? this.maxRawValue : n);
        return n;
    }

    protected float convertFromRawValue(int n) {
        n = n < this.minRawValue ? this.minRawValue : (n > this.maxRawValue ? this.maxRawValue : n);
        float f = this.scaleFromRawValue(n);
        f = f < this.minValue ? this.minValue : (f > this.maxValue ? this.maxValue : f);
        return f += this.offsetValue;
    }
}

