/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ByteRecordSet
extends RecordSet {
    private final int originalDefinitionId;
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 1263332511627593028L;
    protected static RecordSet.RecordReader reader = new RecordSet.RecordReader(){

        @Override
        public BaseRecord read(DataInputStream dataInputStream) throws IOException {
            return ByteRecord.read(dataInputStream);
        }
    };

    public ByteRecordSet(int n, int n2) {
        super(n);
        this.originalDefinitionId = n2;
    }

    public ByteRecordSet(ByteRecordSet byteRecordSet) {
        this(byteRecordSet, byteRecordSet.getPersistentRecordMapCopy());
    }

    private ByteRecordSet(ByteRecordSet byteRecordSet, Map map) {
        super(byteRecordSet.getDeviceId());
        this.originalDefinitionId = byteRecordSet.originalDefinitionId;
        this.setPersistedMap(map);
    }

    public int getDefinitionId() {
        return this.originalDefinitionId;
    }

    @Override
    public RecordSet createSubset(Object[] objectArray) {
        return new ByteRecordSet(this, RecordSet.cloneRecordMap(this.getPersistentRecordMap(), objectArray));
    }

    @Override
    public synchronized void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 1263332511627593028L, 1);
        dataOutputStream.writeInt(this.originalDeviceId);
        dataOutputStream.writeInt(this.originalDefinitionId);
        ByteRecordSet.writeRecordMap(dataOutputStream, this.volatileRecordMap);
    }

    public static synchronized void writeNull(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 1263332511627593028L, 1);
        dataOutputStream.writeInt(0);
    }

    public static RecordSet read(DataInputStream dataInputStream) throws IOException {
        int n = ByteRecordSet.readDeviceId(dataInputStream);
        if (n == 0) {
            return null;
        }
        int n2 = dataInputStream.readInt();
        Map map = ByteRecordSet.readRecordMap(dataInputStream, reader);
        ByteRecordSet byteRecordSet = new ByteRecordSet(n, n2);
        byteRecordSet.setPersistedMap(map);
        return byteRecordSet;
    }

    public static int readDeviceId(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "ByteRecordSet", 1263332511627593028L, 1);
        int n = dataInputStream.readInt();
        return n;
    }
}

