/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSetFile;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ByteRecordSetFile
extends RecordSetFile {
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = 8035563719348299419L;

    public ByteRecordSetFile(RecordSet recordSet, File file) {
        super(recordSet, file);
    }

    @Override
    public void writeToFile(File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        FileUtils.writeMarkerAndVersion(dataOutputStream, 8035563719348299419L, 1);
        this.getRecordSet().write(dataOutputStream);
        dataOutputStream.close();
    }

    public static RecordSetFile load(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        FileUtils.readFileVersion(dataInputStream, "ByteRecordSetFile", 8035563719348299419L, 1);
        RecordSet recordSet = ByteRecordSet.read(dataInputStream);
        dataInputStream.close();
        return new ByteRecordSetFile(recordSet, file);
    }

    public static int readDeviceId(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "ByteRecordSetFile", 8035563719348299419L, 1);
        int n = ByteRecordSet.readDeviceId(dataInputStream);
        return n;
    }
}

