/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.ConfigRecordAdapterInterface;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class ConfigRecord
extends BaseRecord {
    private static final int FILE_VERSION = 1;
    private static final long FILE_MARKER = -7272509545061729924L;
    private static final Logger logger = Logger.getLogger(ConfigRecord.class.getName());
    private static Collection allKnownRecordAdapters = new ArrayList();

    public ConfigRecord(int n, int n2) {
        super(n, ConfigRecord.constructRecordId(n2));
    }

    public static Object constructRecordId(int n) {
        return new Integer(n);
    }

    public boolean localCacheOK() {
        return true;
    }

    public void setFloatField(String string, float f) {
        Float8Field float8Field = (Float8Field)this.getField(string);
        float8Field.setValue(new Float(f));
    }

    public float getFloatField(String string) {
        return ((Number)this.getField(string).getValue()).floatValue();
    }

    public int getIntField(String string) {
        return ((Number)this.getField(string).getValue()).intValue();
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, -7272509545061729924L, 1);
        dataOutputStream.writeInt(this.deviceId);
        dataOutputStream.writeInt((Integer)this.getRecordID());
        int[] nArray = new int[this.getByteLength()];
        this.putToBytes(nArray, 0);
        dataOutputStream.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public static ConfigRecord read(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "ConfigRecord", -7272509545061729924L, 1);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        ConfigRecord configRecord = ConfigRecord.createRecord(n, n2);
        if (configRecord == null) {
            logger.warning("Failed to read record " + n + ", " + n2 + ".  Ignoring record data.");
        }
        int n3 = dataInputStream.readInt();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        if (configRecord != null) {
            configRecord.setFromBytes(nArray, 0);
        }
        return configRecord;
    }

    public static String getRecordDescription(int n, int n2) {
        String string = null;
        Iterator iterator = allKnownRecordAdapters.iterator();
        while (string == null && iterator.hasNext()) {
            ConfigRecordAdapterInterface configRecordAdapterInterface = (ConfigRecordAdapterInterface)iterator.next();
            string = configRecordAdapterInterface.getRecordDescription(n, n2);
        }
        if (string == null) {
            string = "Configuration record id " + n2;
        }
        return string;
    }

    public static ConfigRecord createRecord(int n, int n2) {
        ConfigRecord configRecord = null;
        Iterator iterator = allKnownRecordAdapters.iterator();
        while (configRecord == null && iterator.hasNext()) {
            ConfigRecordAdapterInterface configRecordAdapterInterface = (ConfigRecordAdapterInterface)iterator.next();
            configRecord = configRecordAdapterInterface.createRecord(n, n2);
        }
        return configRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKnownRecordAdapter(ConfigRecordAdapterInterface configRecordAdapterInterface) {
        Collection collection = allKnownRecordAdapters;
        synchronized (collection) {
            if (!allKnownRecordAdapters.contains(configRecordAdapterInterface)) {
                allKnownRecordAdapters.add(configRecordAdapterInterface);
            }
        }
    }
}

